/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.extra;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.registry.magic.SpiritualMagics;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class SoundManipulationSkill
extends Skill {
    public SoundManipulationSkill() {
        super(Skill.SkillType.EXTRA);
    }

    @Override
    public double learningCost() {
        return 1000.0;
    }

    @Override
    public boolean meetEPRequirement(Player entity, double newEP) {
        return SoundManipulationSkill.learnSoundManipulation((LivingEntity)entity);
    }

    public void onSkillMastered(ManasSkillInstance instance, LivingEntity entity) {
        if (TensuraEPCapability.getEP(entity) < 400000.0) {
            return;
        }
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        ManasSkill skill = (ManasSkill)ExtraSkills.SOUND_DOMINATION.get();
        TensuraSkillInstance manipulation = new TensuraSkillInstance(skill);
        manipulation.setMastery(-100);
        if (storage.learnSkill((ManasSkillInstance)manipulation) && entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_available", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), false);
        }
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity living, LivingHurtEvent e) {
        if (!instance.isToggled()) {
            return;
        }
        if (SkillUtils.isSkillToggled((Entity)living, (ManasSkill)ExtraSkills.SOUND_DOMINATION.get())) {
            return;
        }
        if (DamageSourceHelper.isSoundDamage(e.getSource())) {
            e.setAmount(e.getAmount() * 2.0f);
        }
        this.addMasteryPoint(instance, living);
    }

    public static boolean learnSoundManipulation(LivingEntity entity) {
        int skills = 0;
        for (ManasSkillInstance skill : SkillAPI.getSkillsFrom((Entity)entity).getLearnedSkills()) {
            if (!SoundManipulationSkill.isSoundSKill(skill, entity)) continue;
            ++skills;
        }
        return skills >= 2;
    }

    private static boolean isSoundSKill(ManasSkillInstance instance, LivingEntity entity) {
        if (!instance.isMastered(entity)) {
            return false;
        }
        if (instance.getSkill().equals(IntrinsicSkills.ULTRASONIC_WAVES.get())) {
            return true;
        }
        if (instance.getSkill().equals(SpiritualMagics.WIND.get())) {
            return true;
        }
        if (instance.getSkill().equals(SpiritualMagics.WIND_BLADE.get())) {
            return true;
        }
        return instance.getSkill().equals(SpiritualMagics.AERIAL_BLADE.get());
    }
}

