/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.extra;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.human.HinataSakaguchiEntity;
import com.github.manasmods.tensura.entity.magic.beam.BeamProjectile;
import com.github.manasmods.tensura.entity.magic.beam.SpatialRayProjectile;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class SpatialDominationSkill
extends Skill {
    private static final String FAULT = "9e5add62-dbfa-4130-ab0b-6612a8f4c4aa";

    public SpatialDominationSkill() {
        super(Skill.SkillType.EXTRA);
        this.addHeldAttributeModifier(Attributes.f_22279_, FAULT, -0.5, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    @Override
    public boolean meetEPRequirement(Player entity, double newEP) {
        if (!SkillUtils.isSkillMastered((LivingEntity)entity, (ManasSkill)ExtraSkills.SPATIAL_MANIPULATION.get())) {
            return false;
        }
        return newEP > 400000.0;
    }

    @Override
    public double learningCost() {
        return 200.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    @Override
    public int modes() {
        return 4;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return switch (instance.getMode()) {
                case 4 -> {
                    if (instance.getOrCreateTag().m_128451_("DimensionRay") >= 100) {
                        yield 3;
                    }
                    yield 2;
                }
                case 3 -> 2;
                case 2 -> 1;
                default -> 4;
            };
        }
        return switch (instance.getMode()) {
            case 3 -> 4;
            case 2 -> {
                if (instance.getOrCreateTag().m_128451_("DimensionRay") >= 100) {
                    yield 3;
                }
                yield 4;
            }
            case 1 -> 2;
            default -> 1;
        };
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.spatial_domination.warp_shot");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.spatial_domination.ray");
            case 3 -> Component.m_237115_((String)"tensura.skill.mode.spatial_domination.storm");
            case 4 -> Component.m_237115_((String)"tensura.skill.mode.spatial_domination.fault_field");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 2 -> 5000.0;
            case 3 -> 50000.0;
            case 4 -> 2000.0;
            default -> 0.0;
        };
    }

    @Override
    public String modeLearningId(int mode) {
        return switch (mode) {
            case 2 -> "DimensionRay";
            case 3 -> "DimensionStorm";
            case 4 -> "FaultField";
            default -> "None";
        };
    }

    public boolean canIgnoreCoolDown(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMastery() < 0) {
            return false;
        }
        return instance.getMode() == 1;
    }

    public void onTakenDamage(ManasSkillInstance instance, LivingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        if (!SpatialDominationSkill.hasFaultField(entity)) {
            return;
        }
        DamageSource damageSource = event.getSource();
        if (damageSource.m_19378_()) {
            return;
        }
        if (DamageSourceHelper.isSpiritual(damageSource)) {
            return;
        }
        if (DamageSourceHelper.isSpatialDamage(damageSource)) {
            return;
        }
        if (SkillUtils.haveSeveranceAttack(damageSource, entity)) {
            return;
        }
        float damageCanceled = (int)event.getAmount();
        double lackedMagicule = SkillHelper.outOfMagiculeStillConsume(entity, damageCanceled * 50.0f);
        if (lackedMagicule > 0.0) {
            damageCanceled = (float)((double)damageCanceled - lackedMagicule / 50.0);
            event.setAmount(event.getAmount() - damageCanceled);
        } else {
            event.setCanceled(true);
        }
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity living, LivingHurtEvent e) {
        if (!instance.isToggled()) {
            return;
        }
        if (DamageSourceHelper.isSpatialDamage(e.getSource())) {
            e.setAmount(e.getAmount() * 4.0f);
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        Level level = entity.m_9236_();
        CompoundTag tag = instance.getOrCreateTag();
        switch (instance.getMode()) {
            case 2: {
                int learnPoint = tag.m_128451_("DimensionRay");
                if (learnPoint < 100) {
                    if (SkillHelper.outOfMagicule(entity, instance)) {
                        return;
                    }
                    tag.m_128405_("DimensionRay", learnPoint + SkillUtils.getEarningLearnPoint(instance, entity, true));
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        if (tag.m_128451_("DimensionRay") >= 100) {
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire_learning", (Object[])new Object[]{this.getModeName(2)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                        } else {
                            instance.setCoolDown(10);
                            SkillUtils.learningFailPenalty(entity);
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_points_added", (Object[])new Object[]{this.getModeName(2)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
                        }
                        player.m_6330_(SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                } else {
                    instance.getOrCreateTag().m_128405_("BeamID", 0);
                }
                instance.markDirty();
                break;
            }
            case 3: {
                Vec3 pos;
                if (SkillHelper.outOfMagicule(entity, instance)) {
                    return;
                }
                int learnPoint = tag.m_128451_("DimensionStorm");
                if (learnPoint < 100) {
                    tag.m_128405_("DimensionStorm", learnPoint + SkillUtils.getEarningLearnPoint(instance, entity, true));
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        if (tag.m_128451_("DimensionStorm") >= 100) {
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire_learning", (Object[])new Object[]{this.getModeName(3)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                        } else {
                            instance.setCoolDown(10);
                            SkillUtils.learningFailPenalty(entity);
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_points_added", (Object[])new Object[]{this.getModeName(3)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
                        }
                        player.m_6330_(SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    instance.markDirty();
                    return;
                }
                LivingEntity target = SkillHelper.getTargetingEntity(entity, 30.0, false, false);
                if (target != null) {
                    pos = target.m_146892_();
                } else {
                    BlockHitResult result = SkillHelper.getPlayerPOVHitResult(level, (Entity)entity, ClipContext.Fluid.NONE, 30.0);
                    pos = result.m_82450_();
                }
                instance.setCoolDown(instance.isMastered(entity) ? 10 : 20);
                level.m_6263_(null, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), SoundEvents.f_215771_, SoundSource.PLAYERS, 5.0f, 1.0f);
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123747_, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
                int rayAmount = instance.isMastered(entity) ? 30 : 20;
                for (int i = 0; i < rayAmount; ++i) {
                    Vec3 startOffset = new Vec3(0.0, 1.0 - Math.random() * 2.0, 0.6).m_82541_().m_82490_(20.0).m_82524_(360.0f * (float)i * ((float)Math.PI / 180) / (float)rayAmount);
                    SpatialRayProjectile ray = new SpatialRayProjectile(entity.m_9236_(), entity);
                    ray.setFollowingOwner(false);
                    ray.setLife(20);
                    ray.setSize(0.75f);
                    ray.setRange(10.0f);
                    ray.setSkill(instance);
                    Vec3 rayPos = pos.m_82549_(startOffset);
                    ray.m_146884_(rayPos.m_82549_(pos.m_82546_(rayPos).m_82541_().m_82490_(10.0)));
                    ray.setTargetPos(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
                    ray.setDamage(instance.isMastered(entity) ? 100.0f : 50.0f);
                    ray.setMpCost(this.auraCost(entity, instance));
                    entity.m_9236_().m_7967_((Entity)ray);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)ray, (ParticleOptions)ParticleTypes.f_123747_);
                }
                break;
            }
            case 4: {
                if (SkillHelper.outOfMagicule(entity, instance)) {
                    return;
                }
                int learnPoint = tag.m_128451_("FaultField");
                if (learnPoint >= 100) break;
                tag.m_128405_("FaultField", learnPoint + SkillUtils.getEarningLearnPoint(instance, entity, true));
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (tag.m_128451_("FaultField") >= 100) {
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire_learning", (Object[])new Object[]{this.getModeName(4)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                    } else {
                        instance.setCoolDown(10);
                        SkillUtils.learningFailPenalty(entity);
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_points_added", (Object[])new Object[]{this.getModeName(4)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
                    }
                    player.m_6330_(SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                instance.markDirty();
            }
        }
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (instance.getMode() == 2 && !instance.onCoolDown()) {
            CompoundTag tag = instance.getOrCreateTag();
            if (tag.m_128451_("DimensionRay") < 100) {
                return;
            }
            if (!this.hasAttributeApplied(entity, Attributes.f_22279_, FAULT)) {
                return;
            }
            instance.setCoolDown(instance.isMastered(entity) ? 7 : 10);
        }
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        CompoundTag tag = instance.getOrCreateTag();
        if (instance.getMode() == 2) {
            if (tag.m_128451_("DimensionRay") < 100) {
                return false;
            }
            if (heldTicks % 60 == 0 && heldTicks > 0) {
                this.addMasteryPoint(instance, entity);
            }
            double cost = this.magiculeCost(entity, instance);
            BeamProjectile.spawnLastingBeam((EntityType<? extends BeamProjectile>)((EntityType)TensuraEntityTypes.SPATIAL_RAY.get()), instance.isMastered(entity) ? 100.0f : 50.0f, 0.5f, entity, instance, cost, cost, heldTicks);
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 0.8f, 0.5f);
            if (heldTicks > 60) {
                instance.setCoolDown(instance.isMastered(entity) ? 7 : 10);
                this.removeHeldAttributeModifiers(instance, entity);
                return false;
            }
            return true;
        }
        if (instance.getMode() != 4) {
            return false;
        }
        if (tag.m_128451_("FaultField") < 100) {
            return false;
        }
        if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule(entity, instance)) {
            return false;
        }
        if (heldTicks % 60 == 0 && heldTicks > 0) {
            this.addMasteryPoint(instance, entity);
        }
        return true;
    }

    public void addHeldAttributeModifiers(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMode() != 4 || instance.getOrCreateTag().m_128451_("FaultField") < 100) {
            return;
        }
        super.addHeldAttributeModifiers(instance, entity);
    }

    public static boolean hasFaultField(LivingEntity entity) {
        HinataSakaguchiEntity hinata;
        if (entity instanceof HinataSakaguchiEntity && (hinata = (HinataSakaguchiEntity)entity).getPhase() == 1) {
            return true;
        }
        AttributeInstance attributeInstance = entity.m_21051_(Attributes.f_22279_);
        if (attributeInstance == null) {
            return false;
        }
        return attributeInstance.m_22111_(UUID.fromString(FAULT)) != null;
    }
}

