/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.extra;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.projectile.WebBulletProjectile;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.items.TensuraToolItems;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class StickySteelThreadSkill
extends Skill {
    public StickySteelThreadSkill() {
        super(Skill.SkillType.EXTRA);
    }

    @Override
    public double learningCost() {
        return 200.0;
    }

    @Override
    public int modes() {
        return 4;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 4 : instance.getMode() - 1;
        }
        return instance.getMode() == 4 ? 1 : instance.getMode() + 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.sticky_steel_thread.sticky");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.sticky_steel_thread.steel");
            case 3 -> Component.m_237115_((String)"tensura.skill.mode.sticky_steel_thread.slinger");
            case 4 -> Component.m_237115_((String)"tensura.skill.mode.sticky_steel_thread.arcane_thread");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 2 -> 100.0;
            case 1 -> 50.0;
            default -> 200.0;
        };
    }

    @Override
    public String modeLearningId(int mode) {
        if (mode == 4) {
            return "ArcaneThread";
        }
        return "None";
    }

    public boolean canIgnoreCoolDown(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMastery() < 0) {
            return false;
        }
        CompoundTag tag = instance.getOrCreateTag();
        return instance.getMode() != 4 && tag.m_128451_("ArcaneThread") <= 100;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        Level level = entity.m_9236_();
        CompoundTag tag = instance.getOrCreateTag();
        switch (instance.getMode()) {
            case 1: {
                this.addMasteryPoint(instance, entity);
                instance.setCoolDown(instance.isMastered(entity) ? 1 : 3);
                this.shootWebBullet(entity, level, ((Item)TensuraToolItems.STICKY_WEB_CARTRIDGE.get()).m_7968_());
                break;
            }
            case 2: {
                this.addMasteryPoint(instance, entity);
                instance.setCoolDown(instance.isMastered(entity) ? 1 : 3);
                this.shootWebBullet(entity, level, ((Item)TensuraToolItems.STICKY_STEEL_WEB_CARTRIDGE.get()).m_7968_());
                break;
            }
            case 3: {
                Entity oldBullet = entity.m_9236_().m_6815_(tag.m_128451_("BulletID"));
                if (oldBullet instanceof WebBulletProjectile) {
                    oldBullet.m_146870_();
                }
                if (entity.m_6144_()) {
                    return;
                }
                WebBulletProjectile bullet = new WebBulletProjectile(level, entity, true, ((Item)TensuraToolItems.WEB_CARTRIDGE.get()).m_7968_());
                bullet.setSlinger(true);
                Vector3f vector3f = new Vector3f(entity.m_20252_(1.0f));
                bullet.m_6686_(vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_(), 2.0f, 0.0f);
                entity.m_6674_(entity.m_7655_());
                level.m_7967_((Entity)bullet);
                tag.m_128405_("BulletID", bullet.m_19879_());
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 4: {
                int learnPoint = tag.m_128451_("ArcaneThread");
                if (learnPoint < 100) {
                    tag.m_128405_("ArcaneThread", learnPoint + SkillUtils.getEarningLearnPoint(instance, entity, true));
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        if (tag.m_128451_("ArcaneThread") >= 100) {
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire_learning", (Object[])new Object[]{this.getModeName(4)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                        } else {
                            instance.setCoolDown(10);
                            SkillUtils.learningFailPenalty(entity);
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_points_added", (Object[])new Object[]{this.getModeName(4)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
                        }
                        player.m_6330_(SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    instance.markDirty();
                    return;
                }
                double distance = instance.isMastered(entity) ? 10.0 : 20.0;
                LivingEntity target = SkillHelper.getTargetingEntity(entity, distance, false, true);
                if (target == null) {
                    return;
                }
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50033_.m_49966_()), 1.0);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50033_.m_49966_()), 2.0);
                if (this.getArcaneThreadSource(target, instance.isMastered(entity) ? 300 : 400) == entity) {
                    this.addMasteryPoint(instance, entity);
                    instance.setCoolDown(instance.isMastered(entity) ? 3 : 5);
                    target.m_6469_((DamageSource)this.sourceWithMP(TensuraDamageSources.steelThread((Entity)entity), entity, instance), instance.isMastered(entity) ? 60.0f : 30.0f);
                    target.m_21195_((MobEffect)TensuraMobEffects.WEBBED.get());
                    target.m_21195_((MobEffect)TensuraMobEffects.SILENCE.get());
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123766_, 2.0);
                    entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                if (target.m_21023_((MobEffect)TensuraMobEffects.WEBBED.get())) break;
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12054_, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (TensuraEPCapability.getEP(target) <= TensuraEPCapability.getEP(entity)) {
                    SkillHelper.checkThenAddEffectSource(target, (Entity)entity, new MobEffectInstance((MobEffect)TensuraMobEffects.WEBBED.get(), 500, 0, true, true, false));
                }
                SkillHelper.checkThenAddEffectSource(target, (Entity)entity, new MobEffectInstance((MobEffect)TensuraMobEffects.SILENCE.get(), 500, 0, true, true, false));
            }
        }
    }

    @Nullable
    private Player getArcaneThreadSource(LivingEntity target, int duration) {
        MobEffectInstance webbed = target.m_21124_((MobEffect)TensuraMobEffects.WEBBED.get());
        if (webbed == null) {
            return null;
        }
        if (webbed.m_19557_() < duration) {
            return null;
        }
        return TensuraEffectsCapability.getEffectSource(target, (MobEffect)TensuraMobEffects.WEBBED.get());
    }

    private void shootWebBullet(LivingEntity entity, Level level, ItemStack ammo) {
        WebBulletProjectile bullet = new WebBulletProjectile(level, entity, true, ammo);
        Vector3f vector3f = new Vector3f(entity.m_20252_(1.0f));
        bullet.m_6686_(vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_(), 1.0f, 0.0f);
        entity.m_6674_(entity.m_7655_());
        level.m_7967_((Entity)bullet);
        entity.m_21011_(InteractionHand.MAIN_HAND, true);
        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }
}

