/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.extra;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class ThoughtAccelerationSkill
extends Skill {
    protected static final UUID ACCELERATION = UUID.fromString("46dc5eee-34e9-4a6c-ad3d-58048cb06c6f");

    public ThoughtAccelerationSkill() {
        super(Skill.SkillType.EXTRA);
    }

    @Override
    public boolean meetEPRequirement(Player entity, double newEP) {
        return newEP > 8000.0;
    }

    @Override
    public double learningCost() {
        return 50.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return instance.getMastery() >= 0;
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle(instance, entity, ACCELERATION, true);
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle(instance, entity, ACCELERATION, false);
    }

    public static void onToggle(ManasSkillInstance instance, LivingEntity entity, UUID uuid, boolean on) {
        if (on) {
            AttributeModifier speedModifier;
            AttributeInstance attackSpeed;
            AttributeModifier speedModifier2;
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
            AttributeInstance speed = entity.m_21051_(Attributes.f_22279_);
            if (speed != null && !speed.m_22109_(speedModifier2 = new AttributeModifier(uuid, "Thought Acceleration", instance.isMastered(entity) ? 0.02 : 0.01, AttributeModifier.Operation.ADDITION))) {
                speed.m_22125_(speedModifier2);
            }
            if ((attackSpeed = entity.m_21051_(Attributes.f_22283_)) != null && !attackSpeed.m_22109_(speedModifier = new AttributeModifier(uuid, "Thought Acceleration", instance.isMastered(entity) ? 0.4 : 0.2, AttributeModifier.Operation.ADDITION))) {
                attackSpeed.m_22125_(speedModifier);
            }
        } else {
            AttributeInstance attackSpeed;
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 0.5f, 0.5f);
            AttributeInstance speed = entity.m_21051_(Attributes.f_22279_);
            if (speed != null) {
                speed.m_22127_(uuid);
            }
            if ((attackSpeed = entity.m_21051_(Attributes.f_22283_)) != null) {
                attackSpeed.m_22127_(uuid);
            }
        }
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isToggled();
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        CompoundTag tag = instance.getOrCreateTag();
        int time = tag.m_128451_("activatedTimes");
        if (time % 10 == 0) {
            this.addMasteryPoint(instance, entity);
        }
        tag.m_128405_("activatedTimes", time + 1);
    }
}

