/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.extra;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;

public class UltraInstinctSkill
extends Skill {
    public UltraInstinctSkill() {
        super(Skill.SkillType.EXTRA);
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public void onBeingDamaged(ManasSkillInstance instance, LivingAttackEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!instance.isToggled()) {
            return;
        }
        DamageSource damageSource = event.getSource();
        if (damageSource.m_19378_()) {
            return;
        }
        if (damageSource.m_7640_() == null || damageSource.m_7640_() != damageSource.m_7639_()) {
            return;
        }
        if (damageSource.m_19387_()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (entity.m_217043_().m_188503_(5) != 1) {
            return;
        }
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123766_, 1.0);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 2.0f, 1.0f);
        event.setCanceled(true);
        if (SkillUtils.canNegateDodge(entity, damageSource)) {
            event.setCanceled(false);
        } else {
            CompoundTag tag = instance.getOrCreateTag();
            int time = tag.m_128451_("activatedTimes");
            if (time % 6 == 0) {
                this.addMasteryPoint(instance, entity);
            }
            tag.m_128405_("activatedTimes", time + 1);
        }
    }

    public void onProjectileHit(ManasSkillInstance instance, LivingEntity entity, ProjectileImpactEvent event) {
        if (!instance.isToggled()) {
            return;
        }
        if (SkillUtils.isProjectileAlwaysHit(event.getProjectile())) {
            return;
        }
        if (entity.m_217043_().m_188503_(5) != 1) {
            return;
        }
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123766_, 1.0);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 2.0f, 1.0f);
        event.setCanceled(true);
    }
}

