/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.extra;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.water.WaterMagic;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.WaterManipulationSkill;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.entity.magic.projectile.WaterBallProjectile;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class WaterDominationSkill
extends Skill {
    public WaterDominationSkill() {
        super(Skill.SkillType.EXTRA);
    }

    @Override
    public boolean meetEPRequirement(Player entity, double newEP) {
        if (!SkillUtils.isSkillMastered((LivingEntity)entity, (ManasSkill)ExtraSkills.WATER_MANIPULATION.get())) {
            return false;
        }
        return newEP > 400000.0;
    }

    @Override
    public double learningCost() {
        return 100.0;
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 10.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity living, LivingHurtEvent e) {
        if (!instance.isToggled()) {
            return;
        }
        if (DamageSourceHelper.isWaterDamage(e.getSource())) {
            e.setAmount(e.getAmount() * 4.0f);
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (!entity.m_6144_()) {
            instance.getOrCreateTag().m_128405_("BreathEntity", 0);
            instance.markDirty();
            return;
        }
        if (WaterManipulationSkill.hasWater(entity)) {
            if (SkillHelper.outOfMagicule(entity, instance)) {
                return;
            }
            this.shootBall(instance, entity);
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            TensuraSkillCapability.getFrom(player).ifPresent(cap -> {
                if (cap.getWaterPoint() <= 0.0 && cap.getSpiritLevel(MagicElemental.WATER.getId()) < 1) {
                    return;
                }
                if (SkillHelper.outOfMagicule(entity, instance)) {
                    return;
                }
                cap.setWaterPoint(cap.getWaterPoint() - 1.0);
                this.shootBall(instance, entity);
                TensuraSkillCapability.sync(player);
            });
        }
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (entity.m_6144_()) {
            return false;
        }
        if (WaterManipulationSkill.hasWater(entity)) {
            if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule(entity, instance)) {
                return false;
            }
            if (heldTicks % 60 == 0 && heldTicks > 0) {
                this.addMasteryPoint(instance, entity);
            }
            WaterManipulationSkill.waterBreath(instance, entity, this.magiculeCost(entity, instance));
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            TensuraSkillCapability.getFrom(player).ifPresent(cap -> {
                if (cap.getWaterPoint() <= 0.0) {
                    return;
                }
                if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule(entity, instance)) {
                    return;
                }
                if (heldTicks % 100 == 0) {
                    if (heldTicks % 100 == 0 && heldTicks > 0) {
                        this.addMasteryPoint(instance, entity);
                    }
                    cap.setWaterPoint(cap.getWaterPoint() - 1.0);
                    TensuraSkillCapability.sync(player);
                }
                WaterManipulationSkill.waterBreath(instance, entity, this.magiculeCost(entity, instance));
            });
        }
        return true;
    }

    private void shootBall(ManasSkillInstance instance, LivingEntity entity) {
        entity.m_21011_(InteractionHand.MAIN_HAND, true);
        if (WaterMagic.isWaterEvaporated(entity, entity.f_19853_)) {
            return;
        }
        this.addMasteryPoint(instance, entity);
        WaterBallProjectile waterBall = new WaterBallProjectile(entity.m_9236_(), entity);
        waterBall.setSpeed(2.0f);
        waterBall.setDamage(12.0f);
        waterBall.setKnockForce(1.5f);
        waterBall.setBurnTicks(-1);
        waterBall.setMpCost(this.magiculeCost(entity, instance));
        waterBall.setSkill(instance);
        waterBall.setPosAndShoot(entity);
        entity.m_9236_().m_7967_((Entity)waterBall);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12324_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }
}

