/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.intrinsic;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.effect.template.Transformation;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class BeastTransformationSkill
extends Skill
implements Transformation {
    public BeastTransformationSkill() {
        super(Skill.SkillType.INTRINSIC);
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 0.0;
    }

    public boolean canIgnoreCoolDown(ManasSkillInstance instance, LivingEntity entity) {
        return this.canTick(instance, entity);
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        MobEffectInstance ogre = entity.m_21124_((MobEffect)TensuraMobEffects.BEAST_TRANSFORMATION.get());
        return ogre != null && ogre.m_19564_() == 0;
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        CompoundTag tag = instance.getOrCreateTag();
        int time = tag.m_128451_("activatedTimes");
        if (time % 6 == 0) {
            this.addMasteryPoint(instance, entity);
        }
        tag.m_128405_("activatedTimes", time + 1);
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        if (this.canTick(instance, entity)) {
            entity.m_21195_((MobEffect)TensuraMobEffects.BEAST_TRANSFORMATION.get());
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (this.failedToActivate(entity, (MobEffect)TensuraMobEffects.BEAST_TRANSFORMATION.get())) {
            return;
        }
        if (!entity.m_21023_((MobEffect)TensuraMobEffects.BEAST_TRANSFORMATION.get())) {
            if (SkillHelper.outOfMagicule(entity, instance)) {
                return;
            }
            this.addMasteryPoint(instance, entity);
            instance.setCoolDown(1200);
            entity.m_21153_(entity.m_21233_());
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_215769_, SoundSource.PLAYERS, 1.0f, 1.0f);
            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.BEAST_TRANSFORMATION.get(), this.isMastered(instance, entity) ? 7200 : 3600, 0, false, false, false));
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123812_);
            TensuraParticleHelper.spawnServerParticles(entity.f_19853_, (ParticleOptions)TensuraParticles.LIGHTNING_SPARK.get(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 55, 0.08, 0.08, 0.08, 0.5, true);
        } else {
            entity.m_21195_((MobEffect)TensuraMobEffects.BEAST_TRANSFORMATION.get());
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }
}

