/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.intrinsic;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.effect.template.Transformation;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class DarknessTransformSkill
extends Skill
implements Transformation {
    private static final String TRANSFORM = "392620a9-d97d-458e-8c0f-cd3f3d92b967";

    public DarknessTransformSkill() {
        super(Skill.SkillType.INTRINSIC);
        this.addHeldAttributeModifier(Attributes.f_22279_, TRANSFORM, -0.5, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 30.0;
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity living, UnlockSkillEvent event) {
        if (instance.getMastery() < 0 || instance.isTemporarySkill()) {
            return;
        }
        for (ManasSkill manasSkill : SkillAPI.getSkillRegistry().getValues()) {
            SpiritualMagic skill;
            if (!(manasSkill instanceof SpiritualMagic) || (skill = (SpiritualMagic)manasSkill).getElemental() != MagicElemental.DARKNESS || skill.getLevel().getId() > 2 || !SkillUtils.learnSkill(living, skill) || !(living instanceof Player)) continue;
            Player player = (Player)living;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
        }
    }

    public void onSkillMastered(ManasSkillInstance instance, LivingEntity entity) {
        if (TensuraEPCapability.getEP(entity) < 400000.0) {
            return;
        }
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        ManasSkill skill = (ManasSkill)ExtraSkills.MAGIC_DARKNESS_TRANSFORM.get();
        TensuraSkillInstance manipulation = new TensuraSkillInstance(skill);
        manipulation.setMastery(-100);
        if (storage.learnSkill((ManasSkillInstance)manipulation) && entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_available", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), false);
        }
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity living, int heldTicks) {
        if (this.failedToActivate(living, null)) {
            return false;
        }
        if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule(living, instance)) {
            return false;
        }
        if (heldTicks % 60 == 0 && heldTicks > 0) {
            this.addMasteryPoint(instance, living);
        }
        living.m_9236_().m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)living, (ParticleOptions)TensuraParticles.DARK_RED_LIGHTNING_SPARK.get(), 1.0);
        ((ServerLevel)living.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123765_, living.m_20185_(), living.m_20186_() + (double)living.m_20206_() / 2.0, living.m_20189_(), 10, 0.08, 0.08, 0.08, 0.15);
        List list = living.m_9236_().m_6443_(LivingEntity.class, living.m_20191_().m_82400_(5.0), entity -> !entity.m_7306_((Entity)living) && entity.m_6084_() && !entity.m_7307_((Entity)living));
        if (!list.isEmpty()) {
            DamageSource damageSource = TensuraDamageSources.elementalAttack("tensura.dark_attack", (Entity)living, this.magiculeCost(living, instance), instance, true);
            for (LivingEntity target : list) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 100, 0, false, false, false));
                target.m_6469_(damageSource, 2.0f);
            }
        }
        return true;
    }
}

