/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.intrinsic;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.event.SkillPlunderEvent;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class DrainSkill
extends Skill {
    public DrainSkill() {
        super(Skill.SkillType.INTRINSIC);
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        LivingEntity target = SkillHelper.getTargetingEntity(entity, 3.0, false);
        if (target == null || !target.m_6084_()) {
            return;
        }
        if (RaceHelper.hasNoBlood(target)) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237115_((String)"tensura.targeting.not_allowed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
            return;
        }
        if (target.m_6469_((DamageSource)this.sourceWithMP(TensuraDamageSources.bloodDrain((Entity)entity), entity, instance), 6.0f)) {
            entity.m_5634_(6.0f);
            this.addMasteryPoint(instance, entity);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)DustParticleOptions.f_123656_);
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11911_, SoundSource.PLAYERS, 1.0f, 1.0f);
            List<ManasSkillInstance> collection = SkillAPI.getSkillsFrom((Entity)target).getLearnedSkills().stream().filter(skillInstance -> this.isDrainable(skillInstance.getSkill())).toList();
            ManasSkill skill = collection.get(target.m_217043_().m_188503_(collection.size())).getSkill();
            if (!SkillUtils.fullyHasSkill((Entity)entity, skill)) {
                SkillPlunderEvent event = new SkillPlunderEvent((Entity)target, (Entity)entity, false, skill);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                    return;
                }
                if (DrainSkill.learnTemporarySkill(entity, new TensuraSkillInstance(event.getSkill()))) {
                    instance.setCoolDown(80);
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.temporary.success_drain", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), false);
                    }
                    entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            } else if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.temporary.already_have", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
        }
    }

    public static boolean learnTemporarySkill(LivingEntity entity, ManasSkillInstance skill) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        Optional optional = storage.getSkill(skill.getSkill());
        if (optional.isEmpty()) {
            skill.setRemoveTime(80);
            return storage.learnSkill(skill);
        }
        ManasSkillInstance instance = (ManasSkillInstance)optional.get();
        if (instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
            return false;
        }
        ManasSkillInstance clone = instance.clone();
        clone.getOrCreateTag().m_128405_("OldRemoval", clone.getRemoveTime());
        clone.getOrCreateTag().m_128405_("OldMastery", clone.getMastery());
        clone.setRemoveTime(80);
        clone.setMastery(0);
        clone.markDirty();
        UnlockSkillEvent event = new UnlockSkillEvent(clone, (Entity)entity);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        instance.deserialize(event.getSkillInstance().toNBT());
        instance.markDirty();
        storage.syncChanges();
        return true;
    }

    public boolean isDrainable(ManasSkill manasSkill) {
        if (!(manasSkill instanceof Skill)) {
            return false;
        }
        Skill skill = (Skill)manasSkill;
        return skill.getType().equals((Object)Skill.SkillType.INTRINSIC) || skill.getType().equals((Object)Skill.SkillType.COMMON) || skill.getType().equals((Object)Skill.SkillType.EXTRA);
    }
}

