/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.resist;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.skill.resist.ResistSkill;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class ColdResistance
extends ResistSkill {
    @Override
    public boolean isDamageResisted(DamageSource damageSource, ManasSkillInstance instance) {
        return DamageSourceHelper.isCold(damageSource);
    }

    @Override
    public double learningCost() {
        return 15.0;
    }

    @Override
    public int pointRequirement() {
        return 350;
    }

    @Override
    @NotNull
    public List<MobEffect> getImmuneEffects(ManasSkillInstance instance, LivingEntity entity) {
        if (!instance.isToggled()) {
            return new ArrayList<MobEffect>();
        }
        return List.of((MobEffect)TensuraMobEffects.CHILL.get());
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity entity, UnlockSkillEvent event) {
        ManasSkill skill;
        if (instance.getMastery() < 0) {
            return;
        }
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if ((SkillUtils.hasSkill((Entity)entity, (ManasSkill)ResistanceSkills.HEAT_RESISTANCE.get()) || SkillUtils.hasSkill((Entity)entity, (ManasSkill)ResistanceSkills.HEAT_NULLIFICATION.get())) && storage.learnSkill(skill = (ManasSkill)ResistanceSkills.THERMAL_FLUCTUATION_RESISTANCE.get()) && entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), false);
        }
    }

    @Override
    @Nullable
    protected ManasSkill getNullificationForm() {
        return (ManasSkill)ResistanceSkills.COLD_NULLIFICATION.get();
    }
}

