/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.resist;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.skill.resist.ResistSkill;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import org.jetbrains.annotations.NotNull;

public class ParalysisResistanceSkill
extends ResistSkill {
    @Override
    public void onTakenDamage(ManasSkillInstance instance, LivingDamageEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (instance.getMastery() >= 0) {
            return;
        }
        if (!event.getEntity().m_21023_((MobEffect)TensuraMobEffects.PARALYSIS.get())) {
            return;
        }
        if ((double)event.getAmount() > this.learningCost()) {
            this.addLearnPoint(instance, event.getEntity());
        }
    }

    @Override
    public int pointRequirement() {
        return 350;
    }

    @Override
    @NotNull
    public List<MobEffect> getImmuneEffects(ManasSkillInstance instance, LivingEntity entity) {
        if (!instance.isToggled()) {
            return new ArrayList<MobEffect>();
        }
        return List.of((MobEffect)TensuraMobEffects.PARALYSIS.get());
    }

    @Override
    @Nullable
    protected ManasSkill getNullificationForm() {
        return (ManasSkill)ResistanceSkills.PARALYSIS_NULLIFICATION.get();
    }
}

