/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.resist;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.skill.resist.ResistSkill;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class PhysicalAttackResistance
extends ResistSkill {
    @Override
    public boolean isDamageResisted(DamageSource damageSource, ManasSkillInstance instance) {
        return DamageSourceHelper.isPhysicalAttack(damageSource);
    }

    @Override
    public double learningCost() {
        return 20.0;
    }

    @Override
    public int pointRequirement() {
        return 700;
    }

    @Override
    public boolean isResistanceBypass(DamageSource damageSource) {
        return PhysicalAttackResistance.canBypassPhysical(damageSource);
    }

    @Override
    @Nullable
    protected ManasSkill getNullificationForm() {
        return (ManasSkill)ResistanceSkills.PHYSICAL_ATTACK_NULLIFICATION.get();
    }

    public static boolean canBypassPhysical(DamageSource damageSource) {
        Entity entity = damageSource.m_7639_();
        if (entity instanceof LivingEntity) {
            TensuraDamageSource source;
            LivingEntity living = (LivingEntity)entity;
            if (living.m_21023_((MobEffect)TensuraMobEffects.HAKI_COAT.get())) {
                return true;
            }
            if (living.m_21023_((MobEffect)TensuraMobEffects.MAGIC_AURA.get())) {
                return true;
            }
            MobEffectInstance instance = living.m_21124_((MobEffect)TensuraMobEffects.SEVERANCE_BLADE.get());
            if (instance != null && instance.m_19564_() >= 4) {
                return true;
            }
            if (damageSource instanceof TensuraDamageSource && (source = (TensuraDamageSource)damageSource).getIgnoreResistance() == 1.0f) {
                return true;
            }
            return SkillUtils.reducingResistances(living);
        }
        return false;
    }
}

