/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.resist;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.Event;

public class ResistSkill
extends Skill {
    private final ResistType resistType;

    public ResistSkill(Skill.SkillType skillType, ResistType resistType) {
        super(skillType);
        this.resistType = resistType;
    }

    public ResistSkill(ResistType resistType) {
        super(Skill.SkillType.RESISTANCE);
        this.resistType = resistType;
    }

    public ResistSkill() {
        this(Skill.SkillType.RESISTANCE, ResistType.RESISTANCE);
    }

    @Override
    public boolean canInteractSkill(ManasSkillInstance instance, LivingEntity entity) {
        if (entity.m_21023_((MobEffect)TensuraMobEffects.SLEEP_MODE.get())) {
            return false;
        }
        if (entity.m_21023_((MobEffect)TensuraMobEffects.REST.get())) {
            return false;
        }
        if (entity.m_21023_((MobEffect)TensuraMobEffects.INFINITE_IMPRISONMENT.get())) {
            return false;
        }
        return !SkillUtils.noInteractiveMode(entity);
    }

    @Override
    public boolean canBeSlotted(ManasSkillInstance instance) {
        return false;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return instance.getMastery() >= 0;
    }

    public void onToggleOn(ManasSkillInstance skillInstance, LivingEntity living) {
        List<MobEffect> list = this.getImmuneEffects(skillInstance, living);
        if (list.isEmpty()) {
            return;
        }
        SkillHelper.removePredicateEffect(living, list::contains);
    }

    public boolean isNullificationBypass(DamageSource damageSource) {
        TensuraDamageSource source;
        Entity entity = damageSource.m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity living = (LivingEntity)entity;
        if (TensuraSkillCapability.isSkillInSlot(living, (ManasSkill)UniqueSkills.ANTI_SKILL.get())) {
            return true;
        }
        return damageSource instanceof TensuraDamageSource && (source = (TensuraDamageSource)damageSource).getIgnoreResistance() >= 2.0f;
    }

    public boolean isResistanceBypass(DamageSource damageSource) {
        TensuraDamageSource source;
        Entity entity = damageSource.m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity living = (LivingEntity)entity;
        if (damageSource instanceof TensuraDamageSource && (source = (TensuraDamageSource)damageSource).getIgnoreResistance() == 1.0f) {
            return true;
        }
        return SkillUtils.reducingResistances(living);
    }

    public boolean isDamageResisted(DamageSource damageSource, ManasSkillInstance instance) {
        return false;
    }

    protected double getHpMultiplierForResistance(boolean nullification) {
        if (nullification) {
            return (Double)TensuraConfig.INSTANCE.skillsConfig.hpForNullification.get();
        }
        return (Double)TensuraConfig.INSTANCE.skillsConfig.hpForResistance.get();
    }

    protected double getResistanceDamageMultiplier(boolean nullification) {
        if (nullification) {
            return (Double)TensuraConfig.INSTANCE.skillsConfig.nullifcationDamageMultiplier.get();
        }
        return (Double)TensuraConfig.INSTANCE.skillsConfig.resistanceDamageMultiplier.get();
    }

    public void onBeingDamaged(ManasSkillInstance instance, LivingAttackEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!instance.isToggled()) {
            return;
        }
        if (!this.resistType.equals((Object)ResistType.NULLIFICATION)) {
            return;
        }
        if (this.getResistanceDamageMultiplier(true) > 0.0) {
            return;
        }
        if (this.getHpMultiplierForResistance(true) >= 0.0) {
            return;
        }
        DamageSource source = event.getSource();
        if (this.isNullificationBypass(source)) {
            return;
        }
        if (!this.isDamageResisted(source, instance)) {
            return;
        }
        if (!this.isResistanceBypass(source)) {
            event.setCanceled(true);
        }
    }

    public void onTakenDamage(ManasSkillInstance instance, LivingDamageEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (instance.getMastery() < 0) {
            if (!this.isDamageResisted(event.getSource(), instance)) {
                return;
            }
            if (!this.resistType.equals((Object)ResistType.RESISTANCE)) {
                return;
            }
            if ((double)event.getAmount() > this.learningCost()) {
                this.addLearnPoint(instance, event.getEntity());
            }
            return;
        }
        if (!instance.isToggled()) {
            return;
        }
        if (!this.isDamageResisted(event.getSource(), instance)) {
            return;
        }
        boolean bypass = this.isResistanceBypass(event.getSource());
        if (this.resistType.equals((Object)ResistType.NULLIFICATION)) {
            if (bypass) {
                double hpMultiplier = this.getHpMultiplierForResistance(false);
                if (hpMultiplier < 0.0 || (double)event.getAmount() < (double)event.getEntity().m_21223_() * hpMultiplier) {
                    event.setCanceled(true);
                } else {
                    float multiplier = (float)this.getResistanceDamageMultiplier(false);
                    if (multiplier <= 0.0f) {
                        event.setCanceled(true);
                    } else {
                        event.setAmount(event.getAmount() * multiplier);
                    }
                }
            } else {
                double hpMultiplier = this.getHpMultiplierForResistance(true);
                if (hpMultiplier < 0.0 || (double)event.getAmount() < (double)event.getEntity().m_21223_() * hpMultiplier) {
                    event.setCanceled(true);
                } else {
                    float multiplier = (float)this.getResistanceDamageMultiplier(true);
                    if (multiplier <= 0.0f) {
                        event.setCanceled(true);
                    } else {
                        event.setAmount(event.getAmount() * multiplier);
                    }
                }
            }
        } else if (this.resistType.equals((Object)ResistType.RESISTANCE) && !bypass) {
            ManasSkill nullification = this.getNullificationForm();
            if (nullification != null && SkillUtils.isSkillToggled((Entity)event.getEntity(), nullification)) {
                return;
            }
            double hpMultiplier = this.getHpMultiplierForResistance(false);
            if (hpMultiplier < 0.0 || (double)event.getAmount() < (double)event.getEntity().m_21223_() * hpMultiplier) {
                event.setCanceled(true);
            } else {
                float multiplier = (float)this.getResistanceDamageMultiplier(false);
                if (multiplier <= 0.0f) {
                    event.setCanceled(true);
                } else {
                    event.setAmount(event.getAmount() * multiplier);
                }
            }
        }
    }

    @Override
    public double learningCost() {
        return 5.0;
    }

    public int pointRequirement() {
        return 100;
    }

    @Override
    public void addLearnPoint(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMastery() < 0) {
            int oldMastery = instance.getMastery();
            int newMastery = oldMastery + SkillUtils.getEarningLearnPoint(instance, entity, false);
            instance.setMastery(Math.min(newMastery, 0));
            instance.markDirty();
            if (oldMastery < 0 && newMastery >= 0) {
                UnlockSkillEvent event = new UnlockSkillEvent(instance, (Entity)entity);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                    instance.setMastery(oldMastery);
                    instance.markDirty();
                    return;
                }
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire_learning", (Object[])new Object[]{this.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                }
                instance.onLearnSkill(entity, event);
                instance.setToggled(true);
                instance.onToggleOn(entity);
            }
        }
    }

    public void evolveToNullification(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMastery() < 0) {
            return;
        }
        if (instance.isTemporarySkill()) {
            return;
        }
        ManasSkill nullification = this.getNullificationForm();
        if (nullification == null) {
            return;
        }
        if (SkillUtils.learnSkill(entity, nullification) && entity instanceof Player) {
            Player player = (Player)entity;
            TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
                cap.addIntrinsicSkill(nullification);
                TensuraPlayerCapability.sync(player);
            });
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{nullification.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
        }
    }

    @Nullable
    protected ManasSkill getNullificationForm() {
        return null;
    }

    public ResistType getResistType() {
        return this.resistType;
    }

    public static enum ResistType {
        RESISTANCE,
        NULLIFICATION;

    }
}

