/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class BerserkerSkill
extends Skill {
    public static final UUID BERSERKER = UUID.fromString("8465ec3c-4e31-11ee-be56-0242ac120002");

    public BerserkerSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double getObtainingEpCost() {
        return 20000.0;
    }

    public void onTouchEntity(ManasSkillInstance instance, LivingEntity entity, LivingHurtEvent e) {
        if (!this.isInSlot(entity)) {
            return;
        }
        if (e.getSource().m_7640_() == entity && DamageSourceHelper.isPhysicalAttack(e.getSource())) {
            LivingEntity target = e.getEntity();
            int durabilityBreak = (int)Math.max(1.0f, e.getAmount() / 4.0f);
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (slot.m_20743_().equals((Object)EquipmentSlot.Type.HAND) && !target.m_6844_(slot).canPerformAction(ToolActions.SHIELD_BLOCK)) continue;
                ItemStack slotStack = target.m_6844_(slot);
                slotStack.m_41622_(durabilityBreak, target, living -> living.m_21166_(slot));
            }
        }
    }

    public void onTakenDamage(ManasSkillInstance instance, LivingDamageEvent e) {
        if (!this.isInSlot(e.getEntity())) {
            return;
        }
        Entity entity2 = e.getSource().m_7639_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity source = (LivingEntity)entity2;
            source.m_21120_(InteractionHand.MAIN_HAND).m_41622_(5, source, entity -> entity.m_21190_(InteractionHand.MAIN_HAND));
        }
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        AttributeInstance armor;
        AttributeInstance speed;
        AttributeInstance damage = entity.m_21051_(Attributes.f_22281_);
        if (damage != null && damage.m_22111_(BERSERKER) != null) {
            damage.m_22127_(BERSERKER);
        }
        if ((speed = entity.m_21051_(Attributes.f_22279_)) != null && speed.m_22111_(BERSERKER) != null) {
            speed.m_22127_(BERSERKER);
        }
        if ((armor = entity.m_21051_(Attributes.f_22284_)) != null && armor.m_22111_(BERSERKER) != null) {
            armor.m_22127_(BERSERKER);
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11738_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        AttributeInstance speed;
        AttributeInstance damage;
        double EP = TensuraEPCapability.getEP(entity);
        AttributeInstance armor = entity.m_21051_(Attributes.f_22284_);
        if (armor != null) {
            if (armor.m_22111_(BERSERKER) != null) {
                armor.m_22127_(BERSERKER);
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11738_, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                AttributeModifier armorModifier = new AttributeModifier(BERSERKER, "BerserkerArmor", BerserkerSkill.getArmor(EP), AttributeModifier.Operation.ADDITION);
                armor.m_22125_(armorModifier);
                this.addMasteryPoint(instance, entity);
                instance.setCoolDown(10);
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11736_, SoundSource.PLAYERS, 1.0f, 1.0f);
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)TensuraParticles.SOLAR_FLASH.get(), 2.0);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)TensuraParticles.YELLOW_LIGHTNING_SPARK.get(), 3.0);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)TensuraParticles.YELLOW_LIGHTNING_SPARK.get(), 2.0);
                TensuraParticleHelper.spawnServerParticles(entity.f_19853_, (ParticleOptions)TensuraParticles.PURPLE_LIGHTNING_SPARK.get(), entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), 100, 0.08, 0.08, 0.08, 0.2, true);
            }
        }
        if ((damage = entity.m_21051_(Attributes.f_22281_)) != null) {
            if (damage.m_22111_(BERSERKER) != null) {
                damage.m_22127_(BERSERKER);
            } else {
                damage.m_22125_(new AttributeModifier(BERSERKER, "BerserkerAttack", instance.isMastered(entity) ? BerserkerSkill.getAttack(EP) * 2.0 : BerserkerSkill.getAttack(EP), AttributeModifier.Operation.ADDITION));
            }
        }
        if ((speed = entity.m_21051_(Attributes.f_22279_)) != null) {
            if (speed.m_22111_(BERSERKER) != null) {
                speed.m_22127_(BERSERKER);
            } else {
                speed.m_22125_(new AttributeModifier(BERSERKER, "BerserkerSpeed", BerserkerSkill.getSpeed(EP) / 100.0, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        AttributeInstance attack = entity.m_21051_(Attributes.f_22281_);
        return attack != null && attack.m_22111_(BERSERKER) != null;
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)TensuraParticles.YELLOW_LIGHTNING_SPARK.get());
    }

    public static double getArmor(double EP) {
        if (EP >= 2000000.0) {
            return 100.0;
        }
        return EP / 20000.0;
    }

    public static double getAttack(double EP) {
        if (EP <= 40000.0) {
            return 5.0;
        }
        if (EP >= 2000000.0) {
            return 55.0;
        }
        double attackIncrease = EP / 40000.0;
        return 5.0 + attackIncrease;
    }

    public static double getSpeed(double EP) {
        if (EP >= 1000000.0) {
            return 40.0;
        }
        return EP / 25000.0;
    }
}

