/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.HakiSkill;
import com.github.manasmods.tensura.ability.skill.extra.HeroHakiSkill;
import com.github.manasmods.tensura.ability.skill.intrinsic.CharmSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.template.TensuraHorseEntity;
import com.github.manasmods.tensura.event.SkillPlunderEvent;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.Event;

public class ChosenOneSkill
extends Skill {
    private static final String HAKI = "896381ea-3f60-48cf-bc8e-49267cca6b9a";

    public ChosenOneSkill() {
        super(Skill.SkillType.UNIQUE);
        this.addHeldAttributeModifier(Attributes.f_22279_, HAKI, -0.95f, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    @Override
    public double getObtainingEpCost() {
        return 75000.0;
    }

    @Override
    public double learningCost() {
        return 2000.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    @Override
    public int modes() {
        return 2;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return instance.getMode() == 1 ? 2 : 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.chosen_one.haki");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.chosen_one.charisma");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 2 -> 200.0;
            case 1 -> 25.0;
            default -> 0.0;
        };
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isToggled() || this.isInSlot(entity);
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity living, UnlockSkillEvent event) {
        if (instance.getMastery() < 0 || instance.isTemporarySkill()) {
            return;
        }
        if (living instanceof Player) {
            Player player = (Player)living;
            TensuraPlayerCapability.getFrom(player).ifPresent(cap -> cap.setBlessed(true));
            TensuraPlayerCapability.sync(player);
        }
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.isToggled()) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19595_, 240, 4, false, false, false));
        }
        if (this.isInSlot(entity)) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19621_, 240, 4, false, false, false));
            List list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(15.0), living -> living.m_6084_() && (living.m_7307_((Entity)entity) || living.m_7306_((Entity)entity)));
            if (list.isEmpty()) {
                return;
            }
            for (LivingEntity target : list) {
                SkillHelper.checkThenAddEffectSource(target, (Entity)entity, (MobEffect)TensuraMobEffects.ALLY_BOOST.get(), 240, 1, false, false, false);
            }
        }
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        this.onTick(instance, entity);
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        entity.m_21195_(MobEffects.f_19595_);
    }

    public double getAttributeModifierAmplifier(ManasSkillInstance instance, LivingEntity entity, AttributeModifier modifier) {
        return modifier.m_22218_() * (instance.isMastered(entity) ? 0.9473684210526315 : 1.0);
    }

    public void addHeldAttributeModifiers(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMode() != 1) {
            return;
        }
        super.addHeldAttributeModifiers(instance, entity);
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (instance.getMode() != 1) {
            return false;
        }
        if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule(entity, instance)) {
            return false;
        }
        if (heldTicks % 60 == 0 && heldTicks > 0) {
            this.addMasteryPoint(instance, entity);
        }
        HeroHakiSkill.activateHeroHaki(instance, entity, heldTicks);
        return true;
    }

    public void onScroll(ManasSkillInstance instance, LivingEntity entity, double delta) {
        if (instance.getMode() != 1) {
            return;
        }
        HakiSkill.changeEPUsed(instance, entity, delta);
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (instance.getMode() != 1) {
            return;
        }
        if (!this.hasAttributeApplied(entity, Attributes.f_22279_, HAKI)) {
            return;
        }
        instance.setCoolDown(instance.isMastered(entity) ? 3 : 5);
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMode() != 2) {
            return;
        }
        Level level = entity.m_9236_();
        List list = level.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(10.0), target -> !target.m_7306_((Entity)entity) && target.m_6084_() && !target.m_7307_((Entity)entity));
        if (list.isEmpty()) {
            return;
        }
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        this.addMasteryPoint(instance, entity);
        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11868_, SoundSource.PLAYERS, 1.0f, 1.0f);
        for (LivingEntity target2 : list) {
            Mob mob;
            if (target2.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_CHARISMA) || !CharmSkill.canMindControl(target2, level) || target2.m_21023_((MobEffect)TensuraMobEffects.RAMPAGE.get()) || target2 instanceof Mob && (mob = (Mob)target2).m_5912_() || target2 instanceof NeutralMob && (mob = (NeutralMob)target2).m_21660_() || SkillHelper.getSubordinateOwner(target2) != null || SkillUtils.isSkillToggled((Entity)target2, (ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_NULLIFICATION.get())) continue;
            int duration = SkillUtils.isSkillToggled((Entity)target2, (ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_RESISTANCE.get()) ? 1200 : 2400;
            SkillHelper.checkThenAddEffectSource(target2, (Entity)entity, (MobEffect)TensuraMobEffects.MIND_CONTROL.get(), duration, 1, false, false, false, true);
            if (!target2.m_21023_((MobEffect)TensuraMobEffects.MIND_CONTROL.get())) continue;
            TensuraEPCapability.getFrom(target2).ifPresent(cap -> {
                if (!Objects.equals(cap.getTemporaryOwner(), entity.m_20148_())) {
                    cap.setTemporaryOwner(entity.m_20148_());
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        if (target2 instanceof TamableAnimal) {
                            TamableAnimal animal = (TamableAnimal)target2;
                            animal.m_21828_(player);
                        } else if (target2 instanceof TensuraHorseEntity) {
                            TensuraHorseEntity horse = (TensuraHorseEntity)target2;
                            horse.m_30637_(player);
                        }
                    }
                    TensuraEPCapability.sync(target2);
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target2, (ParticleOptions)ParticleTypes.f_123750_);
                }
            });
        }
    }

    @Override
    public void onSubordinateDeath(ManasSkillInstance instance, LivingEntity owner, LivingDeathEvent e) {
        if (!instance.isMastered(owner)) {
            return;
        }
        if (e.getSource().m_7639_() == owner) {
            return;
        }
        LivingEntity entity = e.getEntity();
        if (entity.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_SKILL_PLUNDER)) {
            return;
        }
        if (entity instanceof Player && !entity.m_9236_().m_6106_().m_5466_()) {
            return;
        }
        List<ManasSkillInstance> list = List.copyOf(SkillAPI.getSkillsFrom((Entity)entity).getLearnedSkills());
        if (list.isEmpty()) {
            return;
        }
        for (ManasSkillInstance targetInstance : list) {
            SkillPlunderEvent event;
            if (targetInstance.isTemporarySkill() || targetInstance.getMastery() < 0 || targetInstance.getSkill() == this || targetInstance.getSkill() instanceof SpiritualMagic || MinecraftForge.EVENT_BUS.post((Event)(event = new SkillPlunderEvent((Entity)entity, (Entity)owner, true, targetInstance.getSkill()))) || !SkillUtils.learnSkill(owner, event.getSkill(), instance.getRemoveTime())) continue;
            SkillAPI.getSkillsFrom((Entity)entity).forgetSkill(event.getSkill());
            if (!(owner instanceof Player)) continue;
            Player player = (Player)owner;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire_fallen", (Object[])new Object[]{event.getSkill().getName(), entity.m_7755_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
            player.m_6330_(SoundEvents.f_12275_, SoundSource.PLAYERS, 0.5f, 1.0f);
        }
    }
}

