/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.api.entity.subclass.IElementalSpirit;
import com.github.manasmods.tensura.block.CharybdisCoreBlock;
import com.github.manasmods.tensura.block.entity.CharybdisCoreBlockEntity;
import com.github.manasmods.tensura.block.entity.PrayingPathBlockEntity;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.effect.template.TensuraMobEffect;
import com.github.manasmods.tensura.event.SkillGriefEvent;
import com.github.manasmods.tensura.event.SkillPlunderEvent;
import com.github.manasmods.tensura.menu.DegenerateCraftingMenu;
import com.github.manasmods.tensura.menu.DegenerateEnchantmentMenu;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import com.github.manasmods.tensura.world.TensuraGameRules;
import com.google.common.collect.BiMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.SculkSensorPhase;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;

public class DegenerateSkill
extends Skill {
    public DegenerateSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double getObtainingEpCost() {
        return 35000.0;
    }

    @Override
    public int modes() {
        return 3;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 3 : instance.getMode() - 1;
        }
        return instance.getMode() == 3 ? 1 : instance.getMode() + 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.degenerate.crafting");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.degenerate.synthesise");
            case 3 -> Component.m_237115_((String)"tensura.skill.mode.degenerate.separate");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 100.0;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        Level level = entity.m_9236_();
        switch (instance.getMode()) {
            case 1: {
                if (!(entity instanceof ServerPlayer)) break;
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                if (serverPlayer.m_6047_()) {
                    NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((pContainerId, pPlayerInventory, pPlayer1) -> new DegenerateEnchantmentMenu(pContainerId, pPlayerInventory, ContainerLevelAccess.m_39289_((Level)level, (BlockPos)serverPlayer.m_20183_())), (Component)Component.m_237119_()));
                } else {
                    NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((pContainerId, pPlayerInventory, pPlayer1) -> new DegenerateCraftingMenu(pContainerId, pPlayerInventory, ContainerLevelAccess.m_39289_((Level)level, (BlockPos)serverPlayer.m_20183_())), (Component)Component.m_237119_()));
                }
                serverPlayer.m_6330_(SoundEvents.f_11889_, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 2: {
                CompoundTag tag;
                IElementalSpirit spirit;
                Player player;
                BlockHitResult result = SkillHelper.getPlayerPOVHitResult(level, (Entity)entity, ClipContext.Fluid.NONE, 5.0);
                BlockPos pos = result.m_82425_();
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof CharybdisCoreBlockEntity) {
                    CharybdisCoreBlockEntity core = (CharybdisCoreBlockEntity)blockEntity;
                    switch ((SculkSensorPhase)level.m_8055_(pos).m_61143_(CharybdisCoreBlock.MODE)) {
                        case INACTIVE: {
                            this.fusingCore(entity, (List)TensuraConfig.INSTANCE.blocksConfig.fusingInactiveCoreSkills.get(), core.getEP());
                            break;
                        }
                        case ACTIVE: {
                            this.fusingCore(entity, (List)TensuraConfig.INSTANCE.blocksConfig.fusingActiveCoreSkills.get(), core.getEP());
                            break;
                        }
                        case COOLDOWN: {
                            this.fusingCore(entity, (List)TensuraConfig.INSTANCE.blocksConfig.fusingInertCoreSkills.get(), (Double)TensuraConfig.INSTANCE.blocksConfig.fusingCoreEP.get());
                        }
                    }
                    level.m_46961_(pos, false);
                    TensuraParticleHelper.addServerParticlesAroundPos(level.f_46441_, level, Vec3.m_82512_((Vec3i)pos), (ParticleOptions)ParticleTypes.f_235898_, 1.0);
                    TensuraParticleHelper.addServerParticlesAroundPos(level.f_46441_, level, Vec3.m_82512_((Vec3i)pos), (ParticleOptions)TensuraParticles.SOUL.get(), 1.0);
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    return;
                }
                LivingEntity target = SkillHelper.getTargetingEntity(entity, 4.0, false);
                if (target == null || !target.m_6084_()) {
                    if (entity instanceof Player) {
                        player = (Player)entity;
                        player.m_5661_((Component)Component.m_237115_((String)"tensura.targeting.not_targeted").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    }
                    return;
                }
                if (target instanceof Player) {
                    player = (Player)target;
                    if (player.m_150110_().f_35934_) {
                        return;
                    }
                }
                if (!RaceHelper.isSpiritual(target) || (double)target.m_21223_() > (double)target.m_21233_() * 0.25 || target instanceof IElementalSpirit && (spirit = (IElementalSpirit)target).getSummoningTick() > 0) {
                    if (entity instanceof Player) {
                        Player player2 = (Player)entity;
                        player2.m_5661_((Component)Component.m_237115_((String)"tensura.targeting.not_allowed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    }
                    return;
                }
                if (!target.m_6469_(TensuraDamageSources.synthesise((Entity)entity), target.m_21233_() * 10.0f)) break;
                if (target instanceof IElementalSpirit) {
                    spirit = (IElementalSpirit)target;
                    if (entity instanceof Player) {
                        Player player3 = (Player)entity;
                        TensuraSkillCapability.getFrom(player3).ifPresent(cap -> {
                            if (cap.setSpiritLevel(player3, spirit.getElemental().getId(), spirit.getSpiritLevel().getId())) {
                                TensuraSkillCapability.sync(player3);
                                PrayingPathBlockEntity.grantSpiritMagic(player3, spirit.getElemental(), spirit.getSpiritLevel());
                                PrayingPathBlockEntity.grantManipulation(player3, spirit.getElemental());
                            }
                        });
                    }
                }
                if (!target.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_SKILL_PLUNDER)) {
                    ArrayList<ManasSkill> learntSkill = new ArrayList<ManasSkill>();
                    for (ManasSkillInstance targetSkill : SkillAPI.getSkillsFrom((Entity)target).getLearnedSkills()) {
                        ManasSkill manasSkill;
                        if (targetSkill.isTemporarySkill() || targetSkill.getMastery() < 0 || targetSkill.getSkill() == this || !((manasSkill = targetSkill.getSkill()) instanceof Skill)) continue;
                        Skill skill2 = (Skill)manasSkill;
                        SkillPlunderEvent event = new SkillPlunderEvent((Entity)target, (Entity)entity, TensuraGameRules.canStealSkill(level), skill2);
                        if (MinecraftForge.EVENT_BUS.post((Event)event) || !SkillUtils.learnSkill(entity, event.getSkill(), instance.getRemoveTime())) continue;
                        learntSkill.add(event.getSkill());
                    }
                    if (TensuraGameRules.canStealSkill(level)) {
                        learntSkill.forEach(skill -> SkillAPI.getSkillsFrom((Entity)target).forgetSkill(skill));
                        SkillAPI.getSkillsFrom((Entity)target).syncChanges();
                    }
                }
                if ((tag = instance.getOrCreateTag()).m_128441_("synthesisedList")) {
                    synthesisedList = (CompoundTag)tag.m_128423_("synthesisedList");
                    if (synthesisedList == null) {
                        return;
                    }
                    String targetID = EntityType.m_20613_((EntityType)target.m_6095_()).toString();
                    if (synthesisedList.m_128441_(targetID)) {
                        return;
                    }
                    synthesisedList.m_128379_(targetID, true);
                } else {
                    synthesisedList = new CompoundTag();
                    synthesisedList.m_128379_(EntityType.m_20613_((EntityType)target.m_6095_()).toString(), true);
                    tag.m_128365_("synthesisedList", (Tag)synthesisedList);
                }
                double difference = Math.min(SkillUtils.getEPGain(target, entity), (Double)TensuraConfig.INSTANCE.skillsConfig.maximumEPSteal.get());
                if (target instanceof Player) {
                    Player playerTarget = (Player)target;
                    if (TensuraGameRules.canEpSteal(level)) {
                        DamageSourceHelper.markHurt(target, (Entity)entity);
                        SkillHelper.gainMaxMP(entity, difference / 2.0);
                        SkillHelper.gainMaxAP(entity, difference / 2.0);
                        TensuraEPCapability.setSkippingEPDrop(target, true);
                        TensuraPlayerCapability.getFrom(playerTarget).ifPresent(cap -> {
                            double reducedAura = cap.getBaseAura() - difference / 2.0;
                            double reducedMana = cap.getBaseMagicule() - difference / 2.0;
                            if (reducedAura < 0.0) {
                                reducedMana -= reducedAura * -1.0;
                                reducedAura = 100.0;
                            } else if (reducedMana < 0.0) {
                                reducedAura -= reducedMana * -1.0;
                                reducedMana = 100.0;
                            }
                            double minusMP = cap.getBaseMagicule() - reducedMana;
                            cap.setMagicule(cap.getMagicule() - minusMP);
                            double minusAP = cap.getBaseAura() - reducedAura;
                            cap.setAura(cap.getAura() - minusAP);
                            cap.setBaseMagicule(reducedMana, (LivingEntity)playerTarget);
                            cap.setBaseAura(reducedAura, (LivingEntity)playerTarget);
                        });
                        TensuraPlayerCapability.sync(playerTarget);
                        this.addMasteryPoint(instance, entity);
                        instance.setCoolDown(instance.isMastered(entity) ? 3 : 5);
                        entity.m_21011_(InteractionHand.MAIN_HAND, true);
                        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123792_, 1.0);
                        break;
                    }
                    if (!(entity instanceof Player)) break;
                    Player player4 = (Player)entity;
                    player4.m_5661_((Component)Component.m_237115_((String)"tensura.targeting.not_allowed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    break;
                }
                if (target.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_EP_PLUNDER)) {
                    return;
                }
                DamageSourceHelper.markHurt(target, (Entity)entity);
                SkillHelper.gainMaxMP(entity, difference / 2.0);
                SkillHelper.gainMaxAP(entity, difference / 2.0);
                TensuraEPCapability.getFrom(target).ifPresent(cap -> cap.setEP(target, cap.getEP() - difference));
                this.addMasteryPoint(instance, entity);
                instance.setCoolDown(instance.isMastered(entity) ? 3 : 5);
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123792_, 1.0);
                break;
            }
            case 3: {
                LivingEntity target = SkillHelper.getTargetingEntity(entity, 4.0, false);
                if (target != null) {
                    Player player;
                    if (!target.m_6084_()) {
                        return;
                    }
                    if (target instanceof Player) {
                        player = (Player)target;
                        if (player.m_150110_().f_35934_) {
                            return;
                        }
                    }
                    if (SkillHelper.isSubordinate(entity, target) && entity.m_6144_()) {
                        Predicate<MobEffect> predicate = effect -> !(effect instanceof TensuraMobEffect) || !effect.m_19486_();
                        if (SkillHelper.removePredicateEffect(target, predicate, this.magiculeCost(entity, instance))) {
                            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123749_, 1.0);
                        }
                    } else {
                        if (!target.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_SKILL_PLUNDER) && TensuraEPCapability.getEP(target) < TensuraEPCapability.getEP(entity) * 0.75) {
                            for (ManasSkillInstance targetSkill : SkillAPI.getSkillsFrom((Entity)target).getLearnedSkills()) {
                                boolean steal;
                                SkillPlunderEvent event;
                                Skill skill3;
                                ManasSkill targetID;
                                if (targetSkill.isTemporarySkill() || targetSkill.getMastery() < 0 || targetSkill.getSkill() == this || !((targetID = targetSkill.getSkill()) instanceof Skill) || !(skill3 = (Skill)targetID).getType().equals((Object)Skill.SkillType.COMMON) && !skill3.getType().equals((Object)Skill.SkillType.EXTRA) || MinecraftForge.EVENT_BUS.post((Event)(event = new SkillPlunderEvent((Entity)target, (Entity)entity, steal = TensuraGameRules.canStealSkill(level), targetSkill.getSkill()))) || !SkillUtils.learnSkill(entity, targetSkill.getSkill(), instance.getRemoveTime())) continue;
                                if (steal) {
                                    SkillAPI.getSkillsFrom((Entity)target).forgetSkill(targetSkill);
                                }
                                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123792_, 1.0);
                                if (entity instanceof Player) {
                                    Player player5 = (Player)entity;
                                    player5.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{skill3.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                                }
                                this.addMasteryPoint(instance, entity);
                            }
                        } else if (entity instanceof Player) {
                            player = (Player)entity;
                            player.m_5661_((Component)Component.m_237115_((String)"tensura.targeting.ep_not_meet").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                        }
                        DamageSourceHelper.markHurt(target, (Entity)entity);
                        entity.m_21011_(InteractionHand.MAIN_HAND, true);
                        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                } else {
                    BlockHitResult result = SkillHelper.getPlayerPOVHitResult(level, (Entity)entity, ClipContext.Fluid.NONE, 5.0);
                    BlockPos pos = result.m_82425_();
                    BlockState state = level.m_8055_(pos);
                    if (state.m_60795_()) {
                        Predicate<MobEffect> predicate = effect -> !(effect instanceof TensuraMobEffect) || !effect.m_19486_();
                        if (SkillHelper.removePredicateEffect(entity, predicate, this.magiculeCost(entity, instance))) {
                            instance.setCoolDown(instance.isMastered(entity) ? 5 : 3);
                            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123749_, 1.0);
                        }
                    } else if (state.m_204336_(Tags.Blocks.ORES)) {
                        if (!TensuraGameRules.canSkillGrief(level)) {
                            return;
                        }
                        this.addMasteryPoint(instance, entity);
                        SkillGriefEvent.Pre preGrief = new SkillGriefEvent.Pre((Entity)entity, instance, pos);
                        if (MinecraftForge.EVENT_BUS.post((Event)preGrief)) {
                            return;
                        }
                        if (state.m_204336_(Tags.Blocks.ORES_IN_GROUND_STONE)) {
                            level.m_46953_(pos, true, (Entity)entity);
                            level.m_46597_(pos, Blocks.f_50069_.m_49966_());
                        } else if (state.m_204336_(Tags.Blocks.ORES_IN_GROUND_DEEPSLATE)) {
                            level.m_46953_(pos, true, (Entity)entity);
                            level.m_46597_(pos, Blocks.f_152550_.m_49966_());
                        } else if (state.m_204336_(Tags.Blocks.ORES_IN_GROUND_NETHERRACK)) {
                            level.m_46953_(pos, true, (Entity)entity);
                            level.m_46597_(pos, Blocks.f_50134_.m_49966_());
                        }
                        MinecraftForge.EVENT_BUS.post((Event)new SkillGriefEvent.Post((Entity)entity, instance, pos));
                    } else {
                        if (!TensuraGameRules.canSkillGrief(level)) {
                            return;
                        }
                        SkillGriefEvent.Pre preGrief = new SkillGriefEvent.Pre((Entity)entity, instance, pos);
                        if (MinecraftForge.EVENT_BUS.post((Event)preGrief)) {
                            return;
                        }
                        if (state.m_60734_() instanceof WeatheringCopper) {
                            this.addMasteryPoint(instance, entity);
                            WeatheringCopper.m_154899_((BlockState)state).ifPresent(blockState -> level.m_46597_(pos, blockState));
                        } else {
                            Optional.ofNullable((Block)((BiMap)HoneycombItem.f_150864_.get()).get((Object)state.m_60734_())).map(block -> block.m_152465_(state)).ifPresent(waxOff -> level.m_46597_(pos, waxOff));
                        }
                        MinecraftForge.EVENT_BUS.post((Event)new SkillGriefEvent.Post((Entity)entity, instance, pos));
                    }
                }
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    private void fusingCore(LivingEntity entity, List<? extends String> strings, double EP) {
        List<ManasSkill> list = strings.stream().map(skill -> (ManasSkill)SkillAPI.getSkillRegistry().getValue(new ResourceLocation(skill))).filter(Objects::nonNull).toList();
        if (!list.isEmpty()) {
            for (ManasSkill skill2 : list) {
                if (!SkillUtils.learnSkill(entity, skill2) || !(entity instanceof Player)) continue;
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{skill2.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
            }
        }
        SkillHelper.gainMaxMP(entity, EP);
        SkillHelper.gainMP(entity, EP, false);
    }
}

