/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.magic.misc.FusionistLandmineEntity;
import com.github.manasmods.tensura.entity.magic.skill.FusionistProjectile;
import com.github.manasmods.tensura.event.SkillGriefEvent;
import com.github.manasmods.tensura.world.TensuraGameRules;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class FusionistSkill
extends Skill {
    public FusionistSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double getObtainingEpCost() {
        return 20000.0;
    }

    @Override
    public int modes() {
        return 3;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 3 : instance.getMode() - 1;
        }
        return instance.getMode() == 3 ? 1 : instance.getMode() + 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.fusionist.disassemble");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.fusionist.fuse");
            case 3 -> Component.m_237115_((String)"tensura.skill.mode.fusionist.projectile");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 2 -> 1000.0;
            case 3 -> 200.0;
            default -> 0.0;
        };
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        Level level = entity.m_9236_();
        CompoundTag tag = instance.getOrCreateTag();
        switch (instance.getMode()) {
            case 1: {
                BlockItem item;
                ItemStack stack;
                Item item2;
                if (entity.m_6144_() && (item2 = (stack = entity.m_21205_()).m_41720_()) instanceof BlockItem && !(item = (BlockItem)item2).m_40614_().m_49966_().m_204336_(TensuraTags.Blocks.SKILL_UNBREAKABLE)) {
                    stack.m_41774_(1);
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                    tag.m_128405_("matters", tag.m_128451_("matters") + 1);
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.fusionist.matter_amount", (Object[])new Object[]{tag.m_128451_("matters")}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                    }
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    instance.markDirty();
                    return;
                }
                BlockHitResult result = SkillHelper.getPlayerPOVHitResult(level, (Entity)entity, ClipContext.Fluid.NONE, 5.0);
                BlockPos pos = result.m_82425_();
                BlockState state = level.m_8055_(pos);
                if (state.m_60795_()) {
                    return;
                }
                if (state.m_204336_(TensuraTags.Blocks.SKILL_UNBREAKABLE)) {
                    return;
                }
                if (!TensuraGameRules.canSkillGrief(level)) {
                    return;
                }
                if (!state.canEntityDestroy((BlockGetter)level, pos, (Entity)entity)) {
                    return;
                }
                SkillGriefEvent.Pre preGrief = new SkillGriefEvent.Pre((Entity)entity, instance, pos);
                if (MinecraftForge.EVENT_BUS.post((Event)preGrief)) {
                    return;
                }
                level.m_46953_(pos, false, (Entity)entity);
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                tag.m_128405_("matters", tag.m_128451_("matters") + 1);
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.fusionist.matter_amount", (Object[])new Object[]{tag.m_128451_("matters")}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                }
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
                instance.markDirty();
                MinecraftForge.EVENT_BUS.post((Event)new SkillGriefEvent.Post((Entity)entity, instance, pos));
                break;
            }
            case 2: {
                Player player;
                AABB aabb;
                List list;
                if (tag.m_128441_("mineY") && !(list = level.m_6443_(FusionistLandmineEntity.class, aabb = new AABB(new BlockPos(tag.m_128459_("mineX"), tag.m_128459_("mineY"), tag.m_128459_("mineZ"))).m_82400_(0.5), entityData -> entityData.getOwner() == entity)).isEmpty()) {
                    for (FusionistLandmineEntity landmine : list) {
                        double y = TensuraGameRules.canSkillGrief(level) ? landmine.m_20186_() : landmine.m_20186_() + 1.0;
                        landmine.trigger(landmine.m_20185_(), y, landmine.m_20189_());
                    }
                    tag.m_128473_("mineX");
                    tag.m_128473_("mineY");
                    tag.m_128473_("mineZ");
                    this.addMasteryPoint(instance, entity);
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11837_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    return;
                }
                if (tag.m_128451_("matters") >= 5 || entity instanceof Player && (player = (Player)entity).m_7500_()) {
                    Player player2;
                    BlockHitResult result = SkillHelper.getPlayerPOVHitResult(level, (Entity)entity, ClipContext.Fluid.NONE, 5.0);
                    BlockPos pos = result.m_82425_();
                    if (level.m_8055_(pos).m_60795_()) {
                        return;
                    }
                    if (SkillHelper.outOfMagicule(entity, instance)) {
                        return;
                    }
                    FusionistLandmineEntity landmine = new FusionistLandmineEntity(level, (double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, entity);
                    landmine.setRadius(40);
                    level.m_7967_((Entity)landmine);
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                    tag.m_128347_("mineX", landmine.m_20185_());
                    tag.m_128347_("mineY", landmine.m_20186_());
                    tag.m_128347_("mineZ", landmine.m_20189_());
                    if (!(entity instanceof Player) || !(player2 = (Player)entity).m_7500_()) {
                        tag.m_128405_("matters", tag.m_128451_("matters") - 5);
                    }
                    instance.markDirty();
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11837_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                if (!(entity instanceof Player)) break;
                Player player3 = (Player)entity;
                player3.m_5661_((Component)Component.m_237115_((String)"tensura.skill.fusionist.out_of_matter").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                break;
            }
            case 3: {
                Player player;
                if (tag.m_128451_("matters") >= 1 || entity instanceof Player && (player = (Player)entity).m_7500_()) {
                    Player player4;
                    if (SkillHelper.outOfMagicule(entity, instance)) {
                        return;
                    }
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                    FusionistProjectile sphere = new FusionistProjectile(level, entity);
                    sphere.setSpeed(1.5f);
                    sphere.setExplosionRadius(6.0f);
                    sphere.setMpCost(this.magiculeCost(entity, instance));
                    sphere.setSkill(instance);
                    sphere.setPosAndShoot(entity);
                    level.m_7967_((Entity)sphere);
                    if (!(entity instanceof Player) || !(player4 = (Player)entity).m_7500_()) {
                        tag.m_128405_("matters", tag.m_128451_("matters") - 1);
                    }
                    this.addMasteryPoint(instance, entity);
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                if (!(entity instanceof Player)) break;
                Player player5 = (Player)entity;
                player5.m_5661_((Component)Component.m_237115_((String)"tensura.skill.fusionist.out_of_matter").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
        }
    }
}

