/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class GourmandSkill
extends Skill {
    public GourmandSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double getObtainingEpCost() {
        return 50000.0;
    }

    public void onTouchEntity(ManasSkillInstance instance, LivingEntity attacker, LivingHurtEvent event) {
        float chance;
        if (!this.isInSlot(attacker)) {
            return;
        }
        float f = chance = instance.isMastered(attacker) ? 0.75f : 0.5f;
        if (attacker.m_217043_().m_188501_() > chance) {
            return;
        }
        if (SkillHelper.drainMP(event.getEntity(), attacker, 0.01, true) && attacker instanceof Player) {
            Player player = (Player)attacker;
            player.m_6330_(SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        double d;
        double EP;
        LivingEntity target = SkillHelper.getTargetingEntity(entity, 5.0, false);
        if (target == null) {
            return;
        }
        if (target instanceof Player) {
            Player player = (Player)target;
            if (player.m_150110_().f_35934_) {
                return;
            }
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            v0 = TensuraPlayerCapability.getCurrentEP(player);
        } else {
            v0 = EP = TensuraEPCapability.getEP(entity);
        }
        if (target instanceof Player) {
            Player player = (Player)target;
            d = TensuraPlayerCapability.getCurrentEP(player);
        } else {
            d = TensuraEPCapability.getEP(target);
        }
        double targetEP = d;
        MobEffectInstance fear = target.m_21124_((MobEffect)TensuraMobEffects.FEAR.get());
        if ((fear != null && fear.m_19564_() >= 4 || targetEP <= EP * 0.1) && target.m_6469_((DamageSource)this.sourceWithMP(TensuraDamageSources.heartEat((Entity)entity), entity, instance), target.m_21233_() * 10.0f)) {
            this.addMasteryPoint(instance, entity);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
                    cap.setMagicule(cap.getMagicule() + targetEP / 2.0);
                    cap.setAura(cap.getAura() + targetEP / 2.0);
                });
                TensuraPlayerCapability.sync(player);
            }
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11912_, SoundSource.PLAYERS, 1.0f, 1.0f);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123765_, 1.0);
        }
    }

    public static float getGourmandBoost(Player player, boolean magicule, boolean majin) {
        TensuraSkill skill = (TensuraSkill)((Object)UniqueSkills.GOURMAND.get());
        if (!skill.isInSlot((LivingEntity)player)) {
            return 0.0f;
        }
        Optional optional = SkillAPI.getSkillsFrom((Entity)player).getSkill((ManasSkill)skill);
        if (optional.isEmpty()) {
            return 0.0f;
        }
        if (((ManasSkillInstance)optional.get()).isMastered((LivingEntity)player)) {
            if (majin) {
                return magicule ? 0.08f : 0.09f;
            }
            return magicule ? 0.09f : 0.08f;
        }
        if (majin) {
            return magicule ? 0.03f : 0.04f;
        }
        return magicule ? 0.04f : 0.03f;
    }
}

