/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.manascore.attribute.ManasCoreAttributes;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.battlewill.Battewill;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.ThoughtAccelerationSkill;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.registry.blocks.TensuraBlocks;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import com.github.manasmods.tensura.world.TensuraGameRules;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class MartialMasterSkill
extends Skill {
    protected static final UUID ACCELERATION = UUID.fromString("872fee6e-e8c7-4fda-b060-aad307ae4a4c");

    public MartialMasterSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return instance.getMastery() >= 0;
    }

    @Override
    public double auraCost(LivingEntity entity, ManasSkillInstance instance) {
        return 100.0;
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity entity, UnlockSkillEvent event) {
        Player player;
        if (instance.getMastery() < 0 || instance.isTemporarySkill()) {
            return;
        }
        Skill eye = (Skill)((Object)ExtraSkills.HEAVENLY_EYE.get());
        if (entity instanceof Player && !(player = (Player)entity).m_7500_()) {
            double cost = eye.getObtainingEpCost() * (double)player.f_19853_.m_46469_().m_46215_(TensuraGameRules.MP_SKILL_COST) / 100.0;
            TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
                cap.setBaseMagicule(cap.getBaseMagicule() + cost, (LivingEntity)player, false);
                TensuraPlayerCapability.sync(player);
            });
        }
        if (SkillUtils.learnSkill(entity, eye) && entity instanceof Player) {
            player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{eye.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
        }
    }

    public void onBeingDamaged(ManasSkillInstance instance, LivingAttackEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (!this.isInSlot(entity)) {
            return;
        }
        DamageSource damageSource = event.getSource();
        if (damageSource.m_19378_() || damageSource.m_19387_()) {
            return;
        }
        if (damageSource.m_7640_() == null || damageSource.m_7640_() != damageSource.m_7639_()) {
            return;
        }
        if (entity.m_217043_().m_188501_() > 0.25f) {
            return;
        }
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 2.0f, 1.0f);
        event.setCanceled(true);
        if (SkillUtils.canNegateDodge(entity, damageSource)) {
            event.setCanceled(false);
        }
    }

    public void onProjectileHit(ManasSkillInstance instance, LivingEntity entity, ProjectileImpactEvent event) {
        if (!this.isInSlot(entity)) {
            return;
        }
        if (SkillUtils.isProjectileAlwaysHit(event.getProjectile())) {
            return;
        }
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 2.0f, 1.0f);
        event.setCanceled(true);
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity attacker, LivingHurtEvent e) {
        TensuraDamageSource damageSource;
        if (!instance.isToggled()) {
            return;
        }
        DamageSource source = e.getSource();
        if (source instanceof TensuraDamageSource && (damageSource = (TensuraDamageSource)source).getSkill() != null && damageSource.getSkill().getSkill() instanceof Battewill) {
            e.setAmount(e.getAmount() * 3.0f);
        } else if (DamageSourceHelper.isPhysicalAttack(source) && source.m_7640_() == source.m_7639_()) {
            e.setAmount((float)((double)e.getAmount() + attacker.m_21133_(Attributes.f_22281_) * 2.0));
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (!entity.m_20096_() && !entity.m_20072_()) {
            return;
        }
        if (SkillHelper.outOfAura(entity, instance)) {
            return;
        }
        this.addMasteryPoint(instance, entity);
        Level level = entity.m_9236_();
        int range = instance.isMastered(entity) ? 20 : 15;
        BlockHitResult result = SkillHelper.getPlayerPOVHitResult(level, (Entity)entity, ClipContext.Fluid.NONE, range);
        BlockPos resultPos = result.m_82425_().m_121945_(result.m_82434_());
        Vec3 vec3 = SkillHelper.getFloorPos(resultPos);
        if (!level.m_8055_(resultPos).m_60767_().m_76336_()) {
            vec3 = SkillHelper.getFloorPos(resultPos.m_7494_());
        }
        if (level.m_8055_(resultPos).m_60713_((Block)TensuraBlocks.LABYRINTH_BARRIER_BLOCK.get())) {
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return;
        }
        if (!entity.m_9236_().m_6857_().m_61937_(new BlockPos(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_()))) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.teleport.out_border").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
            return;
        }
        Vec3 source = entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0);
        Vec3 offSetToTarget = vec3.m_82546_(source);
        for (int particleIndex = 1; particleIndex < Mth.m_14107_((double)offSetToTarget.m_82553_()); ++particleIndex) {
            Vec3 particlePos = source.m_82549_(offSetToTarget.m_82541_().m_82490_((double)particleIndex));
            ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123796_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            TensuraParticleHelper.addServerParticlesAroundPos(entity.m_217043_(), level, particlePos, (ParticleOptions)ParticleTypes.f_123766_, 3.0);
            TensuraParticleHelper.addServerParticlesAroundPos(entity.m_217043_(), level, particlePos, (ParticleOptions)ParticleTypes.f_123766_, 2.0);
            AABB aabb = new AABB(new BlockPos(particlePos)).m_82400_(Math.max(entity.m_21133_((Attribute)ForgeMod.ATTACK_RANGE.get()), 2.0));
            List livingEntityList = level.m_6443_(LivingEntity.class, aabb, target -> !target.m_7306_((Entity)entity) && !target.m_7307_((Entity)entity));
            if (livingEntityList.isEmpty()) continue;
            float bonus = instance.isMastered(entity) ? 75.0f : 0.0f;
            float amount = (float)(entity.m_21133_(Attributes.f_22281_) * entity.m_21133_((Attribute)ManasCoreAttributes.CRIT_MULTIPLIER.get()));
            for (LivingEntity target2 : livingEntityList) {
                if (!target2.m_6469_((DamageSource)this.sourceWithMP(DamageSource.m_19370_((LivingEntity)entity), entity, instance), amount + bonus)) continue;
                ItemStack stack = entity.m_21205_();
                stack.m_41720_().m_7579_(stack, target2, entity);
                entity.m_9236_().m_6263_(null, target2.m_20185_(), target2.m_20186_(), target2.m_20189_(), SoundEvents.f_12313_, entity.m_5720_(), 1.0f, 1.0f);
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_7726_().m_8394_((Entity)entity, (Packet)new ClientboundAnimatePacket((Entity)entity, 4));
            }
        }
        entity.m_183634_();
        entity.m_19877_();
        entity.m_20219_(vec3);
        entity.f_19812_ = true;
        entity.m_21011_(InteractionHand.MAIN_HAND, true);
        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle(instance, entity, ACCELERATION, true);
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle(instance, entity, ACCELERATION, false);
    }
}

