/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MusicianSkill
extends Skill {
    public MusicianSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double learningCost() {
        return 2000.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isToggled();
    }

    @Override
    public int modes() {
        return 3;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return switch (instance.getMode()) {
                case 3 -> 2;
                case 2 -> 1;
                case 1 -> {
                    if (this.isMastered(instance, entity)) {
                        yield 3;
                    }
                    yield 2;
                }
                default -> 0;
            };
        }
        return switch (instance.getMode()) {
            case 2 -> {
                if (this.isMastered(instance, entity)) {
                    yield 3;
                }
                yield 1;
            }
            case 1 -> 2;
            default -> 1;
        };
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.musician.sonic_blast");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.musician.sound_wave");
            case 3 -> Component.m_237115_((String)"tensura.skill.mode.musician.mind_requiem");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 3 -> 200.0;
            case 2 -> 100.0;
            case 1 -> 50.0;
            default -> 0.0;
        };
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.AUDITORY_SENSE.get(), 200, 0, false, false, false));
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        this.onTick(instance, entity);
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        entity.m_21195_((MobEffect)TensuraMobEffects.AUDITORY_SENSE.get());
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        Level level = entity.m_9236_();
        switch (instance.getMode()) {
            case 1: {
                this.sonicBlast(instance, entity, level);
                break;
            }
            case 2: {
                this.soundWave(instance, entity, level);
                break;
            }
            case 3: {
                this.mindRequiem(instance, entity, level);
            }
        }
    }

    public void sonicBlast(ManasSkillInstance instance, LivingEntity entity, Level level) {
        this.addMasteryPoint(instance, entity);
        instance.setCoolDown(1);
        double range = instance.isMastered(entity) ? 12.0 : 8.0;
        Vec3 target = entity.m_20182_().m_82549_(entity.m_20154_().m_82490_(range));
        Vec3 source = entity.m_20182_().m_82520_(0.0, (double)1.6f, 0.0);
        Vec3 offSetToTarget = target.m_82546_(source);
        Vec3 normalizes = offSetToTarget.m_82541_();
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_215771_, SoundSource.PLAYERS, 5.0f, 1.0f);
        for (int particleIndex = 1; particleIndex < Mth.m_14107_((double)offSetToTarget.m_82553_()); ++particleIndex) {
            Vec3 particlePos = source.m_82549_(normalizes.m_82490_((double)particleIndex));
            ((ServerLevel)level).m_8767_((ParticleOptions)((SimpleParticleType)TensuraParticles.SONIC_BLAST.get()), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            AABB aabb = new AABB(new BlockPos(particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_)).m_82400_(2.0);
            List livingEntityList = level.m_6443_(LivingEntity.class, aabb, entityData -> !entityData.m_7306_((Entity)entity));
            if (livingEntityList.isEmpty()) continue;
            for (LivingEntity pLivingEntity : livingEntityList) {
                if (RaceHelper.isSpiritualLifeForm(pLivingEntity)) continue;
                DamageSource damagesource = TensuraDamageSources.sonicBlast((Entity)entity);
                pLivingEntity.m_6469_((DamageSource)this.sourceWithMP(damagesource, entity, instance), this.isMastered(instance, entity) ? 150.0f : 75.0f);
            }
        }
    }

    public void soundWave(ManasSkillInstance instance, LivingEntity entity, Level level) {
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), SoundEvents.f_215771_, SoundSource.PLAYERS, 5.0f, 1.0f);
        List list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(5.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_());
        if (!list.isEmpty()) {
            this.addMasteryPoint(instance, entity);
            for (LivingEntity target : list) {
                if (RaceHelper.isSpiritualLifeForm(target)) continue;
                DamageSource damagesource = TensuraDamageSources.sonicBlast((Entity)entity);
                target.m_6469_((DamageSource)this.sourceWithMP(damagesource, entity, instance), this.isMastered(instance, entity) ? 70.0f : 40.0f);
            }
        }
        instance.setCoolDown(1);
        ((ServerLevel)level).m_8767_((ParticleOptions)((SimpleParticleType)TensuraParticles.SOUND_GIANT.get()), entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123747_, entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123813_, entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
    }

    public void mindRequiem(ManasSkillInstance instance, LivingEntity entity, Level level) {
        this.addMasteryPoint(instance, entity);
        instance.setCoolDown(3);
        Vec3 target = entity.m_20182_().m_82549_(entity.m_20154_().m_82490_(10.0));
        Vec3 source = entity.m_20182_().m_82520_(0.0, (double)1.6f, 0.0);
        Vec3 offSetToTarget = target.m_82546_(source);
        Vec3 normalizes = offSetToTarget.m_82541_();
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_215771_, SoundSource.PLAYERS, 5.0f, 1.0f);
        for (int particleIndex = 1; particleIndex < Mth.m_14107_((double)offSetToTarget.m_82553_()); ++particleIndex) {
            Vec3 particlePos = source.m_82549_(normalizes.m_82490_((double)particleIndex));
            ((ServerLevel)level).m_8767_((ParticleOptions)((SimpleParticleType)TensuraParticles.SOUND_REQUIEM.get()), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            AABB aabb = new AABB(new BlockPos(particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_)).m_82400_(3.0);
            List livingEntityList = level.m_6443_(LivingEntity.class, aabb, entityData -> !entityData.m_7306_((Entity)entity));
            if (livingEntityList.isEmpty()) continue;
            for (LivingEntity living : livingEntityList) {
                DamageSource damagesource;
                if (!living.m_6469_((DamageSource)this.sourceWithMP(damagesource = TensuraDamageSources.mindRequiem((Entity)entity), entity, instance), 300.0f)) continue;
                DamageSourceHelper.directSpiritualHurt(living, (Entity)entity, 100.0f);
            }
        }
    }
}

