/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.ISpatialStorage;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.menu.ResearcherEnchantmentMenu;
import com.github.manasmods.tensura.menu.ResearcherSpatialStorageMenu;
import com.github.manasmods.tensura.menu.container.SpatialStorageContainer;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.ClientboundSpatialStorageOpenPacket;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class ResearcherSkill
extends Skill
implements ISpatialStorage {
    public ResearcherSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double getObtainingEpCost() {
        return 30000.0;
    }

    @Override
    public double learningCost() {
        return 10000.0;
    }

    public void onSkillMastered(ManasSkillInstance instance, LivingEntity entity) {
        TensuraSkillInstance skill = new TensuraSkillInstance((ManasSkill)UniqueSkills.GODLY_CRAFTSMAN.get());
        if (SkillUtils.learnSkill(entity, skill)) {
            ResearcherSkill.addEnchantments(entity, ResearcherSkill.getAllEnchantments(entity, this), skill.getSkill());
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{skill.getSkill().getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), false);
            }
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        ServerPlayer player;
        ManasSkillInstance craftsman = this.getGodlyCraftsman(entity);
        if (entity instanceof ServerPlayer && (player = (ServerPlayer)entity).m_6047_() && !(player.f_36096_ instanceof ResearcherEnchantmentMenu)) {
            player.f_36096_.m_6877_((Player)player);
            player.m_6330_(SoundEvents.f_11889_, SoundSource.PLAYERS, 1.0f, 1.0f);
            ResearcherSkill skill = craftsman != null ? craftsman.getSkill() : this;
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((pContainerId, pPlayerInventory, pPlayer) -> new ResearcherEnchantmentMenu(pContainerId, pPlayerInventory, ContainerLevelAccess.m_39289_((Level)player.f_19853_, (BlockPos)player.m_20183_()), skill), (Component)Component.m_237119_()), buf -> buf.m_130085_(SkillUtils.getSkillId(skill)));
        } else {
            if (craftsman != null) {
                ResearcherSkill.addSelectedEnchantments(entity, Map.of(), true, craftsman.getSkill());
                this.moveItemsToSpatialStorage(instance, craftsman, entity, true);
                return;
            }
            ResearcherSkill.addSelectedEnchantments(entity, Map.of(), true, this);
            this.openSpatialStorage(entity, instance);
        }
    }

    @Override
    @NotNull
    public SpatialStorageContainer getSpatialStorage(ManasSkillInstance instance) {
        SpatialStorageContainer container = new SpatialStorageContainer(64, 128);
        container.m_7797_(instance.getOrCreateTag().m_128437_("SpatialStorage", 10));
        return container;
    }

    @Override
    public void openSpatialStorage(LivingEntity entity, ManasSkillInstance instance) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.m_9217_();
            if (player.f_36096_ instanceof InventoryMenu) {
                player.m_6330_(SoundEvents.f_11889_, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                player.m_6330_(SoundEvents.f_12088_, SoundSource.PLAYERS, 1.0f, 1.0f);
                player.f_36096_.m_6877_((Player)player);
            }
            ManasSkill skill = instance.getSkill();
            SpatialStorageContainer container = this.getSpatialStorage(instance);
            TensuraNetwork.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientboundSpatialStorageOpenPacket(player.m_19879_(), player.f_8940_, container.m_6643_(), container.m_6893_(), SkillUtils.getSkillId(skill), 3));
            player.f_36096_ = new ResearcherSpatialStorageMenu(player.f_8940_, player.m_150109_(), (Player)player, container, skill);
            player.m_143399_(player.f_36096_);
            MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((Player)player, player.f_36096_));
        }
    }

    private ManasSkillInstance getGodlyCraftsman(LivingEntity entity) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        Optional craftsmanOptional = storage.getSkill((ManasSkill)UniqueSkills.GODLY_CRAFTSMAN.get());
        return craftsmanOptional.orElse(null);
    }

    public static Map<Enchantment, Integer> getAllEnchantments(LivingEntity entity, ManasSkill skill) {
        String tagID = "StoredEnchantments";
        HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
        Optional instance = SkillAPI.getSkillsFrom((Entity)entity).getSkill(skill);
        if (instance.isEmpty()) {
            return map;
        }
        ManasSkillInstance researcher = (ManasSkillInstance)instance.get();
        CompoundTag tag = researcher.getOrCreateTag();
        if (!tag.m_128441_(tagID)) {
            return map;
        }
        return EnchantmentHelper.m_44882_((ListTag)tag.m_128437_(tagID, 10));
    }

    public static boolean addEnchantments(LivingEntity entity, Map<Enchantment, Integer> map, ManasSkill skill) {
        String tagID = "StoredEnchantments";
        Optional instance = SkillAPI.getSkillsFrom((Entity)entity).getSkill(skill);
        if (instance.isEmpty()) {
            return false;
        }
        ManasSkillInstance researcher = (ManasSkillInstance)instance.get();
        CompoundTag tag = researcher.getOrCreateTag();
        ListTag enchantments = !tag.m_128441_(tagID) ? new ListTag() : tag.m_128437_(tagID, 10);
        boolean success = false;
        for (Map.Entry<Enchantment, Integer> entry : map.entrySet()) {
            boolean flag = true;
            Enchantment enchantment = entry.getKey();
            ResourceLocation id = EnchantmentHelper.m_182432_((Enchantment)enchantment);
            if (((List)TensuraConfig.INSTANCE.enchantmentsConfig.researcherBlacklist.get()).contains(enchantment.toString())) continue;
            int level = entry.getValue();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                level = Math.min(level, ResearcherEnchantmentMenu.getMaxEnchantLevel(enchantment, player));
            }
            if (level <= 0) continue;
            for (int i = 0; i < enchantments.size(); ++i) {
                CompoundTag compoundtag = enchantments.m_128728_(i);
                ResourceLocation location = EnchantmentHelper.m_182446_((CompoundTag)compoundtag);
                if (location == null || !location.equals((Object)id)) continue;
                if (EnchantmentHelper.m_182438_((CompoundTag)compoundtag) < level) {
                    EnchantmentHelper.m_182440_((CompoundTag)compoundtag, (int)level);
                    success = true;
                }
                flag = false;
                break;
            }
            if (!flag) continue;
            enchantments.add((Object)EnchantmentHelper.m_182443_((ResourceLocation)id, (int)level));
            enchantments = ResearcherSkill.sortEnchantments(enchantments);
            success = true;
        }
        if (success) {
            tag.m_128365_(tagID, (Tag)enchantments);
            researcher.markDirty();
            SkillAPI.getSkillsFrom((Entity)entity).syncChanges();
        }
        return success;
    }

    private static ListTag sortEnchantments(ListTag listTag) {
        ArrayList<CompoundTag> locations = new ArrayList<CompoundTag>();
        for (int i = 0; i < listTag.size(); ++i) {
            locations.add(listTag.m_128728_(i));
        }
        locations.sort(Comparator.comparing(compoundTag -> compoundTag.m_128461_("id")));
        ListTag sortedListTag = new ListTag();
        sortedListTag.addAll(locations);
        return sortedListTag;
    }

    public static Map<Enchantment, Integer> getSelectedEnchantments(LivingEntity entity, ManasSkill skill) {
        String tagID = "SelectedEnchantments";
        HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
        Optional instance = SkillAPI.getSkillsFrom((Entity)entity).getSkill(skill);
        if (instance.isEmpty()) {
            return map;
        }
        ManasSkillInstance researcher = (ManasSkillInstance)instance.get();
        CompoundTag tag = researcher.getOrCreateTag();
        if (!tag.m_128441_(tagID)) {
            return map;
        }
        return EnchantmentHelper.m_44882_((ListTag)tag.m_128437_(tagID, 10));
    }

    public static Map<Enchantment, Integer> getNewEnchantments(LivingEntity entity, ManasSkill skill) {
        String tagID = "NewEnchantments";
        HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
        Optional instance = SkillAPI.getSkillsFrom((Entity)entity).getSkill(skill);
        if (instance.isEmpty()) {
            return map;
        }
        ManasSkillInstance researcher = (ManasSkillInstance)instance.get();
        CompoundTag tag = researcher.getOrCreateTag();
        if (!tag.m_128441_(tagID)) {
            return map;
        }
        return EnchantmentHelper.m_44882_((ListTag)tag.m_128437_(tagID, 10));
    }

    public static void setSelectedEnchantment(LivingEntity entity, Enchantment enchantment, int level, ManasSkill skill) {
        String tagID = "SelectedEnchantments";
        Optional instance = SkillAPI.getSkillsFrom((Entity)entity).getSkill(skill);
        if (instance.isEmpty()) {
            return;
        }
        ManasSkillInstance researcher = (ManasSkillInstance)instance.get();
        CompoundTag tag = researcher.getOrCreateTag();
        String newID = "NewEnchantments";
        ListTag newEnchantments = !tag.m_128441_(tagID) ? new ListTag() : tag.m_128437_(tagID, 10);
        ListTag enchantments = !tag.m_128441_(tagID) ? new ListTag() : tag.m_128437_(tagID, 10);
        boolean flag = true;
        ResourceLocation id = EnchantmentHelper.m_182432_((Enchantment)enchantment);
        for (int i = 0; i < enchantments.size(); ++i) {
            CompoundTag compoundtag = enchantments.m_128728_(i);
            ResourceLocation location = EnchantmentHelper.m_182446_((CompoundTag)compoundtag);
            if (location == null || !location.equals((Object)id)) continue;
            if (level == 0) {
                enchantments.remove((Object)compoundtag);
                newEnchantments.remove((Object)compoundtag);
            } else {
                EnchantmentHelper.m_182440_((CompoundTag)compoundtag, (int)level);
                newEnchantments.add((Object)compoundtag);
            }
            flag = false;
            break;
        }
        if (flag) {
            CompoundTag enchant = EnchantmentHelper.m_182443_((ResourceLocation)id, (int)level);
            enchantments.add((Object)enchant);
            newEnchantments.add((Object)enchant);
        }
        tag.m_128365_(newID, (Tag)newEnchantments);
        tag.m_128365_(tagID, (Tag)enchantments);
        researcher.markDirty();
        SkillAPI.getSkillsFrom((Entity)entity).syncChanges();
    }

    public static void addSelectedEnchantments(LivingEntity entity, Map<Enchantment, Integer> map, boolean clear, ManasSkill skill) {
        String tagID = "SelectedEnchantments";
        Optional instance = SkillAPI.getSkillsFrom((Entity)entity).getSkill(skill);
        if (instance.isEmpty()) {
            return;
        }
        ManasSkillInstance researcher = (ManasSkillInstance)instance.get();
        CompoundTag tag = researcher.getOrCreateTag();
        if (clear && tag.m_128441_(tagID)) {
            tag.m_128473_(tagID);
            tag.m_128473_("NewEnchantments");
        }
        ListTag enchantments = !tag.m_128441_(tagID) ? new ListTag() : tag.m_128437_(tagID, 10);
        for (Map.Entry<Enchantment, Integer> entry : map.entrySet()) {
            boolean flag = true;
            ResourceLocation id = EnchantmentHelper.m_182432_((Enchantment)entry.getKey());
            for (int i = 0; i < enchantments.size(); ++i) {
                CompoundTag compoundtag = enchantments.m_128728_(i);
                ResourceLocation location = EnchantmentHelper.m_182446_((CompoundTag)compoundtag);
                if (location == null || !location.equals((Object)id)) continue;
                EnchantmentHelper.m_182440_((CompoundTag)compoundtag, (int)entry.getValue());
                flag = false;
                break;
            }
            if (!flag) continue;
            enchantments.add((Object)EnchantmentHelper.m_182443_((ResourceLocation)id, (int)entry.getValue()));
        }
        tag.m_128365_(tagID, (Tag)enchantments);
        researcher.markDirty();
        SkillAPI.getSkillsFrom((Entity)entity).syncChanges();
    }
}

