/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;

public class ReverserSkill
extends Skill {
    public ReverserSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double getObtainingEpCost() {
        return 30000.0;
    }

    @Override
    public double learningCost() {
        return 2000.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return this.canTurnChaos(living);
    }

    @Override
    public int modes() {
        return 3;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 3 : instance.getMode() - 1;
        }
        return instance.getMode() == 3 ? 1 : instance.getMode() + 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.reverser.reverse");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.reverser.buff");
            case 3 -> Component.m_237115_((String)"tensura.skill.mode.reverser.debuff");
            default -> Component.m_237119_();
        };
    }

    private boolean canTurnChaos(LivingEntity living) {
        if (TensuraEPCapability.isChaos(living)) {
            return true;
        }
        if (TensuraEPCapability.isMajin(living)) {
            return true;
        }
        return TensuraPlayerCapability.isTrueHero(living);
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        TensuraEPCapability.getFrom(entity).ifPresent(cap -> cap.setChaos(true));
        TensuraEPCapability.sync(entity);
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        TensuraEPCapability.getFrom(entity).ifPresent(cap -> cap.setChaos(false));
        TensuraEPCapability.sync(entity);
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        LivingEntity target = SkillHelper.getTargetingEntity(entity, 3.0, false);
        if (target != null) {
            boolean success;
            Player player;
            if (target instanceof Player) {
                player = (Player)target;
                if (player.m_150110_().f_35934_) {
                    return;
                }
            }
            if (instance.getMode() == 1) {
                if (!instance.isMastered(entity)) {
                    if (entity instanceof Player) {
                        player = (Player)entity;
                        player.m_5661_((Component)Component.m_237115_((String)"tensura.ability.activation_failed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    }
                    return;
                }
                if (this.canTurnChaos(target)) {
                    TensuraEPCapability.getFrom(target).ifPresent(cap -> {
                        if (cap.isChaos()) {
                            cap.setChaos(false);
                            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_235898_, 2.0);
                            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11739_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        } else {
                            cap.setChaos(true);
                            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)TensuraParticles.SOUL.get(), 2.0);
                            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11739_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        }
                    });
                    TensuraEPCapability.sync(target);
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                } else if (entity instanceof Player) {
                    player = (Player)entity;
                    player.m_5661_((Component)Component.m_237115_((String)"tensura.targeting.not_allowed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                }
            }
            boolean bl = success = instance.getMode() == 2 ? this.reverseDebuff(target) : this.reverseBuff(target);
            if (success) {
                this.addMasteryPoint(instance, entity);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123749_, 2.0);
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            entity.m_21011_(InteractionHand.MAIN_HAND, true);
        } else if (instance.getMode() == 2) {
            if (this.reverseDebuff(entity)) {
                this.addMasteryPoint(instance, entity);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123749_, 2.0);
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            entity.m_21011_(InteractionHand.MAIN_HAND, true);
        } else if (instance.getMode() == 1) {
            if (!this.canTurnChaos(entity)) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237115_((String)"tensura.ability.activation_failed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                }
                return;
            }
            boolean chaos = TensuraEPCapability.isChaos(entity);
            instance.setToggled(!chaos);
            if (chaos) {
                instance.onToggleOff(entity);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_235898_, 2.0);
            } else {
                instance.onToggleOn(entity);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)TensuraParticles.SOUL.get(), 2.0);
            }
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11739_, SoundSource.PLAYERS, 1.0f, 1.0f);
            entity.m_21011_(InteractionHand.MAIN_HAND, true);
        }
    }

    private boolean reverseDebuff(LivingEntity entity) {
        boolean success = false;
        List<MobEffectInstance> effects = List.copyOf(entity.m_21220_());
        for (MobEffectInstance effectInstance : effects) {
            if (MinecraftForge.EVENT_BUS.post((Event)new MobEffectEvent.Remove(entity, effectInstance)) || effectInstance.m_19544_().m_19483_() != MobEffectCategory.HARMFUL) continue;
            List<MobEffect> list = this.debuffToBuff(effectInstance.m_19544_());
            if (!list.isEmpty()) {
                list.forEach(reversed -> entity.m_7292_(new MobEffectInstance(reversed, effectInstance.m_19557_(), effectInstance.m_19564_(), effectInstance.m_19571_(), effectInstance.m_19572_(), effectInstance.m_19575_())));
                success = true;
            }
            entity.m_21195_(effectInstance.m_19544_());
        }
        return success;
    }

    private boolean reverseBuff(LivingEntity entity) {
        boolean success = false;
        List<MobEffectInstance> effects = List.copyOf(entity.m_21220_());
        for (MobEffectInstance effectInstance : effects) {
            List<MobEffect> list;
            if (MinecraftForge.EVENT_BUS.post((Event)new MobEffectEvent.Remove(entity, effectInstance)) || !effectInstance.m_19544_().m_19486_() || (list = this.buffToDebuff(effectInstance.m_19544_())).isEmpty()) continue;
            list.forEach(reversed -> entity.m_7292_(new MobEffectInstance(reversed, effectInstance.m_19557_(), effectInstance.m_19564_(), effectInstance.m_19571_(), effectInstance.m_19572_(), effectInstance.m_19575_())));
            entity.m_21195_(effectInstance.m_19544_());
            success = true;
        }
        return success;
    }

    private List<MobEffect> debuffToBuff(MobEffect mobEffect) {
        if (mobEffect.equals(MobEffects.f_19597_)) {
            return List.of(MobEffects.f_19596_);
        }
        if (mobEffect.equals(TensuraMobEffects.PARALYSIS.get())) {
            return List.of(MobEffects.f_19596_);
        }
        if (mobEffect.equals(MobEffects.f_19615_)) {
            return List.of(MobEffects.f_19605_);
        }
        if (mobEffect.equals(MobEffects.f_19614_)) {
            return List.of(MobEffects.f_19605_);
        }
        if (mobEffect.equals(TensuraMobEffects.CORROSION.get())) {
            return List.of(MobEffects.f_19605_);
        }
        if (mobEffect.equals(TensuraMobEffects.FATAL_POISON.get())) {
            return List.of(MobEffects.f_19605_);
        }
        if (mobEffect.equals(TensuraMobEffects.BURDEN.get())) {
            return List.of(MobEffects.f_19591_, MobEffects.f_19596_, MobEffects.f_19603_);
        }
        if (mobEffect.equals(TensuraMobEffects.FRAGILITY.get())) {
            return List.of(MobEffects.f_19606_);
        }
        if (mobEffect.equals(MobEffects.f_19599_)) {
            return List.of(MobEffects.f_19598_);
        }
        if (mobEffect.equals(MobEffects.f_19612_)) {
            return List.of(MobEffects.f_19618_);
        }
        if (mobEffect.equals(MobEffects.f_19590_)) {
            return List.of(MobEffects.f_19621_);
        }
        if (mobEffect.equals(MobEffects.f_19613_)) {
            return List.of(MobEffects.f_19600_);
        }
        return List.of();
    }

    private List<MobEffect> buffToDebuff(MobEffect mobEffect) {
        if (mobEffect.equals(MobEffects.f_19596_)) {
            return List.of(MobEffects.f_19597_);
        }
        if (mobEffect.equals(MobEffects.f_19605_)) {
            return List.of(MobEffects.f_19615_);
        }
        if (mobEffect.equals(MobEffects.f_19591_)) {
            return List.of((MobEffect)TensuraMobEffects.BURDEN.get());
        }
        if (mobEffect.equals(MobEffects.f_19603_)) {
            return List.of((MobEffect)TensuraMobEffects.BURDEN.get());
        }
        if (mobEffect.equals(MobEffects.f_19606_)) {
            return List.of((MobEffect)TensuraMobEffects.FRAGILITY.get());
        }
        if (mobEffect.equals(MobEffects.f_19598_)) {
            return List.of(MobEffects.f_19599_);
        }
        if (mobEffect.equals(MobEffects.f_19618_)) {
            return List.of(MobEffects.f_19612_);
        }
        if (mobEffect.equals(MobEffects.f_19621_)) {
            return List.of(MobEffects.f_19590_);
        }
        if (mobEffect.equals(MobEffects.f_19600_)) {
            return List.of(MobEffects.f_19613_);
        }
        return List.of();
    }
}

