/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.entity.magic.skill.SniperGrenadeProjectile;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.items.TensuraToolItems;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class SniperSkill
extends Skill {
    public SniperSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double getObtainingEpCost() {
        return 25000.0;
    }

    @Override
    public double learningCost() {
        return 200.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isToggled();
    }

    @Override
    public int modes() {
        return 2;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return instance.getMode() == 1 ? 2 : 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.sniper.weapon");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.sniper.spatial");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 2 -> 200.0;
            case 1 -> 100.0;
            default -> 0.0;
        };
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        if (SkillHelper.outOfMagicule(entity, 25.0)) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.lack_magicule.toggled_off", (Object[])new Object[]{instance.getSkill().getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
            instance.setToggled(false);
            return;
        }
        entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get(), 200, 1, false, false, false));
    }

    public void onBeingDamaged(ManasSkillInstance instance, LivingAttackEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (!this.isInSlot(entity)) {
            return;
        }
        DamageSource damageSource = event.getSource();
        if (damageSource.m_19378_() || damageSource.m_19387_()) {
            return;
        }
        if (damageSource.m_7640_() == null || damageSource.m_7640_() != damageSource.m_7639_()) {
            return;
        }
        if (entity.m_217043_().m_188501_() > 0.25f) {
            return;
        }
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 2.0f, 1.0f);
        event.setCanceled(true);
        if (SkillUtils.canNegateDodge(entity, damageSource)) {
            event.setCanceled(false);
        }
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity living, LivingHurtEvent e) {
        if (!instance.isToggled()) {
            return;
        }
        if (SkillUtils.isSkillToggled((Entity)living, (ManasSkill)ExtraSkills.SPATIAL_DOMINATION.get())) {
            return;
        }
        if (SkillUtils.isSkillToggled((Entity)living, (ManasSkill)ExtraSkills.SPATIAL_MANIPULATION.get())) {
            return;
        }
        if (DamageSourceHelper.isSpatialDamage(e.getSource())) {
            e.setAmount(e.getAmount() * 2.0f);
        }
    }

    public void onProjectileHit(ManasSkillInstance instance, LivingEntity entity, ProjectileImpactEvent event) {
        if (!this.isInSlot(entity)) {
            return;
        }
        if (SkillUtils.isProjectileAlwaysHit(event.getProjectile())) {
            return;
        }
        if (entity.m_217043_().m_188501_() > 0.25f) {
            return;
        }
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 2.0f, 1.0f);
        event.setCanceled(true);
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        boolean hadPistol;
        Level level = entity.m_9236_();
        if (instance.getMode() != 1) {
            return;
        }
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        boolean bl = hadPistol = entity.m_21206_().m_150930_((Item)TensuraToolItems.SNIPER_PISTOL.get()) || entity.m_21205_().m_150930_((Item)TensuraToolItems.SNIPER_PISTOL.get());
        if (hadPistol || SkillHelper.getTargetingEntity(entity, 30.0, 0.0, false, false) != null) {
            this.addMasteryPoint(instance, entity);
            instance.setCoolDown(instance.isMastered(entity) ? 1 : 3);
            SniperGrenadeProjectile grenade = new SniperGrenadeProjectile(entity.m_9236_(), entity);
            grenade.setSpeed(2.0f);
            grenade.setExplosionRadius(4.0f);
            grenade.setMpCost(this.magiculeCost(entity, instance));
            grenade.setSkill(instance);
            grenade.setPosAndShoot(entity);
            level.m_7967_((Entity)grenade);
            entity.m_21011_(InteractionHand.MAIN_HAND, true);
            return;
        }
        if (entity.m_21205_().m_41619_()) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_36335_().m_41524_((Item)TensuraToolItems.SNIPER_PISTOL.get(), 10);
            }
            entity.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)TensuraToolItems.SNIPER_PISTOL.get()));
            entity.m_21011_(InteractionHand.MAIN_HAND, true);
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
        } else if (entity.m_21206_().m_41619_()) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_36335_().m_41524_((Item)TensuraToolItems.SNIPER_PISTOL.get(), 10);
            }
            entity.m_21008_(InteractionHand.OFF_HAND, new ItemStack((ItemLike)TensuraToolItems.SNIPER_PISTOL.get()));
            entity.m_21011_(InteractionHand.OFF_HAND, true);
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        this.onTick(instance, entity);
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        int level;
        if (entity.m_21023_((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get()) && (level = Objects.requireNonNull(entity.m_21124_((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get())).m_19564_()) == 1) {
            entity.m_21195_((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get());
        }
    }
}

