/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.magic.misc.ThrownItemProjectile;
import com.github.manasmods.tensura.entity.projectile.KunaiProjectile;
import com.github.manasmods.tensura.entity.projectile.SevererBladeProjectile;
import com.github.manasmods.tensura.entity.projectile.SpearProjectile;
import com.github.manasmods.tensura.entity.projectile.ThrownHolyWater;
import com.github.manasmods.tensura.entity.projectile.WebBulletProjectile;
import com.github.manasmods.tensura.item.custom.HolyWaterItem;
import com.github.manasmods.tensura.item.custom.KunaiItem;
import com.github.manasmods.tensura.item.custom.WebCartridgeItem;
import com.github.manasmods.tensura.item.templates.custom.SimpleSpearItem;
import com.github.manasmods.tensura.registry.items.TensuraToolItems;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.entity.projectile.ThrownExperienceBottle;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.EggItem;
import net.minecraft.world.item.EnderpearlItem;
import net.minecraft.world.item.ExperienceBottleItem;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SnowballItem;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ThrowerSkill
extends Skill {
    public ThrowerSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double getObtainingEpCost() {
        return 15000.0;
    }

    @Override
    public double learningCost() {
        return 40.0;
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 40.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        block11: {
            block10: {
                if (SkillHelper.outOfMagicule(entity, instance)) {
                    return;
                }
                instance.addMasteryPoint(entity);
                level = entity.m_9236_();
                mainHandStack = entity.m_21205_();
                target = SkillHelper.getTargetingEntity(entity, 4.0, false);
                if (target != null) {
                    scale = 3.0;
                    if (SkillUtils.isSkillToggled((Entity)entity, (ManasSkill)ExtraSkills.GRAVITY_DOMINATION.get())) {
                        scale += 2.0;
                    } else if (SkillUtils.isSkillToggled((Entity)entity, (ManasSkill)ExtraSkills.GRAVITY_MANIPULATION.get())) {
                        scale += 1.0;
                    }
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123796_, 1.0);
                    entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    vec3 = new Vec3(target.m_20185_() - entity.m_20185_(), target.m_20186_() - entity.m_20186_() + 0.5, target.m_20189_() - entity.m_20189_()).m_82490_(1.0 / (double)target.m_20270_((Entity)entity));
                    target.m_20256_(vec3.m_82541_().m_82490_(scale));
                    target.f_19812_ = true;
                    target.f_19864_ = true;
                    return;
                }
                projectile = ThrowerSkill.getProjectile(level, entity, mainHandStack, instance);
                speed = instance.isToggled() != false ? 1.0f : 3.0f;
                vector3f = new Vector3f(entity.m_20252_(speed));
                if (!(projectile instanceof AbstractArrow)) break block10;
                arrow = (AbstractArrow)projectile;
                if (!(entity instanceof Player)) ** GOTO lbl-1000
                player = (Player)entity;
                if (player.m_150110_().f_35937_) {
                    arrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                } else lbl-1000:
                // 2 sources

                {
                    arrow.f_36705_ = AbstractArrow.Pickup.ALLOWED;
                }
                break block11;
            }
            if (projectile instanceof ThrowableItemProjectile) {
                itemProjectile = (ThrowableItemProjectile)projectile;
                itemProjectile.m_37446_(mainHandStack);
            }
        }
        projectile.m_6686_((double)vector3f.m_122239_(), (double)vector3f.m_122260_(), (double)vector3f.m_122269_(), 2.0f, 0.0f);
        level.m_7967_((Entity)projectile);
        entity.m_21011_(entity.m_7655_(), true);
        if (entity instanceof Player) {
            player = (Player)entity;
            if (!player.m_150110_().f_35937_) {
                mainHandStack.m_41774_(1);
            }
        }
    }

    public static Projectile getProjectile(Level level, LivingEntity entity, ItemStack stack, @Nullable ManasSkillInstance instance) {
        Item item = stack.m_41720_();
        if (item instanceof ArrowItem) {
            ArrowItem arrowItem = (ArrowItem)item;
            AbstractArrow arrow = arrowItem.m_6394_(level, stack, entity);
            double baseDamage = arrow.m_36789_() + (double)(instance != null && instance.isMastered(entity) ? 50 : 30);
            if (SkillUtils.isSkillToggled((Entity)entity, (ManasSkill)ExtraSkills.GRAVITY_DOMINATION.get())) {
                baseDamage *= 3.0;
            } else if (SkillUtils.isSkillToggled((Entity)entity, (ManasSkill)ExtraSkills.GRAVITY_MANIPULATION.get())) {
                baseDamage *= 2.0;
            }
            arrow.m_36781_(baseDamage);
            return arrow;
        }
        if (stack.m_41720_() instanceof ExperienceBottleItem) {
            return new ThrownExperienceBottle(level, entity);
        }
        if (stack.m_41720_() instanceof EggItem) {
            return new ThrownEgg(level, entity);
        }
        if (stack.m_41720_() instanceof EnderpearlItem) {
            return new ThrownEnderpearl(level, entity);
        }
        if (stack.m_41720_() instanceof SnowballItem) {
            return new Snowball(level, entity);
        }
        if (stack.m_41720_() instanceof FireworkRocketItem) {
            return new FireworkRocketEntity(level, stack, (Entity)entity, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), true);
        }
        if (stack.m_41720_() instanceof ThrowablePotionItem) {
            return new ThrownPotion(level, entity);
        }
        if (stack.m_41720_() instanceof HolyWaterItem) {
            return new ThrownHolyWater(level, entity);
        }
        if (stack.m_41720_() instanceof WebCartridgeItem) {
            return new WebBulletProjectile(level, entity, true, stack, stack);
        }
        float baseDamage = stack.m_41619_() ? (instance != null && instance.isMastered(entity) ? 50.0f : 30.0f) : (instance != null && instance.isMastered(entity) ? 100.0f : 50.0f);
        int multiplier = 1;
        if (SkillUtils.isSkillToggled((Entity)entity, (ManasSkill)ExtraSkills.GRAVITY_DOMINATION.get())) {
            multiplier = 3;
        } else if (SkillUtils.isSkillToggled((Entity)entity, (ManasSkill)ExtraSkills.GRAVITY_MANIPULATION.get())) {
            multiplier = 2;
        }
        baseDamage *= (float)multiplier;
        if (stack.m_41720_().equals(TensuraToolItems.SEVERER_BLADE.get())) {
            SevererBladeProjectile blade = new SevererBladeProjectile(level, entity, true, stack);
            blade.setBaseDamage(baseDamage);
            return blade;
        }
        if (stack.m_41720_() instanceof TridentItem) {
            ThrownTrident trident = new ThrownTrident(level, entity, stack);
            trident.m_36781_((double)baseDamage);
            return trident;
        }
        if (stack.m_41720_() instanceof SimpleSpearItem) {
            SpearProjectile spear = new SpearProjectile(level, entity, stack, true);
            spear.m_36781_(baseDamage);
            if (instance != null && instance.isMastered(entity)) {
                spear.setLoyaltyLevel(Math.max(multiplier, spear.getLoyaltyLevel()));
            }
            return spear;
        }
        if (stack.m_41720_() instanceof KunaiItem) {
            ItemStack kunai = stack.m_41777_();
            kunai.m_41764_(1);
            KunaiProjectile kunaiProjectile = new KunaiProjectile(level, entity, kunai, true);
            kunaiProjectile.m_36781_(baseDamage);
            if (instance != null && instance.isMastered(entity)) {
                kunaiProjectile.setLoyaltyLevel(Math.max(multiplier, kunaiProjectile.getLoyaltyLevel()));
            }
            return kunaiProjectile;
        }
        ThrownItemProjectile projectile = new ThrownItemProjectile(level, entity, stack, true, baseDamage);
        projectile.getSourceItem().m_41764_(1);
        projectile.setWeaponDamage(DamageSourceHelper.getMainWeaponDamage(entity, null));
        if (instance != null && instance.isMastered(entity)) {
            projectile.setLoyaltyLevel(multiplier);
        }
        return projectile;
    }

    @Nullable
    public static LivingEntity getHomingEntity(LivingEntity player) {
        return SkillHelper.getTargetingEntity(player, 50.0, false);
    }

    @Nullable
    public static BlockPos getHomingPos(LivingEntity player) {
        if (!SkillUtils.isSkillToggled((Entity)player, (ManasSkill)UniqueSkills.THROWER.get())) {
            return null;
        }
        LivingEntity target = ThrowerSkill.getHomingEntity(player);
        if (target != null) {
            return target.m_20183_();
        }
        return SkillHelper.getPlayerPOVHitResult(player.m_9236_(), (Entity)player, ClipContext.Fluid.NONE, 50.0).m_82425_();
    }
}

