/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.SpatialMotionSkill;
import com.github.manasmods.tensura.effect.template.MobEffectHelper;
import com.github.manasmods.tensura.entity.magic.projectile.SpatialArrowProjectile;
import com.github.manasmods.tensura.menu.SpatialMenu;
import com.github.manasmods.tensura.registry.blocks.TensuraBlocks;
import com.github.manasmods.tensura.registry.dimensions.TensuraDimensions;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.mojang.math.Vector3f;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.network.NetworkHooks;

public class TravelerSkill
extends Skill {
    public TravelerSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double getObtainingEpCost() {
        return 25000.0;
    }

    @Override
    public double learningCost() {
        return 5000.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    @Override
    public int modes() {
        return 5;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return switch (instance.getMode()) {
                case 5 -> 4;
                case 4 -> 3;
                case 3 -> 2;
                case 2 -> 1;
                case 1 -> {
                    if (instance.isMastered(entity)) {
                        yield 5;
                    }
                    yield 4;
                }
                default -> 0;
            };
        }
        return switch (instance.getMode()) {
            case 4 -> {
                if (instance.isMastered(entity)) {
                    yield 5;
                }
                yield 1;
            }
            case 3 -> 4;
            case 2 -> 3;
            case 1 -> 2;
            default -> 1;
        };
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.traveler.instant_motion");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.traveler.teleport");
            case 3 -> Component.m_237115_((String)"tensura.skill.mode.sniper.spatial");
            case 4 -> Component.m_237115_((String)"tensura.skill.mode.traveler.stardust_arrow");
            case 5 -> Component.m_237115_((String)"tensura.skill.mode.traveler.stardust_rain");
            default -> Component.m_237119_();
        };
    }

    @Override
    public String modeLearningId(int mode) {
        return switch (mode) {
            case 4 -> "stardustArrow";
            case 5 -> "stardustRain";
            default -> "None";
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 1, 2 -> 100.0;
            case 4 -> 150.0;
            case 5 -> 5000.0;
            default -> 0.0;
        };
    }

    @Override
    public double auraCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 4 -> 150.0;
            case 5 -> 5000.0;
            default -> 0.0;
        };
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity living, LivingHurtEvent e) {
        if (!instance.isToggled()) {
            return;
        }
        if (SkillUtils.isSkillToggled((Entity)living, (ManasSkill)ExtraSkills.SPATIAL_DOMINATION.get())) {
            return;
        }
        if (SkillUtils.isSkillToggled((Entity)living, (ManasSkill)ExtraSkills.SPATIAL_MANIPULATION.get())) {
            return;
        }
        if (DamageSourceHelper.isSpatialDamage(e.getSource())) {
            e.setAmount(e.getAmount() * 2.0f);
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        Level level = entity.m_9236_();
        switch (instance.getMode()) {
            case 1: {
                if (MobEffectHelper.noTeleportation(entity)) {
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.spatial_blockade").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                    }
                    return;
                }
                BlockHitResult result = SkillHelper.getPlayerPOVHitResult(level, (Entity)entity, ClipContext.Fluid.NONE, 200.0);
                BlockPos pos = result.m_82425_().m_121945_(result.m_82434_());
                if (level.m_8055_(pos).m_60713_((Block)TensuraBlocks.LABYRINTH_BARRIER_BLOCK.get())) {
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    return;
                }
                if (SkillHelper.outOfMagicule(entity, 5.0 * Math.sqrt(entity.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())))) {
                    return;
                }
                SpatialMotionSkill.warp(entity, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                this.addMasteryPoint(instance, entity);
                instance.setCoolDown(instance.isMastered(entity) ? 2 : 5);
                break;
            }
            case 2: {
                if (MobEffectHelper.noTeleportation(entity)) {
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.spatial_blockade").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                    }
                    return;
                }
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    if (level.m_46472_() == TensuraDimensions.LABYRINTH) {
                        serverPlayer.m_6330_(SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        serverPlayer.m_5661_((Component)Component.m_237115_((String)"tensura.ability.activation_failed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                    } else {
                        NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider(SpatialMenu::new, (Component)Component.m_237119_()), buf -> buf.writeBoolean(false));
                        serverPlayer.m_6330_(SoundEvents.f_11889_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                }
                entity.m_21195_((MobEffect)TensuraMobEffects.WARPING.get());
                break;
            }
            case 4: {
                if (SkillHelper.outOfEachEP(entity, this.magiculeCost(entity, instance))) {
                    return;
                }
                CompoundTag tag = instance.getOrCreateTag();
                int learnPoint = tag.m_128451_("stardustArrow");
                if (learnPoint < 100) {
                    tag.m_128405_("stardustArrow", learnPoint + SkillUtils.getEarningLearnPoint(instance, entity, true));
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        if (tag.m_128451_("stardustArrow") >= 100) {
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire_learning", (Object[])new Object[]{this.getModeName(4)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                        } else {
                            instance.setCoolDown(10);
                            SkillUtils.learningFailPenalty(entity);
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_points_added", (Object[])new Object[]{this.getModeName(4)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
                        }
                        player.m_6330_(SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    instance.markDirty();
                    return;
                }
                SpatialArrowProjectile arrow = new SpatialArrowProjectile(level, entity);
                arrow.setSkill(instance);
                arrow.setDamage(30.0f);
                arrow.setMpCost(this.magiculeCost(entity, instance));
                if (!this.warpShotArrow(entity, arrow)) {
                    arrow.m_6034_(entity.m_20185_(), entity.m_20188_() - (double)0.2f, entity.m_20189_());
                    Vector3f vector3f = new Vector3f(entity.m_20252_(2.0f));
                    arrow.m_6686_(vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_(), 2.0f, 0.0f);
                }
                level.m_7967_((Entity)arrow);
                level.m_6263_(null, arrow.m_20185_(), arrow.m_20186_(), arrow.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 5: {
                if (SkillHelper.outOfEachEP(entity, this.magiculeCost(entity, instance))) {
                    return;
                }
                CompoundTag tag = instance.getOrCreateTag();
                int learnPoint = tag.m_128451_("stardustRain");
                if (learnPoint < 100) {
                    tag.m_128405_("stardustRain", learnPoint + SkillUtils.getEarningLearnPoint(instance, entity, true));
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        if (tag.m_128451_("stardustRain") >= 100) {
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire_learning", (Object[])new Object[]{this.getModeName(5)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                        } else {
                            instance.setCoolDown(10);
                            SkillUtils.learningFailPenalty(entity);
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_points_added", (Object[])new Object[]{this.getModeName(5)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
                        }
                        player.m_6330_(SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    instance.markDirty();
                    return;
                }
                LivingEntity target = SkillHelper.getTargetingEntity(entity, 20.0, false);
                if (target == null) {
                    return;
                }
                Vec3 pos = target.m_20182_().m_82520_(0.0, (double)target.m_20192_(), 0.0);
                int arrowAmount = 12;
                for (int i = 0; i < arrowAmount; ++i) {
                    Vec3 arrowPos = pos.m_82549_(new Vec3(0.0, Math.random() - 0.5, 0.6).m_82541_().m_82490_((double)(target.m_20205_() + 6.0f)).m_82524_(360.0f * (float)i * ((float)Math.PI / 180) / (float)arrowAmount));
                    SpatialArrowProjectile arrow = new SpatialArrowProjectile(level, entity);
                    arrow.setSkill(instance);
                    arrow.setSpeed(1.0f);
                    arrow.m_146884_(arrowPos);
                    arrow.shootFromRot(pos.m_82546_(arrowPos).m_82541_());
                    arrow.setLife(50);
                    arrow.setDamage(30.0f);
                    arrow.setMpCost(5000.0f / (float)arrowAmount);
                    level.m_7967_((Entity)arrow);
                    level.m_6263_(null, arrow.m_20185_(), arrow.m_20186_(), arrow.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                break;
            }
        }
    }

    private boolean warpShotArrow(LivingEntity owner, SpatialArrowProjectile arrow) {
        if (!owner.m_6144_()) {
            return false;
        }
        Entity entity = SkillHelper.getTargetingEntity(owner, 30.0, 0.0, false, false);
        if (entity == null) {
            return false;
        }
        arrow.shootFromBehind(entity, 2.0f, 0.0f);
        return true;
    }
}

