/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.human.CloneEntity;
import com.github.manasmods.tensura.event.SkillPlunderEvent;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.world.TensuraGameRules;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.Event;

public class UnyieldingSkill
extends Skill {
    public UnyieldingSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double getObtainingEpCost() {
        return 30000.0;
    }

    @Override
    public double learningCost() {
        return 10000.0;
    }

    @Override
    public int modes() {
        return 2;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return instance.getMode() == 1 ? 2 : 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.unyielding.return");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.unyielding.backup");
            default -> Component.m_237119_();
        };
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return true;
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        Collection uuidList = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(30.0), target -> this.isNamed(entity, (LivingEntity)target)).stream().map(Entity::m_20149_).collect(Collectors.toList());
        CompoundTag tag = instance.getOrCreateTag();
        if (tag.m_128441_("UnyieldingList")) {
            CompoundTag list = (CompoundTag)tag.m_128423_("UnyieldingList");
            if (list == null) {
                return;
            }
            List<String> keyList = List.copyOf(list.m_128431_());
            if (!keyList.isEmpty()) {
                for (String key : keyList) {
                    if (uuidList.contains(key)) {
                        list.m_128405_(key, list.m_128451_(key) + (instance.isMastered(entity) ? 2 : 1));
                        uuidList.remove(key);
                        continue;
                    }
                    int point = list.m_128451_(key) - 1;
                    list.m_128405_(key, point);
                    if (point > 0) continue;
                    list.m_128473_(key);
                }
            }
            if (!uuidList.isEmpty()) {
                for (String key : uuidList) {
                    list.m_128405_(key, Math.min(list.m_128451_(key) + 10, 1200));
                }
            }
            instance.markDirty();
        } else if (!uuidList.isEmpty()) {
            for (String uuid : uuidList) {
                CompoundTag list = new CompoundTag();
                list.m_128405_(uuid, 1);
                tag.m_128365_("UnyieldingList", (Tag)list);
            }
            instance.markDirty();
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        Player player;
        if (instance.getMode() == 1) {
            LivingEntity target = SkillHelper.getTargetingEntity(entity, 6.0, false);
            if (target != null && target.m_7307_((Entity)entity) && entity instanceof Player) {
                Player player2 = (Player)entity;
                player2.m_5661_((Component)Component.m_237110_((String)"tensura.skill.mode.unyielding.check_point", (Object[])new Object[]{target.m_7755_(), this.getUnyieldingPoint(instance, target)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.AQUA)), true);
            }
            return;
        }
        Level player2 = entity.m_9236_();
        if (!(player2 instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)player2;
        CompoundTag tag = instance.getOrCreateTag();
        double maxMP = entity.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
        if (!tag.m_128441_("Backup")) {
            if (!SkillHelper.outOfMagicule(entity, maxMP * 0.25)) {
                this.spawnBackup(instance, entity, false);
                instance.setCoolDown(instance.isMastered(entity) ? 3 : 5);
            }
            return;
        }
        UUID uuid = tag.m_128342_("Backup");
        Entity entity2 = SkillHelper.getEntityFromUUID(level, uuid, clone -> clone instanceof CloneEntity);
        if (!(entity2 instanceof CloneEntity)) {
            if (!SkillHelper.outOfMagicule(entity, maxMP * 0.25)) {
                this.spawnBackup(instance, entity, false);
                instance.setCoolDown(instance.isMastered(entity) ? 3 : 5);
            }
            return;
        }
        CloneEntity backup = (CloneEntity)entity2;
        if (entity.m_6144_()) {
            if (entity instanceof Player) {
                player = (Player)entity;
                player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.mode.unyielding.backup_remove").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            backup.remove();
            return;
        }
        if (backup.m_9236_() != entity.m_9236_() && !instance.isMastered(entity)) {
            if (entity instanceof Player) {
                player = (Player)entity;
                player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.mode.unyielding.backup_different_dimension").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
            return;
        }
        if (!backup.m_6084_()) {
            return;
        }
        instance.setCoolDown(instance.isMastered(entity) ? 3 : 5);
        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
        CloneEntity body = this.spawnBackup(instance, entity, true);
        body.m_7311_(entity.m_20094_());
        SkillHelper.moveAcrossDimensionTo((Entity)entity, (Entity)backup);
        backup.copyEquipmentsOntoOwner(entity, true);
        CloneEntity.copyEffects((LivingEntity)backup, entity);
        entity.m_21153_(backup.m_21223_());
        backup.remove();
    }

    private CloneEntity spawnBackup(ManasSkillInstance instance, LivingEntity entity, boolean copyEquipment) {
        Level level = entity.m_9236_();
        CompoundTag tag = instance.getOrCreateTag();
        double EP = TensuraEPCapability.getEP(entity);
        EntityType type = entity.m_6144_() ? (EntityType)TensuraEntityTypes.CLONE_SLIM.get() : (EntityType)TensuraEntityTypes.CLONE_DEFAULT.get();
        CloneEntity clone = new CloneEntity((EntityType<? extends CloneEntity>)type, level);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            clone.m_21828_(player);
        }
        clone.setSkill(this);
        clone.setImmobile(true);
        clone.setChunkLoader(true);
        clone.m_21153_(entity.m_21223_());
        if (copyEquipment) {
            clone.copyEquipments(entity);
        }
        clone.copyStatsAndSkills(entity, CloneEntity.CopySkill.NONE, true);
        CloneEntity.copyEffects(entity, (LivingEntity)clone);
        TensuraEPCapability.setLivingEP((LivingEntity)clone, EP);
        clone.m_146884_(entity.m_20182_());
        clone.loadChunkHandler();
        CloneEntity.copyRotation(entity, (LivingEntity)clone);
        level.m_7967_((Entity)clone);
        tag.m_128362_("Backup", clone.m_20148_());
        instance.markDirty();
        return clone;
    }

    public void onDeath(ManasSkillInstance instance, LivingDeathEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (entity.m_6084_() || entity instanceof CloneEntity) {
            return;
        }
        Level level = entity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        CompoundTag tag = instance.getOrCreateTag();
        if (!tag.m_128441_("Backup")) {
            return;
        }
        UUID uuid = tag.m_128342_("Backup");
        Entity entity2 = SkillHelper.getEntityFromUUID(level2, uuid, clone -> clone instanceof CloneEntity);
        if (!(entity2 instanceof CloneEntity)) {
            return;
        }
        CloneEntity backup = (CloneEntity)entity2;
        this.addMasteryPoint(instance, entity);
        level2.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
        entity.f_19802_ = 60;
        entity.m_21153_(backup.m_21223_());
        entity.m_7311_(backup.m_20094_());
        event.setCanceled(true);
        TensuraEffectsCapability.resetEverything(entity, false, false);
        TensuraEPCapability.getFrom(entity).ifPresent(cap -> {
            if (cap.getEP() <= 0.0) {
                cap.setEP(entity, 100.0, false);
            } else if (cap.getCurrentEP() <= 0.0) {
                cap.setCurrentEP(entity, cap.getEP() * 0.5);
            }
            double SHP = entity.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get());
            if (cap.getSpiritualHealth() < SHP * 0.5) {
                cap.setSpiritualHealth(SHP * 0.5);
            }
        });
        TensuraEPCapability.sync(entity);
        CloneEntity clone2 = this.spawnBackup(instance, entity, true);
        CloneEntity.copyEffects(entity, (LivingEntity)clone2);
        boolean keepInv = level2.m_46469_().m_46207_(GameRules.f_46133_);
        if (!keepInv) {
            clone2.m_6667_(event.getSource());
            clone2.remove();
        }
        SkillHelper.moveAcrossDimensionTo((Entity)entity, (Entity)backup);
        backup.copyEquipmentsOntoOwner(entity, true);
        CloneEntity.copyEffects((LivingEntity)backup, entity);
        backup.remove();
        if (keepInv && (clone2 = (CloneEntity)SkillHelper.moveAcrossDimensionTo((Entity)clone2, (Entity)entity)) != null) {
            clone2.remove();
        }
    }

    @Override
    public void onSubordinateDeath(ManasSkillInstance instance, LivingEntity owner, LivingDeathEvent e) {
        LivingEntity entity = e.getEntity();
        if (e.getSource().m_7639_() == owner) {
            return;
        }
        if (!this.isNamed(owner, entity)) {
            return;
        }
        int unyieldingPoint = Math.min(this.getUnyieldingPoint(instance, entity) / 120, 10);
        this.removeUnyielding(instance, entity);
        if (unyieldingPoint < 1) {
            return;
        }
        this.addMasteryPoint(instance, entity, unyieldingPoint);
        TensuraEPCapability.getFrom(entity).ifPresent(cap -> {
            boolean canGainMax;
            double epGain = Math.min(cap.getEP() * 0.1 * (double)unyieldingPoint, (Double)TensuraConfig.INSTANCE.skillsConfig.maximumEPSteal.get());
            SkillHelper.gainMP(owner, epGain / 2.0, false);
            SkillHelper.gainAP(owner, epGain / 2.0, false);
            if (owner instanceof Player) {
                Player player = (Player)owner;
                player.m_5661_((Component)Component.m_237110_((String)"tensura.ep.acquire_fallen", (Object[])new Object[]{epGain, entity.m_7755_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                player.m_6330_(SoundEvents.f_12275_, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            boolean bl = canGainMax = !(entity instanceof Player) || TensuraGameRules.canEpSteal(entity.m_9236_());
            if (canGainMax) {
                SkillHelper.gainMaxMP(owner, epGain / 2.0);
                SkillHelper.gainMaxAP(owner, epGain / 2.0);
                cap.setEP(entity, cap.getEP() - epGain);
                cap.setSkipEPDrop(true);
            }
        });
        if (entity.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_SKILL_PLUNDER)) {
            return;
        }
        if (entity instanceof Player && !entity.m_9236_().m_6106_().m_5466_()) {
            return;
        }
        List<ManasSkillInstance> list = List.copyOf(SkillAPI.getSkillsFrom((Entity)entity).getLearnedSkills());
        if (list.isEmpty()) {
            return;
        }
        for (ManasSkillInstance targetInstance : list) {
            SkillPlunderEvent event;
            if (!this.canGainSkill(targetInstance, unyieldingPoint) || MinecraftForge.EVENT_BUS.post((Event)(event = new SkillPlunderEvent((Entity)entity, (Entity)owner, true, targetInstance.getSkill()))) || !SkillUtils.learnSkill(owner, event.getSkill(), instance.getRemoveTime())) continue;
            SkillAPI.getSkillsFrom((Entity)entity).forgetSkill(event.getSkill());
            if (!(owner instanceof Player)) continue;
            Player player = (Player)owner;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire_fallen", (Object[])new Object[]{event.getSkill().getName(), entity.m_7755_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
            player.m_6330_(SoundEvents.f_12275_, SoundSource.PLAYERS, 0.5f, 1.0f);
        }
    }

    private int getUnyieldingPoint(ManasSkillInstance instance, LivingEntity target) {
        CompoundTag tag = instance.getOrCreateTag();
        if (!tag.m_128441_("UnyieldingList")) {
            return 0;
        }
        CompoundTag list = (CompoundTag)tag.m_128423_("UnyieldingList");
        if (list == null) {
            return 0;
        }
        return list.m_128451_(target.m_20149_());
    }

    private void removeUnyielding(ManasSkillInstance instance, LivingEntity target) {
        CompoundTag tag = instance.getOrCreateTag();
        if (tag.m_128441_("UnyieldingList")) {
            CompoundTag list = (CompoundTag)tag.m_128423_("UnyieldingList");
            if (list == null) {
                return;
            }
            list.m_128473_(target.m_20149_());
        }
        instance.markDirty();
    }

    private boolean isNamed(LivingEntity owner, LivingEntity entity) {
        UUID permanentOwner = TensuraEPCapability.getPermanentOwner(entity);
        if (permanentOwner == null) {
            return false;
        }
        if (!Objects.equals(permanentOwner, owner.m_20148_())) {
            return false;
        }
        if (TensuraEPCapability.getName(entity) == null) {
            return false;
        }
        return !entity.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_EP_PLUNDER);
    }

    private boolean canGainSkill(ManasSkillInstance targetInstance, int point) {
        if (targetInstance.getSkill() == this) {
            return false;
        }
        if (targetInstance.isTemporarySkill() || targetInstance.getMastery() < 0) {
            return false;
        }
        ManasSkill manasSkill = targetInstance.getSkill();
        if (manasSkill instanceof Skill) {
            Skill skill = (Skill)manasSkill;
            if (skill.getType().equals((Object)Skill.SkillType.UNIQUE)) {
                return point >= 5;
            }
            return !skill.getType().equals((Object)Skill.SkillType.ULTIMATE);
        }
        return true;
    }
}

