/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.api.entity.subclass.ISummonable;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.template.TensuraHorseEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.event.SkillPlunderEvent;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.world.TensuraGameRules;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;

public class UsurperSkill
extends Skill {
    public UsurperSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double getObtainingEpCost() {
        return 50000.0;
    }

    @Override
    public double learningCost() {
        return 5000.0;
    }

    @Override
    public int modes() {
        return 3;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return switch (instance.getMode()) {
                case 3 -> 2;
                case 2 -> 1;
                case 1 -> {
                    if (this.isMastered(instance, entity)) {
                        yield 3;
                    }
                    yield 2;
                }
                default -> 0;
            };
        }
        return switch (instance.getMode()) {
            case 2 -> {
                if (this.isMastered(instance, entity)) {
                    yield 3;
                }
                yield 1;
            }
            case 1 -> 2;
            default -> 1;
        };
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.usurper.rob");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.usurper.copy");
            case 3 -> Component.m_237115_((String)"tensura.skill.mode.usurper.force_takeover");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 1, 2 -> 1000.0;
            case 3 -> 5000.0;
            default -> 0.0;
        };
    }

    public void onTouchEntity(ManasSkillInstance instance, LivingEntity attacker, LivingHurtEvent e) {
        if (!this.isInSlot(e.getEntity())) {
            return;
        }
        if (!attacker.m_217043_().m_188499_()) {
            return;
        }
        if (SkillHelper.drainMP(e.getEntity(), attacker, 0.01, true) && attacker instanceof Player) {
            Player player = (Player)attacker;
            player.m_6330_(SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        LivingEntity target = SkillHelper.getTargetingEntity(entity, 10.0, false);
        if (target == null || !target.m_6084_()) {
            return;
        }
        if (target instanceof Player) {
            Player player = (Player)target;
            if (player.m_150110_().f_35934_) {
                return;
            }
        }
        double EP = TensuraEPCapability.getEP(entity);
        double targetEP = TensuraEPCapability.getEP(target);
        entity.m_21011_(InteractionHand.MAIN_HAND, true);
        ServerLevel level = (ServerLevel)entity.m_9236_();
        switch (instance.getMode()) {
            case 1: {
                if (targetEP > EP) {
                    int chance;
                    int n = chance = instance.isMastered(entity) ? 50 : 25;
                    if (entity.m_217043_().m_188503_(100) <= chance) {
                        this.robRandomSkill(instance, entity, target);
                        this.addMasteryPoint(instance, entity);
                        instance.setCoolDown(10);
                        DamageSourceHelper.markHurt(target, (Entity)entity);
                        break;
                    }
                    if (!(entity instanceof Player)) break;
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237115_((String)"tensura.ability.activation_failed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                if (!(entity instanceof Player)) break;
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237115_((String)"tensura.targeting.ep_not_meet").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 2: {
                int chance;
                int n = chance = instance.isMastered(entity) ? 50 : 25;
                if (entity.m_217043_().m_188503_(100) <= chance) {
                    this.copyRandomSkill(instance, entity, target);
                    this.addMasteryPoint(instance, entity);
                    instance.setCoolDown(10);
                    DamageSourceHelper.markHurt(target, (Entity)entity);
                    break;
                }
                if (!(entity instanceof Player)) break;
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237115_((String)"tensura.ability.activation_failed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 3: {
                ISummonable summonable;
                if (target instanceof ISummonable && (summonable = (ISummonable)target).getSummoningTick() > 0) {
                    LivingEntity summoner;
                    Entity entity2;
                    TamableAnimal tamable;
                    if (entity.m_6144_()) {
                        TensuraEPCapability.getFrom(target).ifPresent(cap -> {
                            if (Objects.equals(cap.getTemporaryOwner(), entity.m_20148_())) {
                                cap.setTemporaryOwner(null);
                                UUID owner = cap.getPermanentOwner();
                                if (target instanceof TensuraTamableEntity) {
                                    TensuraTamableEntity tamable = (TensuraTamableEntity)target;
                                    tamable.resetOwner(owner);
                                } else if (target instanceof TensuraHorseEntity) {
                                    TensuraHorseEntity horse = (TensuraHorseEntity)target;
                                    horse.resetOwner(owner);
                                } else if (target instanceof TamableAnimal) {
                                    TamableAnimal animal = (TamableAnimal)target;
                                    animal.m_21816_(owner);
                                    if (owner == null) {
                                        animal.m_7105_(false);
                                    }
                                }
                                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                                TensuraEPCapability.sync(target);
                                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123792_);
                                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12052_, SoundSource.PLAYERS, 1.0f, 1.0f);
                            }
                        });
                        return;
                    }
                    LivingEntity owner = summonable instanceof TamableAnimal && (tamable = (TamableAnimal)summonable).m_21826_() != null ? tamable.m_21826_() : (summonable.getSummonerUUID() != null && (entity2 = SkillHelper.getEntityFromUUID(level, summonable.getSummonerUUID())) instanceof LivingEntity ? (summoner = (LivingEntity)entity2) : target);
                    double ownerEP = TensuraEPCapability.getEP(owner);
                    if (ownerEP <= EP * 0.75) {
                        TensuraEPCapability.getFrom(target).ifPresent(cap -> {
                            cap.setTemporaryOwner(entity.m_20148_());
                            if (summonable instanceof TamableAnimal) {
                                TamableAnimal tamable = (TamableAnimal)summonable;
                                if (entity instanceof Player) {
                                    Player player = (Player)entity;
                                    tamable.m_21828_(player);
                                }
                            }
                            if (target instanceof Mob) {
                                Mob mob = (Mob)target;
                                SkillHelper.removeTarget(mob);
                            }
                            TensuraEPCapability.sync(target);
                        });
                        instance.setCoolDown(10);
                        entity.m_21011_(InteractionHand.MAIN_HAND, true);
                        DamageSourceHelper.markHurt(target, (Entity)entity);
                        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        return;
                    }
                }
                if (targetEP <= EP) {
                    this.robRandomSkill(instance, entity, target);
                    instance.setCoolDown(10);
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                    DamageSourceHelper.markHurt(target, (Entity)entity);
                    break;
                }
                if (!(entity instanceof Player)) break;
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237115_((String)"tensura.targeting.ep_not_meet").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public void robRandomSkill(ManasSkillInstance instance, LivingEntity entity, LivingEntity living) {
        Level level = entity.m_9236_();
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        List<ManasSkillInstance> collection = SkillAPI.getSkillsFrom((Entity)living).getLearnedSkills().stream().filter(this::canRob).toList();
        if (collection.isEmpty()) {
            return;
        }
        ManasSkill skill = collection.get(living.m_217043_().m_188503_(collection.size())).getSkill();
        boolean skillSteal = TensuraGameRules.canStealSkill(level);
        if (storage.getSkill(skill).isEmpty()) {
            SkillPlunderEvent event = new SkillPlunderEvent((Entity)entity, (Entity)living, skillSteal, skill);
            if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                if (UsurperSkill.learnSkillHalfMastery(instance, entity, new TensuraSkillInstance(event.getSkill())) && entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{event.getSkill().getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                }
                if (skillSteal) {
                    SkillAPI.getSkillsFrom((Entity)living).forgetSkill(event.getSkill());
                    SkillAPI.getSkillsFrom((Entity)living).syncChanges();
                }
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        } else {
            Object event = storage.getSkill(skill).get();
            if (event instanceof TensuraSkillInstance) {
                TensuraSkillInstance skillInstance = (TensuraSkillInstance)((Object)event);
                event = new SkillPlunderEvent((Entity)entity, (Entity)living, skillSteal, skill);
                if (!MinecraftForge.EVENT_BUS.post(event)) {
                    skillInstance.setMastery(Math.max(50, skillInstance.getMastery()));
                    if (skillSteal) {
                        SkillAPI.getSkillsFrom((Entity)living).forgetSkill(((SkillPlunderEvent)((Object)event)).getSkill());
                        SkillAPI.getSkillsFrom((Entity)living).syncChanges();
                    }
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public void copyRandomSkill(ManasSkillInstance instance, LivingEntity entity, LivingEntity living) {
        Level level = entity.m_9236_();
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        List<ManasSkillInstance> collection = SkillAPI.getSkillsFrom((Entity)living).getLearnedSkills().stream().filter(this::canCopy).toList();
        if (collection.isEmpty()) {
            return;
        }
        ManasSkill skill = collection.get(living.m_217043_().m_188503_(collection.size())).getSkill();
        if (storage.getSkill(skill).isEmpty()) {
            if (UsurperSkill.learnSkillHalfMastery(instance, entity, new TensuraSkillInstance(skill)) && entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
            }
        } else {
            Object t = storage.getSkill(skill).get();
            if (t instanceof TensuraSkillInstance) {
                TensuraSkillInstance skillInstance = (TensuraSkillInstance)((Object)t);
                skillInstance.setMastery(Math.max(50, skillInstance.getMastery()));
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public static boolean learnSkillHalfMastery(ManasSkillInstance usurper, LivingEntity entity, ManasSkillInstance skill) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        Optional optional = storage.getSkill(skill.getSkill());
        if (optional.isEmpty()) {
            skill.setMastery(50);
            skill.setRemoveTime(usurper.getRemoveTime());
            return storage.learnSkill(skill);
        }
        ManasSkillInstance instance = (ManasSkillInstance)optional.get();
        if (instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
            return false;
        }
        ManasSkillInstance clone = instance.clone();
        clone.setRemoveTime(usurper.getRemoveTime());
        clone.setMastery(50);
        UnlockSkillEvent event = new UnlockSkillEvent(clone, (Entity)entity);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        instance.deserialize(event.getSkillInstance().toNBT());
        instance.markDirty();
        storage.syncChanges();
        return true;
    }

    public boolean canRob(ManasSkillInstance instance) {
        if (instance.isTemporarySkill() || instance.getMastery() < 0) {
            return false;
        }
        ManasSkill manasSkill = instance.getSkill();
        if (manasSkill instanceof Skill) {
            Skill skill = (Skill)manasSkill;
            return skill.getType().equals((Object)Skill.SkillType.COMMON) || skill.getType().equals((Object)Skill.SkillType.EXTRA);
        }
        return !(instance.getSkill() instanceof SpiritualMagic);
    }

    public boolean canCopy(ManasSkillInstance instance) {
        if (instance.isTemporarySkill() || instance.getMastery() < 0) {
            return false;
        }
        ManasSkill manasSkill = instance.getSkill();
        if (manasSkill instanceof Skill) {
            Skill skill = (Skill)manasSkill;
            return skill.getType().equals((Object)Skill.SkillType.COMMON) || skill.getType().equals((Object)Skill.SkillType.EXTRA) || skill.getType().equals((Object)Skill.SkillType.INTRINSIC);
        }
        return !(instance.getSkill() instanceof SpiritualMagic);
    }
}

