/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.DemonLordHakiSkill;
import com.github.manasmods.tensura.ability.skill.extra.HakiSkill;
import com.github.manasmods.tensura.ability.skill.intrinsic.CharmSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.template.TensuraHorseEntity;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class VillainSkill
extends Skill {
    private static final String HAKI = "4d8ed402-9190-4ac5-b623-e620ffc838de";

    public VillainSkill() {
        super(Skill.SkillType.UNIQUE);
        this.addHeldAttributeModifier(Attributes.f_22279_, HAKI, -0.95f, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    @Override
    public double getObtainingEpCost() {
        return 60000.0;
    }

    @Override
    public double learningCost() {
        return 250.0;
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return this.isInSlot(entity);
    }

    @Override
    public int modes() {
        return 2;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return instance.getMode() == 1 ? 2 : 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.villain.haki");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.villain.charisma");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 2 -> 200.0;
            case 1 -> 25.0;
            default -> 0.0;
        };
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        List list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(15.0), living -> living.m_6084_() && (living.m_7307_((Entity)entity) || living.m_7306_((Entity)entity)));
        if (list.isEmpty()) {
            return;
        }
        for (LivingEntity target : list) {
            target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.ALLY_BOOST.get(), 240, 0, false, false, false));
        }
    }

    public double getAttributeModifierAmplifier(ManasSkillInstance instance, LivingEntity entity, AttributeModifier modifier) {
        return modifier.m_22218_() * (instance.isMastered(entity) ? 0.9473684210526315 : 1.0);
    }

    public void addHeldAttributeModifiers(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMode() != 1) {
            return;
        }
        super.addHeldAttributeModifiers(instance, entity);
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (instance.getMode() != 1) {
            return false;
        }
        if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule(entity, instance)) {
            return false;
        }
        if (heldTicks % 100 == 0 && heldTicks > 0) {
            this.addMasteryPoint(instance, entity);
        }
        DemonLordHakiSkill.activateDemonLordHaki(instance, entity, heldTicks);
        return true;
    }

    public void onScroll(ManasSkillInstance instance, LivingEntity entity, double delta) {
        if (instance.getMode() != 1) {
            return;
        }
        HakiSkill.changeEPUsed(instance, entity, delta);
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (instance.getMode() != 1) {
            return;
        }
        if (!this.hasAttributeApplied(entity, Attributes.f_22279_, HAKI)) {
            return;
        }
        instance.setCoolDown(instance.isMastered(entity) ? 3 : 5);
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMode() != 2) {
            return;
        }
        Level level = entity.m_9236_();
        List list = level.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(10.0), target -> !target.m_7306_((Entity)entity) && target.m_6084_() && !target.m_7307_((Entity)entity));
        if (list.isEmpty()) {
            return;
        }
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        this.addMasteryPoint(instance, entity);
        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11868_, SoundSource.PLAYERS, 1.0f, 1.0f);
        for (LivingEntity target2 : list) {
            Mob mob;
            if (target2.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_CHARISMA) || !CharmSkill.canMindControl(target2, level) || target2.m_21023_((MobEffect)TensuraMobEffects.RAMPAGE.get()) || target2 instanceof Mob && (mob = (Mob)target2).m_5912_() || target2 instanceof NeutralMob && (mob = (NeutralMob)target2).m_21660_() || SkillHelper.getSubordinateOwner(target2) != null || SkillUtils.isSkillToggled((Entity)target2, (ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_NULLIFICATION.get())) continue;
            int duration = SkillUtils.isSkillToggled((Entity)target2, (ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_RESISTANCE.get()) ? 1200 : 2400;
            SkillHelper.checkThenAddEffectSource(target2, (Entity)entity, (MobEffect)TensuraMobEffects.MIND_CONTROL.get(), duration, 0, false, false, false, true);
            if (!target2.m_21023_((MobEffect)TensuraMobEffects.MIND_CONTROL.get())) continue;
            TensuraEPCapability.getFrom(target2).ifPresent(cap -> {
                if (!Objects.equals(cap.getTemporaryOwner(), entity.m_20148_())) {
                    cap.setTemporaryOwner(entity.m_20148_());
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        if (target2 instanceof TamableAnimal) {
                            TamableAnimal animal = (TamableAnimal)target2;
                            animal.m_21828_(player);
                        } else if (target2 instanceof TensuraHorseEntity) {
                            TensuraHorseEntity horse = (TensuraHorseEntity)target2;
                            horse.m_30637_(player);
                        }
                    }
                    TensuraEPCapability.sync(target2);
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target2, (ParticleOptions)ParticleTypes.f_123750_);
                }
            });
        }
    }
}

