/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.network.PacketDistributor;

public class WrathSkill
extends Skill {
    public WrathSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double getObtainingEpCost() {
        return 100000.0;
    }

    @Override
    public int getMaxMastery() {
        return 1500;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return instance.isMastered(living);
    }

    @Override
    public int modes() {
        return 2;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return instance.getMode() == 1 ? 2 : 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.wrath.breader");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.wrath.enrage");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return instance.getMode() == 2 ? 100.0 : 0.0;
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        if (!instance.isMastered(entity)) {
            return false;
        }
        return instance.isToggled();
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        this.breederReactor(player);
        TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:wrath_boost"), entity.m_19879_(), 0.0, 1.0, 0.0, true));
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        switch (instance.getMode()) {
            case 1: {
                if (instance.isToggled() && instance.isMastered(entity)) {
                    return false;
                }
                if (!(entity instanceof Player)) {
                    return false;
                }
                Player player = (Player)entity;
                if (heldTicks % 100 == 0 && heldTicks > 0) {
                    this.breederReactor(player);
                }
                if (heldTicks % 100 == 0 && heldTicks > 0) {
                    this.addMasteryPoint(instance, entity);
                }
                if (heldTicks % 10 == 0) {
                    TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:wrath_boost"), entity.m_19879_(), 0.0, 1.0, 0.0, true));
                }
                player.m_6330_(SoundEvents.f_215771_, SoundSource.PLAYERS, 2.0f, 1.0f);
                return true;
            }
            case 2: {
                if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule(entity, instance)) {
                    return false;
                }
                Level level = entity.m_9236_();
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_215777_, SoundSource.PLAYERS, 10.0f, 1.0f);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123792_, 2.0);
                List list = level.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(7.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && !living.m_7307_((Entity)entity));
                if (!list.isEmpty()) {
                    if (heldTicks % 100 == 0 && heldTicks > 0) {
                        this.addMasteryPoint(instance, entity);
                    }
                    for (LivingEntity target : list) {
                        int duration;
                        if (SkillUtils.isSkillToggled((Entity)target, (ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_NULLIFICATION.get()) || SkillUtils.isSkillToggled((Entity)target, (ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_RESISTANCE.get()) && entity.m_217043_().m_188503_(3) != 1) continue;
                        int effectLevel = 0;
                        MobEffectInstance rampage = target.m_21124_((MobEffect)TensuraMobEffects.RAMPAGE.get());
                        if (rampage != null && heldTicks > 0) {
                            duration = rampage.m_19557_() + 2;
                            effectLevel = (duration - 400) / 200;
                        } else {
                            duration = 400;
                        }
                        target.m_147207_(new MobEffectInstance((MobEffect)TensuraMobEffects.RAMPAGE.get(), duration, effectLevel, false, false, false), (Entity)entity);
                        if (heldTicks % 10 != 0) continue;
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123792_, 2.0);
                    }
                }
                return true;
            }
        }
        return false;
    }

    private void breederReactor(Player player) {
        TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
            double rampageChance;
            double maxMP = player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
            double mpGain = maxMP * 0.02;
            cap.setMagicule(cap.getMagicule() + mpGain);
            double d = rampageChance = cap.getMagicule() > maxMP ? 0.05 : 0.01;
            if ((double)player.m_217043_().m_188501_() < rampageChance) {
                MobEffectInstance effectInstance = player.m_21124_((MobEffect)TensuraMobEffects.RAMPAGE.get());
                int level = 0;
                if (effectInstance != null) {
                    level = effectInstance.m_19564_() + 1;
                }
                SkillHelper.addEffectWithSource((LivingEntity)player, (LivingEntity)player, (MobEffect)TensuraMobEffects.RAMPAGE.get(), 600, level, false, false, false, true);
            }
        });
        TensuraPlayerCapability.sync(player);
    }

    public void onRespawn(ManasSkillInstance instance, PlayerEvent.PlayerRespawnEvent event) {
        if (event.isEndConquered()) {
            return;
        }
        if (instance.isToggled()) {
            instance.setToggled(false);
        }
    }
}

