/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.api.entity.ai;

import com.github.manasmods.tensura.api.entity.subclass.DynamicMeleeAttackAction;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;

public class DynamicMeleeAttackGoal
extends Goal {
    private final PathfinderMob pathfinderMob;
    private final List<DynamicMeleeAttackAction> actions;
    private int timeToRecalcPath;
    public boolean shouldMoveToTarget = true;
    private float defaultSpeed = 1.0f;

    public DynamicMeleeAttackGoal(PathfinderMob pathfinderMob, List<DynamicMeleeAttackAction> actions) {
        this.pathfinderMob = pathfinderMob;
        this.actions = actions;
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.defaultSpeed = this.pathfinderMob.m_6113_();
    }

    public void m_8041_() {
        this.timeToRecalcPath = 0;
        this.pathfinderMob.m_7910_(this.defaultSpeed);
    }

    public boolean m_8036_() {
        return this.pathfinderMob.m_5448_() != null && this.pathfinderMob.m_5448_().m_6084_();
    }

    public boolean m_8045_() {
        if (this.pathfinderMob.m_5448_() == null) {
            return false;
        }
        if (!this.pathfinderMob.m_5448_().m_6084_()) {
            return false;
        }
        if (!this.pathfinderMob.m_5448_().m_5789_()) {
            return false;
        }
        return this.pathfinderMob.m_5448_().m_20183_().m_123331_((Vec3i)this.pathfinderMob.m_20183_()) <= 1024.0;
    }

    protected List<DynamicMeleeAttackAction> getActions() {
        return this.actions;
    }

    protected boolean shouldMoveToTarget() {
        return this.shouldMoveToTarget;
    }

    public void m_8037_() {
        if (this.timeToRecalcPath-- > 0) {
            return;
        }
        this.timeToRecalcPath = this.m_183277_(10);
        LivingEntity target = this.pathfinderMob.m_5448_();
        if (target == null) {
            return;
        }
        float speed = this.getActions().stream().map(action -> Float.valueOf(action.execute((Mob)this.pathfinderMob, target, this))).max(Comparator.naturalOrder()).orElse(Float.valueOf(1.0f)).floatValue();
        if (!this.shouldMoveToTarget()) {
            return;
        }
        this.moveTo(target, speed);
    }

    protected void moveTo(LivingEntity target, double speed) {
        this.pathfinderMob.m_21573_().m_5624_((Entity)target, speed);
    }
}

