/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.api.entity.ai;

import com.github.manasmods.tensura.api.entity.subclass.ISemiAquatic;
import com.github.manasmods.tensura.entity.LandfishEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;

public class FindWaterGoal
extends Goal {
    private final PathfinderMob mob;
    private BlockPos targetPos;

    public FindWaterGoal(PathfinderMob mob) {
        this.mob = mob;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        ISemiAquatic semiAquatic;
        if (!this.mob.m_20096_()) {
            return false;
        }
        if (this.mob.f_19853_.m_6425_(this.mob.m_20183_()).m_205070_(FluidTags.f_13131_)) {
            return false;
        }
        PathfinderMob pathfinderMob = this.mob;
        if (pathfinderMob instanceof ISemiAquatic && (semiAquatic = (ISemiAquatic)pathfinderMob).shouldEnterWater() && (this.mob.m_5448_() != null || this.mob.m_217043_().m_188503_(30) == 0)) {
            this.targetPos = this.generateTarget();
            return this.targetPos != null;
        }
        return false;
    }

    public void m_8056_() {
        if (this.targetPos != null) {
            LandfishEntity landfishEntity;
            double speed = 1.2;
            PathfinderMob pathfinderMob = this.mob;
            if (pathfinderMob instanceof LandfishEntity && (landfishEntity = (LandfishEntity)pathfinderMob).getMoistnessLevel() <= 300) {
                speed = 2.0;
            }
            this.mob.m_21573_().m_26519_((double)this.targetPos.m_123341_(), (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_(), speed);
        }
    }

    public void m_8037_() {
        LandfishEntity landfishEntity;
        if (this.targetPos == null) {
            return;
        }
        double speed = 1.2;
        PathfinderMob pathfinderMob = this.mob;
        if (pathfinderMob instanceof LandfishEntity && (landfishEntity = (LandfishEntity)pathfinderMob).getMoistnessLevel() <= 300) {
            speed = 2.0;
        }
        this.mob.m_21573_().m_26519_((double)this.targetPos.m_123341_(), (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_(), speed);
    }

    public boolean m_8045_() {
        ISemiAquatic semiAquatic;
        PathfinderMob pathfinderMob = this.mob;
        if (pathfinderMob instanceof ISemiAquatic && !(semiAquatic = (ISemiAquatic)pathfinderMob).shouldEnterWater()) {
            this.mob.m_21573_().m_26573_();
            return false;
        }
        return !this.mob.m_21573_().m_26571_() && this.targetPos != null && !this.mob.f_19853_.m_6425_(this.mob.m_20183_()).m_205070_(FluidTags.f_13131_);
    }

    public BlockPos generateTarget() {
        BlockPos blockpos = null;
        RandomSource random = this.mob.m_217043_();
        int range = this.mob instanceof ISemiAquatic ? ((ISemiAquatic)this.mob).getWaterSearchRange() : 14;
        for (int i = 0; i < 15; ++i) {
            BlockPos blockPos = this.mob.m_20183_().m_7918_(random.m_188503_(range) - range / 2, 3, random.m_188503_(range) - range / 2);
            while (this.mob.f_19853_.m_46859_(blockPos) && blockPos.m_123342_() > 1) {
                blockPos = blockPos.m_7495_();
            }
            if (!this.mob.f_19853_.m_6425_(blockPos).m_205070_(FluidTags.f_13131_)) continue;
            blockpos = blockPos;
        }
        return blockpos;
    }
}

