/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.api.entity.ai;

import com.github.manasmods.tensura.api.entity.subclass.ISemiAquatic;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.phys.Vec3;

public class SemiAquaticRandomSwimmingGoal
extends RandomStrollGoal {
    public SemiAquaticRandomSwimmingGoal(Animal creature, double speed, int chance) {
        super((PathfinderMob)creature, speed, chance, false);
    }

    public boolean m_8036_() {
        if (this.f_25725_.m_20160_() || ((ISemiAquatic)this.f_25725_).shouldStopMoving() || this.f_25725_.m_5448_() != null || !this.f_25725_.m_20069_() && !this.f_25725_.m_20077_() && !((ISemiAquatic)this.f_25725_).shouldEnterWater()) {
            return false;
        }
        if (!this.f_25731_ && this.f_25725_.m_217043_().m_188503_(this.f_25730_) != 0) {
            return false;
        }
        Vec3 vector3d = this.m_7037_();
        if (vector3d == null) {
            return false;
        }
        this.f_25726_ = vector3d.f_82479_;
        this.f_25727_ = vector3d.f_82480_;
        this.f_25728_ = vector3d.f_82481_;
        this.f_25731_ = false;
        return true;
    }

    @Nullable
    protected Vec3 m_7037_() {
        Vec3 vector3d;
        PathfinderMob pathfinderMob = this.f_25725_;
        if (pathfinderMob instanceof TensuraTamableEntity) {
            TensuraTamableEntity entity = (TensuraTamableEntity)pathfinderMob;
            Vec3 pos = Vec3.m_82512_((Vec3i)entity.getWanderPos());
            double distance = (Double)TensuraConfig.INSTANCE.entitiesConfig.tamedWanderRadius.get();
            if (entity.isWandering() && entity.m_20238_(pos) >= distance * distance) {
                return pos;
            }
        }
        if (this.f_25725_.m_21536_() && this.f_25725_.m_20238_(Vec3.m_82512_((Vec3i)this.f_25725_.m_21534_())) > (double)(this.f_25725_.m_21535_() * this.f_25725_.m_21535_())) {
            return DefaultRandomPos.m_148412_((PathfinderMob)this.f_25725_, (int)7, (int)3, (Vec3)Vec3.m_82539_((Vec3i)this.f_25725_.m_21534_()), (double)1.0);
        }
        if (this.f_25725_.m_217043_().m_188501_() < 0.3f && (vector3d = this.findSurfaceTarget(this.f_25725_)) != null) {
            return vector3d;
        }
        return DefaultRandomPos.m_148403_((PathfinderMob)this.f_25725_, (int)7, (int)3);
    }

    private boolean canJumpTo(BlockPos pos) {
        return this.f_25725_.f_19853_.m_6425_(pos).m_205070_(FluidTags.f_13132_) || this.f_25725_.f_19853_.m_6425_(pos).m_205070_(FluidTags.f_13131_) && !this.f_25725_.f_19853_.m_8055_(pos).m_60767_().m_76334_();
    }

    private boolean isAirAbove(BlockPos pos) {
        return this.f_25725_.f_19853_.m_8055_(pos.m_7494_()).m_60795_() && this.f_25725_.f_19853_.m_8055_(pos.m_6630_(2)).m_60795_();
    }

    protected Vec3 findSurfaceTarget(PathfinderMob creature) {
        BlockPos upPos = creature.m_20183_();
        while (creature.f_19853_.m_6425_(upPos).m_205070_(FluidTags.f_13131_) || creature.f_19853_.m_6425_(upPos).m_205070_(FluidTags.f_13132_)) {
            upPos = upPos.m_7494_();
        }
        if (this.isAirAbove(upPos.m_7495_()) && this.canJumpTo(upPos.m_7495_())) {
            return new Vec3((double)((float)upPos.m_123341_() + 0.5f), (double)((float)upPos.m_123342_() - 1.0f), (double)((float)upPos.m_123343_() + 0.5f));
        }
        return null;
    }
}

