/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.api.entity.subclass;

import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.event.NamingEvent;
import com.github.manasmods.tensura.registry.items.TensuraMobDropItems;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeMod;

public interface IRanking {
    default public boolean canBeNamed() {
        return true;
    }

    default public void onNamed(NamingEvent event) {
    }

    default public int getMaxEvolutionState() {
        return 1;
    }

    default public int getCurrentEvolutionState() {
        return 0;
    }

    default public void setCurrentEvolutionState(int state) {
    }

    default public void evolve() {
        int current = this.getCurrentEvolutionState();
        if (current < this.getMaxEvolutionState()) {
            this.setCurrentEvolutionState(current + 1);
        }
    }

    default public void gainMaxHealth(LivingEntity entity, double amount) {
        AttributeInstance health = entity.m_21051_(Attributes.f_22276_);
        if (health != null) {
            health.m_22100_(health.m_22115_() + amount);
        }
        entity.m_5634_(entity.m_21233_());
    }

    default public void gainAttackDamage(LivingEntity entity, double amount) {
        AttributeInstance damage = entity.m_21051_(Attributes.f_22281_);
        if (damage != null) {
            damage.m_22100_(damage.m_22115_() + amount);
        }
    }

    default public void gainMovementSpeed(LivingEntity entity, double amount) {
        AttributeInstance speed = entity.m_21051_(Attributes.f_22279_);
        if (speed != null) {
            speed.m_22100_(speed.m_22115_() + amount);
        }
    }

    default public void gainSwimSpeed(LivingEntity entity, double amount) {
        AttributeInstance swimSpeed = entity.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get());
        if (swimSpeed != null) {
            swimSpeed.m_22100_(swimSpeed.m_22115_() + amount);
        }
    }

    default public void gainJumpStrength(LivingEntity entity, double amount) {
        AttributeInstance jump = entity.m_21051_(Attributes.f_22288_);
        if (jump != null) {
            jump.m_22100_(jump.m_22115_() + amount);
        }
    }

    public static void dropMagicCrystal(LivingEntity living) {
        Mob mob;
        if (living instanceof Mob && (mob = (Mob)living).getSpawnType() == MobSpawnType.MOB_SUMMONED) {
            return;
        }
        if (living instanceof Player) {
            return;
        }
        double EP = TensuraEPCapability.getEP(living);
        if (EP >= 9000.0) {
            living.m_19998_((ItemLike)TensuraMobDropItems.HIGH_QUALITY_MAGIC_CRYSTAL.get());
        } else if (EP >= 3000.0) {
            living.m_19998_((ItemLike)TensuraMobDropItems.MEDIUM_QUALITY_MAGIC_CRYSTAL.get());
        } else {
            living.m_19998_((ItemLike)TensuraMobDropItems.LOW_QUALITY_MAGIC_CRYSTAL.get());
        }
    }
}

