/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.block;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.block.entity.CharybdisCoreBlockEntity;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.entity.projectile.PrimedCharybdisCoreEntity;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import java.util.List;
import java.util.Objects;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SculkSensorPhase;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CharybdisCoreBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final EnumProperty<SculkSensorPhase> MODE = BlockStateProperties.f_155999_;

    public CharybdisCoreBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76286_, (MaterialColor)MaterialColor.f_76364_).m_60978_(0.5f).m_60953_(CharybdisCoreBlock.getLightEmission()).m_60918_(SoundType.f_56713_).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_(MODE, (Comparable)SculkSensorPhase.INACTIVE));
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
        CompoundTag stateTag = pStack.m_41737_("BlockStateTag");
        if (stateTag == null) {
            return;
        }
        if (!stateTag.m_128441_("sculk_sensor_phase")) {
            return;
        }
        if (stateTag.m_128461_("sculk_sensor_phase").equals("inactive")) {
            pTooltip.add((Component)Component.m_237115_((String)"tooltip.tensura.charybdis_core.inactive").m_130940_(ChatFormatting.RED));
            CompoundTag compoundtag = BlockItem.m_186336_((ItemStack)pStack);
            if (compoundtag == null) {
                return;
            }
            double EP = compoundtag.m_128459_("EP");
            if (EP > 0.0) {
                pTooltip.add((Component)Component.m_237115_((String)"tensura.attribute.existence_points.shortened_name").m_130946_(": " + EP).m_130940_(ChatFormatting.GOLD));
            }
        } else if (stateTag.m_128461_("sculk_sensor_phase").equals("active")) {
            pTooltip.add((Component)Component.m_237115_((String)"tooltip.tensura.charybdis_core.active").m_130940_(ChatFormatting.GOLD));
        } else if (stateTag.m_128461_("sculk_sensor_phase").equals("cooldown")) {
            pTooltip.add((Component)Component.m_237115_((String)"tooltip.tensura.charybdis_core.inert").m_130940_(ChatFormatting.DARK_GREEN));
        }
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public static ToIntFunction<BlockState> getLightEmission() {
        return state -> switch ((SculkSensorPhase)state.m_61143_(MODE)) {
            case SculkSensorPhase.COOLDOWN -> 8;
            case SculkSensorPhase.INACTIVE -> 3;
            default -> 12;
        };
    }

    public PushReaction m_5537_(BlockState pState) {
        return PushReaction.BLOCK;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{MODE});
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        Direction direction = pContext.m_43719_();
        return (BlockState)super.m_5573_(pContext).m_61124_((Property)FACING, (Comparable)direction);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((Direction)pState.m_61143_((Property)FACING)) {
            case Direction.NORTH -> Block.m_49796_((double)3.0, (double)3.5, (double)7.2, (double)13.0, (double)12.5, (double)16.2);
            case Direction.SOUTH -> Block.m_49796_((double)3.0, (double)3.5, (double)0.0, (double)13.0, (double)12.5, (double)8.8);
            case Direction.WEST -> Block.m_49796_((double)7.2, (double)3.5, (double)3.0, (double)16.2, (double)12.5, (double)13.0);
            case Direction.EAST -> Block.m_49796_((double)0.2, (double)3.5, (double)3.0, (double)8.8, (double)12.5, (double)13.0);
            case Direction.DOWN -> Block.m_49796_((double)3.0, (double)7.0, (double)3.0, (double)12.0, (double)16.0, (double)13.0);
            default -> Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)12.0, (double)9.0, (double)13.0);
        };
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new CharybdisCoreBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> GameEventListener m_214009_(ServerLevel pLevel, T pBlockEntity) {
        CharybdisCoreBlockEntity blockEntity;
        return pBlockEntity instanceof CharybdisCoreBlockEntity ? (blockEntity = (CharybdisCoreBlockEntity)pBlockEntity) : null;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.m_5776_()) {
            return InteractionResult.PASS;
        }
        if (pPlayer.m_6047_() && pPlayer.m_21120_(pHand).m_41619_() && pLevel instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)pLevel;
            List drops = Block.m_49869_((BlockState)pState, (ServerLevel)level, (BlockPos)pPos, (BlockEntity)pLevel.m_7702_(pPos));
            if (drops.size() == 1) {
                pPlayer.m_21008_(pHand, (ItemStack)drops.get(0));
            } else {
                for (ItemStack stack : drops) {
                    pPlayer.m_36356_(stack);
                }
            }
            pLevel.m_46961_(pPos, false);
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        switch ((SculkSensorPhase)pState.m_61143_(MODE)) {
            case ACTIVE: {
                PrimedCharybdisCoreEntity core = new PrimedCharybdisCoreEntity(pLevel, (double)pPos.m_123341_() + 0.5, pPos.m_123342_(), (double)pPos.m_123343_() + 0.5);
                pLevel.m_7967_((Entity)core);
                TensuraParticleHelper.addServerParticlesAroundSelf(core, (ParticleOptions)ParticleTypes.f_235898_);
                TensuraParticleHelper.addServerParticlesAroundSelf(core, (ParticleOptions)TensuraParticles.SOUL.get());
                pLevel.m_6263_(null, core.m_20185_(), core.m_20186_(), core.m_20189_(), SoundEvents.f_12563_, SoundSource.BLOCKS, 1.0f, 1.0f);
                pLevel.m_7471_(pPos, false);
                return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
            }
            case COOLDOWN: {
                List<ManasSkill> list = ((List)TensuraConfig.INSTANCE.blocksConfig.inertCoreSkills.get()).stream().map(skill -> (ManasSkill)SkillAPI.getSkillRegistry().getValue(new ResourceLocation(skill))).filter(Objects::nonNull).toList();
                if (!list.isEmpty()) {
                    for (ManasSkill skill2 : list) {
                        if (!SkillUtils.learnSkill((LivingEntity)pPlayer, skill2)) continue;
                        pPlayer.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{skill2.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                    }
                }
                pLevel.m_46961_(pPos, false);
                pLevel.m_6263_(null, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), SoundEvents.f_11887_, SoundSource.BLOCKS, 1.0f, 1.0f);
                TensuraParticleHelper.addServerParticlesAroundPos(pLevel.m_213780_(), pLevel, Vec3.m_82512_((Vec3i)pPos), (ParticleOptions)ParticleTypes.f_235898_, 1.0);
                TensuraParticleHelper.addServerParticlesAroundPos(pLevel.m_213780_(), pLevel, Vec3.m_82512_((Vec3i)pPos), (ParticleOptions)ParticleTypes.f_123746_, 1.0);
                TensuraParticleHelper.addServerParticlesAroundPos(pLevel.m_213780_(), pLevel, Vec3.m_82512_((Vec3i)pPos), (ParticleOptions)TensuraParticles.SOUL.get(), 1.0);
                return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }
}

