/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.block;

import com.github.manasmods.tensura.registry.dimensions.TensuraDimensions;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class HipokuteGrass
extends BushBlock {
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public HipokuteGrass(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public boolean m_6724_(BlockState pState) {
        return super.m_6724_(pState) && (Integer)pState.m_61143_((Property)AGE) < 2;
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!pLevel.isAreaLoaded(pPos, 1)) {
            return;
        }
        int i = this.getAge(pState);
        if (i >= 2) {
            return;
        }
        float f = this.getGrowthSpeed((Block)this, (BlockGetter)pLevel, pPos);
        if (!ForgeHooks.onCropsGrowPre((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (pRandom.m_188503_((int)(25.0f / f) + 1) == 0 ? 1 : 0) != 0)) {
            return;
        }
        if (i == 0) {
            int bound;
            int n = bound = pLevel.m_46472_() == TensuraDimensions.HELL ? 4 : 10;
            if (pRandom.m_188503_(bound) == bound - 1) {
                pLevel.m_7731_(pPos, this.getStateForAge(1), 2);
            } else {
                BlockState newState = (BlockState)Blocks.f_50092_.m_49966_().m_61124_((Property)BlockStateProperties.f_61409_, (Comparable)Integer.valueOf(3));
                pLevel.m_7731_(pPos, newState, 2);
                BlockState belowState = pLevel.m_8055_(pPos.m_7495_());
                if (!super.m_6266_(belowState, (BlockGetter)pLevel, pPos.m_7495_())) {
                    pLevel.m_46961_(pPos, true);
                }
            }
        } else {
            int nextAge = pRandom.m_188499_() ? i + 1 : 3;
            pLevel.m_7731_(pPos, this.getStateForAge(nextAge), 2);
        }
        ForgeHooks.onCropsGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (!pLevel.m_5776_() && this.getAge(pState) == this.getMaxAge()) {
            HipokuteGrass.m_49840_((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)TensuraMaterialItems.HIPOKUTE_FLOWER.get()));
            pLevel.m_5594_(null, pPos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + pLevel.f_46441_.m_188501_() * 0.4f);
            BlockState blockState = (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(1));
            pLevel.m_7731_(pPos, blockState, 2);
            pLevel.m_220407_(GameEvent.f_157792_, pPos, GameEvent.Context.m_223719_((Entity)pPlayer, (BlockState)blockState));
            return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        super.m_5707_(pLevel, pPos, pState, pPlayer);
        if (pPlayer.m_150110_().f_35937_) {
            return;
        }
        if (this.getAge(pState) != 3) {
            return;
        }
        HipokuteGrass.m_49840_((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)TensuraMaterialItems.HIPOKUTE_FLOWER.get()));
    }

    public float getGrowthSpeed(Block pBlock, BlockGetter pLevel, BlockPos pPos) {
        boolean flag;
        float f = 1.0f;
        BlockPos blockpos = pPos.m_7495_();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                BlockState blockstate = pLevel.m_8055_(blockpos.m_7918_(i, 0, j));
                if (blockstate.canSustainPlant(pLevel, blockpos.m_7918_(i, 0, j), Direction.UP, (IPlantable)pBlock)) {
                    f1 = 1.0f;
                    if (blockstate.isFertile(pLevel, pPos.m_7918_(i, 0, j))) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = pPos.m_122012_();
        BlockPos blockpos2 = pPos.m_122019_();
        BlockPos blockpos3 = pPos.m_122024_();
        BlockPos blockpos4 = pPos.m_122029_();
        boolean bl = flag = !(!pLevel.m_8055_(blockpos3).m_60713_(pBlock) && !pLevel.m_8055_(blockpos4).m_60713_(pBlock) || !pLevel.m_8055_(blockpos1).m_60713_(pBlock) && !pLevel.m_8055_(blockpos2).m_60713_(pBlock));
        if (flag) {
            return f / 2.0f;
        }
        boolean bl2 = flag = pLevel.m_8055_(blockpos3.m_122012_()).m_60713_(pBlock) || pLevel.m_8055_(blockpos4.m_122012_()).m_60713_(pBlock) || pLevel.m_8055_(blockpos4.m_122019_()).m_60713_(pBlock) || pLevel.m_8055_(blockpos3.m_122019_()).m_60713_(pBlock);
        if (flag) {
            return f / 2.0f;
        }
        return f;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_AGE[(Integer)pState.m_61143_((Property)AGE)];
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 3;
    }

    protected int getAge(BlockState pState) {
        return (Integer)pState.m_61143_((Property)AGE);
    }

    public BlockState getStateForAge(int pAge) {
        return (BlockState)this.m_49966_().m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(pAge > 2 ? 3 : pAge));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{AGE});
    }

    protected boolean m_6266_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return pState.m_60713_(Blocks.f_50440_) || pState.m_60713_(Blocks.f_50093_) || pState.m_60713_(Blocks.f_50493_);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState belowState = level.m_8055_(pos.m_7495_());
        return belowState.m_60713_(Blocks.f_50440_) || belowState.m_60713_(Blocks.f_50093_) || belowState.m_60713_(Blocks.f_50493_);
    }

    public PlantType getPlantType(BlockGetter level, BlockPos pos) {
        return PlantType.CROP;
    }
}

