/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.block;

import com.github.manasmods.tensura.block.SimpleBlock;
import com.github.manasmods.tensura.block.SimpleLeaves;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.client.TensuraGUIHelper;
import com.github.manasmods.tensura.entity.ElementalColossusEntity;
import com.github.manasmods.tensura.registry.blocks.TensuraBlocks;
import com.github.manasmods.tensura.world.savedata.LabyrinthSaveData;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LabyrinthBarrierBlock
extends SimpleBlock {
    public static final BooleanProperty BLOCK_MOTION = BlockStateProperties.f_61431_;

    public LabyrinthBarrierBlock() {
        super(new Material.Builder(MaterialColor.f_76398_).m_76359_(), properties -> properties.m_60960_(SimpleLeaves::never).m_60971_((blockState, blockGetter, blockPos) -> false).m_60922_((blockState, blockGetter, blockPos, entityType) -> false).m_222994_().m_60988_().m_60955_().m_60918_(SoundType.f_154654_).m_60913_(-1.0f, 3600000.0f));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BLOCK_MOTION, (Comparable)Boolean.FALSE));
    }

    public VoxelShape m_7952_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return Shapes.m_83040_();
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.INVISIBLE;
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pos, RandomSource pRandom) {
        TensuraGUIHelper.spawnMarkerParticle(pLevel, pState, pos, (Item)TensuraBlocks.Items.LABYRINTH_BARRIER_BLOCK.get());
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Entity entity;
        if (pContext instanceof EntityCollisionContext) {
            EntityCollisionContext entityCollision = (EntityCollisionContext)pContext;
            v0 = entityCollision.m_193113_();
        } else {
            v0 = entity = null;
        }
        if (entity instanceof Projectile) {
            return Shapes.m_83144_();
        }
        if (this.canGoThrough(pState, entity)) {
            return Shapes.m_83040_();
        }
        return Shapes.m_83144_();
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity target) {
        if (this.canGoThrough(pState, target)) {
            return;
        }
        if (!(pLevel instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)pLevel;
        LabyrinthSaveData saveData = LabyrinthSaveData.get(serverLevel.m_7654_().m_129783_());
        Vec3 throwVec = saveData.getColossusPos().m_82546_(target.m_20182_()).m_82541_().m_82490_(1.5);
        target.m_20334_(throwVec.m_7096_(), 0.0, throwVec.m_7094_());
        if (target instanceof ElementalColossusEntity) {
            ElementalColossusEntity colossus = (ElementalColossusEntity)target;
            colossus.m_21661_();
        }
        target.f_19864_ = true;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (!pPlayer.m_7500_() || !pPlayer.m_21120_(pHand).m_41619_()) {
            return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
        }
        pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)BLOCK_MOTION, (Comparable)Boolean.valueOf((Boolean)pState.m_61143_((Property)BLOCK_MOTION) == false)));
        return InteractionResult.SUCCESS;
    }

    public boolean m_180643_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return true;
    }

    public boolean m_5946_(BlockState pState, Fluid pFluid) {
        return false;
    }

    public boolean m_6864_(BlockState pState, BlockPlaceContext pUseContext) {
        return false;
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return true;
    }

    public boolean collisionExtendsVertically(BlockState state, BlockGetter level, BlockPos pos, Entity collidingEntity) {
        return true;
    }

    protected void m_142387_(Level pLevel, Player pPlayer, BlockPos pPos, BlockState pState) {
    }

    public boolean m_7420_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{BLOCK_MOTION});
    }

    public PushReaction m_5537_(BlockState pState) {
        return PushReaction.IGNORE;
    }

    private boolean canGoThrough(BlockState pState, @Nullable Entity entity) {
        ElementalColossusEntity colossus;
        if (entity == null) {
            return true;
        }
        if (entity instanceof ElementalColossusEntity && !(colossus = (ElementalColossusEntity)entity).m_21824_()) {
            return false;
        }
        if (this.isColossusStartedBlocking(entity)) {
            return false;
        }
        if (((Boolean)pState.m_61143_((Property)BLOCK_MOTION)).booleanValue()) {
            if (this.isColossusWonButEmpty(entity)) {
                return true;
            }
            return LabyrinthSaveData.isEntityPassedColossus(entity);
        }
        return true;
    }

    private boolean isColossusStartedBlocking(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity living = (LivingEntity)entity;
        if (entity.f_19853_.m_7654_() != null && !LabyrinthSaveData.get(entity.f_19853_.m_7654_().m_129783_()).isHavingColossus() && TensuraEffectsCapability.isColossusStarted(living)) {
            LabyrinthSaveData.removeStartedEntity(living);
            return false;
        }
        return TensuraEffectsCapability.isColossusStarted(living);
    }

    private boolean isColossusWonButEmpty(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity living = (LivingEntity)entity;
        if (entity.f_19853_.m_7654_() != null && !LabyrinthSaveData.get(entity.f_19853_.m_7654_().m_129783_()).isHavingColossus() && TensuraEffectsCapability.isColossusWon(living)) {
            return true;
        }
        return TensuraEffectsCapability.isColossusWon(living);
    }
}

