/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.block;

import com.github.manasmods.tensura.block.SimpleBlock;
import com.github.manasmods.tensura.block.entity.MagicEngineBlockEntity;
import com.github.manasmods.tensura.registry.blocks.TensuraBlockEntities;
import com.github.manasmods.tensura.util.TensuraAdvancementsHelper;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MagicEngineBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty ENABLED = BlockStateProperties.f_61431_;

    public MagicEngineBlock(Material material, SimpleBlock.BlockProperties properties) {
        super(properties.create(BlockBehaviour.Properties.m_60939_((Material)material)).m_60953_(MagicEngineBlock.getLightEmission()));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)ENABLED, (Comparable)Boolean.FALSE));
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((Direction)pState.m_61143_((Property)FACING)) {
            default -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)17.0, (double)16.0);
            case Direction.DOWN -> Block.m_49796_((double)0.0, (double)-1.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
            case Direction.EAST -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)17.0, (double)16.0, (double)16.0);
            case Direction.WEST -> Block.m_49796_((double)-1.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
            case Direction.SOUTH -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)17.0);
            case Direction.NORTH -> Block.m_49796_((double)0.0, (double)0.0, (double)-1.0, (double)16.0, (double)16.0, (double)16.0);
        };
    }

    public static ToIntFunction<BlockState> getLightEmission() {
        return state -> (Boolean)state.m_61143_((Property)ENABLED) != false ? 15 : 0;
    }

    public boolean m_7899_(BlockState pState) {
        return true;
    }

    public int m_6378_(BlockState pState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        if (((Boolean)pState.m_61143_((Property)ENABLED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public PushReaction m_5537_(BlockState pState) {
        if (((Boolean)pState.m_61143_((Property)ENABLED)).booleanValue()) {
            return PushReaction.BLOCK;
        }
        return PushReaction.NORMAL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{ENABLED});
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        Direction direction = pContext.m_43719_();
        return (BlockState)super.m_5573_(pContext).m_61124_((Property)FACING, (Comparable)direction);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new MagicEngineBlockEntity(pPos, pState);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        state = (BlockState)state.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)ENABLED) == false));
        level.m_7731_(pPos, state, 3);
        if (((Boolean)state.m_61143_((Property)ENABLED)).booleanValue() && pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            TensuraAdvancementsHelper.grant(serverPlayer, TensuraAdvancementsHelper.Advancements.NO_NO_SQUARE);
        }
        float f = (Boolean)state.m_61143_((Property)ENABLED) != false ? 0.6f : 0.5f;
        level.m_5594_(null, pPos, (Boolean)state.m_61143_((Property)ENABLED) != false ? SoundEvents.f_11736_ : SoundEvents.f_11738_, SoundSource.BLOCKS, 1.0f, f);
        level.m_142346_((Entity)pPlayer, (Boolean)state.m_61143_((Property)ENABLED) != false ? GameEvent.f_223702_ : GameEvent.f_223703_, pPos);
        return InteractionResult.CONSUME;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> type) {
        return MagicEngineBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)TensuraBlockEntities.MAGIC_ENGINE.get()), MagicEngineBlockEntity::tick);
    }
}

