/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.block;

import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.registry.blocks.TensuraBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SlimeChunkBlock
extends Block {
    private static final VoxelShape FALLING_COLLISION_SHAPE = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.9f, (double)1.0);

    public SlimeChunkBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public boolean m_6104_(BlockState pState, BlockState pAdjacentBlockState, Direction pDirection) {
        return pAdjacentBlockState.m_60713_((Block)this) || pAdjacentBlockState.m_60713_((Block)TensuraBlocks.CHILLED_SLIME_BLOCK.get());
    }

    public VoxelShape m_7952_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return Shapes.m_83040_();
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (pEntity.m_6095_().m_204039_(TensuraTags.EntityTypes.SLIME_WALKABLE_MOBS)) {
            return;
        }
        if (!(pEntity instanceof LivingEntity) || pEntity.m_146900_().m_60713_((Block)this)) {
            pEntity.m_7601_(pState, new Vec3((double)0.7f, 0.7, (double)0.7f));
        }
    }

    public void m_142072_(Level pLevel, BlockState pState, BlockPos pPos, Entity pEntity, float pFallDistance) {
        if (pFallDistance < 4.0f) {
            return;
        }
        pEntity.m_5496_(SoundEvents.f_12390_, 1.0f, 1.0f);
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pContext instanceof EntityCollisionContext) {
            EntityCollisionContext entitycollisioncontext = (EntityCollisionContext)pContext;
            Entity entity = entitycollisioncontext.m_193113_();
            if (entity == null) {
                return Shapes.m_83040_();
            }
            if (entity.f_19789_ > 2.5f) {
                return FALLING_COLLISION_SHAPE;
            }
        }
        return Shapes.m_83040_();
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return true;
    }

    public boolean isStickyBlock(BlockState state) {
        return true;
    }

    public boolean canStickTo(BlockState state, BlockState other) {
        if (other.m_60734_() == Blocks.f_50374_) {
            return false;
        }
        if (other.m_60734_() == Blocks.f_50719_) {
            return false;
        }
        return state.isStickyBlock() || other.isStickyBlock();
    }
}

