/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.block;

import com.github.manasmods.tensura.block.AllSidesDirectionalBlock;
import com.github.manasmods.tensura.entity.BlackSpiderEntity;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class SpiderEggBlock
extends AllSidesDirectionalBlock {
    public static final IntegerProperty HATCH = BlockStateProperties.f_61416_;

    public SpiderEggBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76286_, (MaterialColor)MaterialColor.f_76385_).m_60978_(0.5f).m_60953_(blockState -> 3).m_60956_(0.8f).m_60967_(0.9f).m_60918_(SoundType.f_56713_).m_60977_().m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HATCH, (Comparable)Integer.valueOf(0))).m_61124_((Property)f_52588_, (Comparable)Direction.UP));
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (this.shouldUpdateHatchLevel((Level)pLevel)) {
            int i = (Integer)pState.m_61143_((Property)HATCH);
            if (i < 2) {
                pLevel.m_5594_(null, pPos, SoundEvents.f_12534_, SoundSource.BLOCKS, 0.7f, 0.9f + pRandom.m_188501_() * 0.2f);
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)HATCH, (Comparable)Integer.valueOf(i + 1)), 2);
            } else {
                pLevel.m_5594_(null, pPos, SoundEvents.f_12535_, SoundSource.BLOCKS, 0.7f, 0.9f + pRandom.m_188501_() * 0.2f);
                pLevel.m_7471_(pPos, false);
                pLevel.m_46796_(2001, pPos, Block.m_49956_((BlockState)pState));
                BlackSpiderEntity spider = (BlackSpiderEntity)((EntityType)TensuraEntityTypes.BLACK_SPIDER.get()).m_20615_((Level)pLevel);
                if (spider == null) {
                    return;
                }
                spider.m_146762_(-24000);
                spider.m_7678_((double)pPos.m_123341_() + 0.3, pPos.m_123342_(), (double)pPos.m_123343_() + 0.3, 0.0f, 0.0f);
                pLevel.m_7967_((Entity)spider);
            }
        }
    }

    public static boolean canLayEgg(BlockGetter pLevel, BlockPos pPos) {
        return pLevel.m_8055_(pPos).m_60783_(pLevel, pPos, Direction.UP);
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pLevel.f_46443_) {
            pLevel.m_46796_(2005, pPos, 0);
        }
    }

    public void m_6240_(Level pLevel, Player pPlayer, BlockPos pPos, BlockState pState, @Nullable BlockEntity pTe, ItemStack pStack) {
        super.m_6240_(pLevel, pPlayer, pPos, pState, pTe, pStack);
        if (pStack.getEnchantmentLevel(Enchantments.f_44985_) <= 0) {
            this.spawnHostileBaby(pLevel, pState, pPos, (Entity)pPlayer);
        }
    }

    public void m_7592_(Level pLevel, BlockPos pPos, Explosion pExplosion) {
        super.m_7592_(pLevel, pPos, pExplosion);
        this.spawnHostileBaby(pLevel, pLevel.m_8055_(pPos), pPos, pExplosion.getExploder());
    }

    public void m_141947_(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity) {
        if (pEntity.m_20161_()) {
            return;
        }
        if (pEntity instanceof BlackSpiderEntity) {
            return;
        }
        if ((Integer)pState.m_61143_((Property)HATCH) == 0) {
            return;
        }
        if (pEntity instanceof Player) {
            Player player = (Player)pEntity;
            if (player.m_150110_().f_35937_) {
                return;
            }
            BlockEvent.BreakEvent preGrief = new BlockEvent.BreakEvent(pLevel, pPos, pState, player);
            if (MinecraftForge.EVENT_BUS.post((Event)preGrief)) {
                return;
            }
        } else if (ForgeEventFactory.getMobGriefingEvent((Level)pLevel, (Entity)pEntity)) {
            return;
        }
        pLevel.m_46961_(pPos, false);
        this.spawnHostileBaby(pLevel, pState, pPos, pEntity);
    }

    public void m_142072_(Level pLevel, BlockState pState, BlockPos pPos, Entity pEntity, float pFallDistance) {
        if (pEntity instanceof BlackSpiderEntity) {
            return;
        }
        pEntity.m_142535_(pFallDistance, 0.3f, DamageSource.f_19315_);
        if (pEntity instanceof Player) {
            Player player = (Player)pEntity;
            if (player.m_150110_().f_35937_) {
                return;
            }
            BlockEvent.BreakEvent preGrief = new BlockEvent.BreakEvent(pLevel, pPos, pState, player);
            if (MinecraftForge.EVENT_BUS.post((Event)preGrief)) {
                return;
            }
        } else if (ForgeEventFactory.getMobGriefingEvent((Level)pLevel, (Entity)pEntity)) {
            return;
        }
        pLevel.m_46961_(pPos, false);
        this.spawnHostileBaby(pLevel, pState, pPos, pEntity);
    }

    private void spawnHostileBaby(Level pLevel, BlockState pState, BlockPos pPos, @Nullable Entity pEntity) {
        pLevel.m_46796_(2001, pPos, Block.m_49956_((BlockState)pState));
        if (pLevel instanceof ServerLevel) {
            LivingEntity living;
            ServerLevel serverLevel = (ServerLevel)pLevel;
            BlackSpiderEntity spider = (BlackSpiderEntity)((EntityType)TensuraEntityTypes.BLACK_SPIDER.get()).m_20615_(pLevel);
            if (spider == null) {
                return;
            }
            if (pEntity instanceof LivingEntity && spider.m_6779_(living = (LivingEntity)pEntity)) {
                spider.m_6710_(living);
            }
            spider.m_146762_(-24000);
            spider.m_7678_((double)pPos.m_123341_() + 0.3, pPos.m_123342_(), (double)pPos.m_123343_() + 0.3, 0.0f, 0.0f);
            spider.m_6518_((ServerLevelAccessor)serverLevel, pLevel.m_6436_(spider.m_20183_()), MobSpawnType.BREEDING, null, null);
            pLevel.m_7967_((Entity)spider);
        }
    }

    private boolean shouldUpdateHatchLevel(Level pLevel) {
        float f = pLevel.m_46942_(1.0f);
        if ((double)f < 0.69 && (double)f > 0.65) {
            return true;
        }
        return pLevel.f_46441_.m_188503_(300) == 0;
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        BlackSpiderEntity spider;
        Entity entity;
        if (pContext instanceof EntityCollisionContext) {
            EntityCollisionContext entityCollision = (EntityCollisionContext)pContext;
            v0 = entityCollision.m_193113_();
        } else {
            v0 = entity = null;
        }
        if (entity instanceof BlackSpiderEntity && !(spider = (BlackSpiderEntity)entity).m_6162_()) {
            return Shapes.m_83040_();
        }
        return super.m_5939_(pState, pLevel, pPos, pContext);
    }

    @Nullable
    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        BlackSpiderEntity spider;
        if (mob instanceof BlackSpiderEntity && !(spider = (BlackSpiderEntity)mob).m_6162_()) {
            return BlockPathTypes.OPEN;
        }
        return super.getBlockPathType(state, level, pos, mob);
    }

    public PushReaction m_5537_(BlockState pState) {
        return PushReaction.NORMAL;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{HATCH}).m_61104_(new Property[]{f_52588_});
    }
}

