/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.block.entity;

import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.block.CharybdisCoreBlock;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.registry.blocks.TensuraBlockEntities;
import com.github.manasmods.tensura.registry.event.TensuraGameEvents;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.SculkSensorPhase;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;

public class CharybdisCoreBlockEntity
extends BlockEntity
implements GameEventListener {
    private final BlockPositionSource blockPosSource;
    private double EP;

    public CharybdisCoreBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)TensuraBlockEntities.CHARYBDIS_CORE.get(), pPos, pBlockState);
        this.blockPosSource = new BlockPositionSource(this.f_58858_);
        this.EP = 0.0;
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128347_("EP", this.getEP());
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.setEP(pTag.m_128459_("EP"));
    }

    public boolean m_214054_() {
        return true;
    }

    public PositionSource m_142460_() {
        return this.blockPosSource;
    }

    public int m_142078_() {
        return 16;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public boolean m_214068_(ServerLevel pLevel, GameEvent.Message pEventMessage) {
        if (this.m_58901_()) {
            return false;
        }
        BlockPos pPos = this.f_58858_;
        BlockState state = pLevel.m_8055_(pPos);
        if (state.m_61143_(CharybdisCoreBlock.MODE) != SculkSensorPhase.INACTIVE) {
            return false;
        }
        GameEvent.Context context = pEventMessage.m_223744_();
        if (pEventMessage.m_223740_() != TensuraGameEvents.AFTER_CHEAT_DEATH.get()) {
            return false;
        }
        Entity entity = context.f_223711_();
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        TensuraEPCapability.getFrom(entity2).ifPresent(cap -> {
            if (cap.isSkipEPDrop()) {
                return;
            }
            cap.setSkipEPDrop(true);
            entity2.m_217045_();
            double EP = SkillUtils.getEPGain(entity2);
            if (EP > 0.0) {
                double maxEP = (Double)TensuraConfig.INSTANCE.blocksConfig.turnActiveCoreEP.get();
                this.setEP(Math.min(this.getEP() + EP, maxEP));
                this.m_6596_();
                TensuraParticleHelper.addServerParticlesAroundPos(pLevel.f_46441_, (Level)pLevel, Vec3.m_82512_((Vec3i)pPos), (ParticleOptions)ParticleTypes.f_235898_, 1.0);
                TensuraParticleHelper.addServerParticlesAroundPos(pLevel.f_46441_, (Level)pLevel, Vec3.m_82512_((Vec3i)pPos), (ParticleOptions)TensuraParticles.SOUL.get(), 1.0);
                if (this.getEP() >= maxEP) {
                    pLevel.m_46597_(pPos, (BlockState)state.m_61124_(CharybdisCoreBlock.MODE, (Comparable)SculkSensorPhase.ACTIVE));
                    pLevel.m_5594_(null, pPos, SoundEvents.f_12563_, SoundSource.BLOCKS, 2.0f, 0.6f + pLevel.m_213780_().m_188501_() * 0.4f);
                } else {
                    pLevel.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
                    pLevel.m_5594_(null, pPos, SoundEvents.f_215734_, SoundSource.BLOCKS, 2.0f, 0.6f + pLevel.m_213780_().m_188501_() * 0.4f);
                }
            }
        });
        return true;
    }

    public double getEP() {
        return this.EP;
    }

    public void setEP(double EP) {
        this.EP = EP;
    }
}

