/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.block.entity;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.blocks.TensuraBlockEntities;
import com.github.manasmods.tensura.registry.dimensions.TensuraDimensions;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.util.TensuraAdvancementsHelper;
import com.github.manasmods.tensura.world.savedata.LabyrinthSaveData;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class PrayingPathBlockEntity
extends BlockEntity {
    private final HashMap<String, Integer> prayingTime = new HashMap();

    public PrayingPathBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)TensuraBlockEntities.PRAYING_PATH.get(), pPos, pBlockState);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        for (String uuid : this.prayingTime.keySet()) {
            pTag.m_128405_(uuid, this.prayingTime.get(uuid).intValue());
        }
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.prayingTime.clear();
        for (String string : pTag.m_128431_()) {
            this.prayingTime.put(string, pTag.m_128451_(string));
        }
    }

    public Set<String> getPrayers() {
        return this.prayingTime.keySet();
    }

    public int getPrayingTick(String uuid) {
        if (this.prayingTime.containsKey(uuid)) {
            return this.prayingTime.get(uuid);
        }
        return 0;
    }

    public int getPrayingTick(Player player) {
        return this.getPrayingTick(player.m_20149_());
    }

    public void setPrayingTick(String uuid, int tick) {
        this.prayingTime.put(uuid, tick);
    }

    public void setPrayingTick(Player player, int tick) {
        this.setPrayingTick(player.m_20149_(), tick);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    @Nullable
    private static Pair<MagicElemental, SpiritualMagic.SpiritLevel> getRandomSpiritLevel(Player player) {
        Race race = TensuraPlayerCapability.getRace((LivingEntity)player);
        if (race == null) {
            return null;
        }
        float chance = player.m_217043_().m_188501_() * 100.0f;
        MagicElemental elemental = (MagicElemental)((Object)Util.m_214670_((Object[])MagicElemental.values(), (RandomSource)player.m_217043_()));
        int currentLevel = TensuraSkillCapability.getSpiritLevel(player, elemental.getId());
        if (race.hasGuaranteeElemental()) {
            block0: for (MagicElemental magicElemental : MagicElemental.values()) {
                for (SpiritualMagic.SpiritLevel spiritLevel : SpiritualMagic.SpiritLevel.values()) {
                    int currentSpiritLevel;
                    if (race.getElementalSpiritsChance(magicElemental, spiritLevel) != 100.0 || (currentSpiritLevel = TensuraSkillCapability.getSpiritLevel(player, magicElemental.getId())) >= spiritLevel.getId()) continue;
                    elemental = magicElemental;
                    currentLevel = currentSpiritLevel;
                    continue block0;
                }
            }
        }
        double lord = race.getElementalSpiritsChance(elemental, SpiritualMagic.SpiritLevel.LORD);
        double greater = lord + race.getElementalSpiritsChance(elemental, SpiritualMagic.SpiritLevel.GREATER);
        double medium = greater + race.getElementalSpiritsChance(elemental, SpiritualMagic.SpiritLevel.MEDIUM);
        double lesser = medium + race.getElementalSpiritsChance(elemental, SpiritualMagic.SpiritLevel.LESSER);
        if ((double)chance <= lord && currentLevel >= 2) {
            return Pair.of((Object)((Object)elemental), (Object)((Object)SpiritualMagic.SpiritLevel.LORD));
        }
        if ((double)chance <= greater) {
            return Pair.of((Object)((Object)elemental), (Object)((Object)SpiritualMagic.SpiritLevel.GREATER));
        }
        if ((double)chance <= medium) {
            return Pair.of((Object)((Object)elemental), (Object)((Object)SpiritualMagic.SpiritLevel.MEDIUM));
        }
        if ((double)chance <= lesser) {
            return Pair.of((Object)((Object)elemental), (Object)((Object)SpiritualMagic.SpiritLevel.LESSER));
        }
        return null;
    }

    private static void rollSpirits(Player player) {
        if (TensuraPlayerCapability.isBlessed(player)) {
            PrayingPathBlockEntity.spiritBlessing(player);
            return;
        }
        Pair<MagicElemental, SpiritualMagic.SpiritLevel> elemental = PrayingPathBlockEntity.getRandomSpiritLevel(player);
        if (elemental == null) {
            player.m_5661_((Component)Component.m_237115_((String)"tensura.magic.spiritual.chosen.failed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)player, (ParticleOptions)ParticleTypes.f_123792_, 1.0);
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return;
        }
        PrayingPathBlockEntity.grantSpirit(player, (MagicElemental)((Object)elemental.getFirst()), (SpiritualMagic.SpiritLevel)((Object)elemental.getSecond()));
    }

    private static void spiritBlessing(Player player) {
        MagicElemental excluded = player.m_217043_().m_188499_() ? MagicElemental.DARKNESS : MagicElemental.LIGHT;
        for (MagicElemental elemental : MagicElemental.values()) {
            if (elemental == excluded) continue;
            SpiritualMagic.SpiritLevel level = SpiritualMagic.SpiritLevel.GREATER;
            PrayingPathBlockEntity.grantSpirit(player, elemental, level);
        }
        TensuraPlayerCapability.getFrom(player).ifPresent(cap -> cap.setBlessed(false));
        TensuraPlayerCapability.sync(player);
    }

    private static void grantSpirit(Player player, MagicElemental elemental, SpiritualMagic.SpiritLevel level) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TensuraAdvancementsHelper.grant(serverPlayer, TensuraAdvancementsHelper.Advancements.ELEMENTALIST);
        }
        TensuraSkillCapability.getFrom(player).ifPresent(cap -> {
            int currentLevel = cap.getSpiritLevel(elemental.getId());
            if (level.getId() <= currentLevel) {
                player.m_5661_((Component)Component.m_237115_((String)"tensura.magic.spiritual.chosen.failed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)player, (ParticleOptions)ParticleTypes.f_123792_, 1.0);
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
                return;
            }
            if (cap.setSpiritLevel(player, elemental.getId(), level.getId())) {
                TensuraSkillCapability.sync(player);
                PrayingPathBlockEntity.grantSpiritMagic(player, elemental, level);
                PrayingPathBlockEntity.grantManipulation(player, elemental);
                player.m_5661_((Component)Component.m_237110_((String)"tensura.magic.spiritual.chosen", (Object[])new Object[]{level.getSpiritName(elemental)}).m_6270_(Style.f_131099_.m_131140_(elemental.getChatFormatting())), false);
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 1.0f);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)player, (ParticleOptions)ParticleTypes.f_123767_, 1.0);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)player, (ParticleOptions)ParticleTypes.f_123767_, 2.0);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)player, (ParticleOptions)ParticleTypes.f_123747_, 1.0);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)player, (ParticleOptions)ParticleTypes.f_123810_, 2.0);
                player.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 100, 9, false, false, false));
            }
        });
    }

    public static void grantSpiritMagic(Player player, MagicElemental elemental, SpiritualMagic.SpiritLevel level) {
        for (ManasSkill manasSkill : SkillAPI.getSkillRegistry().getValues()) {
            SpiritualMagic skill;
            if (!(manasSkill instanceof SpiritualMagic) || (skill = (SpiritualMagic)manasSkill).getElemental() != elemental || skill.getLevel().getId() > level.getId() || !SkillUtils.learnSkill((LivingEntity)player, skill)) continue;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
        }
    }

    public static void grantManipulation(Player player, MagicElemental elemental) {
        ManasSkill manipulation = elemental.getManipulation();
        if (manipulation == null) {
            return;
        }
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
        TensuraSkillInstance manipulationInstance = new TensuraSkillInstance(manipulation);
        manipulationInstance.setMastery(-100);
        if (storage.learnSkill((ManasSkillInstance)manipulationInstance)) {
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_available", (Object[])new Object[]{manipulation.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), false);
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PrayingPathBlockEntity pEntity) {
        int prayingTick;
        if (level.m_5776_()) {
            return;
        }
        ArrayList<String> uuidList = new ArrayList<String>();
        List list = level.m_6443_(ServerPlayer.class, new AABB(pos.m_7494_()), player -> player.m_36341_() && player.m_20096_());
        for (ServerPlayer player2 : list) {
            if (PrayingPathBlockEntity.lowPriorityPraying(level, pos, (Player)player2, prayingTick = pEntity.getPrayingTick((Player)player2))) continue;
            TensuraSkillCapability.getFrom((Player)player2).ifPresent(cap -> {
                int prayingTime = (Integer)TensuraConfig.INSTANCE.awakeningConfig.prayingTime.get();
                if (prayingTick < prayingTime) {
                    pEntity.setPrayingTick((Player)player2, prayingTick + 1);
                    if (cap.getSpiritCooldown() <= 0) {
                        if (prayingTick % 10 == 0) {
                            TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player2), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:spirits_praying"), player2.m_19879_(), 0.0, 1.0, 0.0, true));
                        }
                        player2.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.TRUE_BLINDNESS.get(), 40, 0, false, false, false));
                    }
                } else if (prayingTick == prayingTime) {
                    if (cap.getSpiritCooldown() > 0) {
                        pEntity.setPrayingTick((Player)player2, 0);
                        player2.m_5661_((Component)Component.m_237115_((String)"tensura.magic.spiritual.chosen.cooldown").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                        if (player.f_19853_.m_46472_() == TensuraDimensions.LABYRINTH && player.f_19853_.m_7654_() != null) {
                            LabyrinthSaveData saveData = LabyrinthSaveData.get(player.f_19853_.m_7654_().m_129783_());
                            Vec3 entrancePos = saveData.getEntrancePos();
                            if (LabyrinthSaveData.isEntityPassedColossus((Entity)player2) || TensuraEffectsCapability.isColossusWon((LivingEntity)player2)) {
                                entrancePos = saveData.getPassedEntrance();
                            }
                            player2.m_6021_(entrancePos.m_7096_(), entrancePos.m_7098_(), entrancePos.m_7094_());
                        }
                    } else {
                        pEntity.setPrayingTick((Player)player2, 0);
                        PrayingPathBlockEntity.rollSpirits((Player)player2);
                        cap.setSpiritCooldown((Integer)TensuraConfig.INSTANCE.awakeningConfig.prayingCooldown.get());
                        TensuraSkillCapability.sync((Player)player2);
                    }
                }
            });
            uuidList.add(player2.m_20149_());
        }
        for (String uuid : pEntity.getPrayers()) {
            if (uuidList.contains(uuid)) continue;
            prayingTick = pEntity.getPrayingTick(uuid);
            if (prayingTick < 0) {
                pEntity.setPrayingTick(uuid, prayingTick + 1);
                continue;
            }
            if (prayingTick <= 0) continue;
            pEntity.setPrayingTick(uuid, 0);
        }
    }

    private static boolean lowPriorityPraying(Level level, BlockPos pos, Player player, int currentTick) {
        for (Direction direction : Direction.values()) {
            if (direction == Direction.DOWN || direction == Direction.UP || PrayingPathBlockEntity.getNeighborPrayingTick(level, pos.m_121945_(direction), player) <= currentTick) continue;
            return true;
        }
        return false;
    }

    private static int getNeighborPrayingTick(Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PrayingPathBlockEntity) {
            PrayingPathBlockEntity prayingPath = (PrayingPathBlockEntity)blockEntity;
            return prayingPath.getPrayingTick(player);
        }
        return -1;
    }
}

