/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.capability.effects;

import com.github.manasmods.tensura.capability.effects.ITensuraEffectsCapability;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapabilityProvider;
import com.github.manasmods.tensura.handler.CapabilityHandler;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.SyncEffectsCapabilityPacket;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="tensura", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TensuraEffectsCapability
implements ITensuraEffectsCapability {
    private static final Logger log = LogManager.getLogger(TensuraEffectsCapability.class);
    public static final Capability<ITensuraEffectsCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ITensuraEffectsCapability>(){});
    private static final ResourceLocation IDENTIFIER = new ResourceLocation("tensura", "player_effects");
    private final List<ResourceLocation> syncedEffects = new ArrayList<ResourceLocation>();
    private final HashMap<ResourceLocation, UUID> effectSources = new HashMap();
    private double infectionAge = 0.0;
    private double severanceAmount = 0.0;
    private float lockedXRot = 0.0f;
    private float lockedYRot = 0.0f;
    private float height = 1.0f;
    private float heightUpdate = 1.0f;
    private boolean noKnockBack = false;
    private boolean noDyingAnimation = false;
    private boolean colossusStarted = false;
    private boolean colossusPassed = false;
    private boolean colossusWon = false;
    private int insanityFOV = 0;
    private int insanityNightmare = 0;
    private int severanceRemoveSec;
    private int warpPortalTime = 0;
    private int presenceConceal = 0;
    private int presenceSense = 0;
    private BlockPos warpPos = new BlockPos(0, 0, 0);

    @SubscribeEvent
    public static void attach(AttachCapabilitiesEvent<Entity> e) {
        e.addCapability(IDENTIFIER, (ICapabilityProvider)new TensuraEffectsCapabilityProvider());
    }

    public static LazyOptional<ITensuraEffectsCapability> getFrom(LivingEntity entity) {
        return entity.getCapability(CAPABILITY);
    }

    public static void sync(LivingEntity entity) {
        if (entity.f_19853_.m_5776_()) {
            return;
        }
        TensuraEffectsCapability.getFrom(entity).ifPresent(data -> TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new SyncEffectsCapabilityPacket((ITensuraEffectsCapability)data, entity.m_19879_())));
    }

    @Override
    public boolean hasSyncedEffect(ResourceLocation effect) {
        return this.syncedEffects.contains(effect);
    }

    @Override
    public void addSyncedEffect(ResourceLocation effect, LivingEntity entity) {
        if (!this.syncedEffects.contains(effect)) {
            this.syncedEffects.add(effect);
        }
        TensuraEffectsCapability.sync(entity);
    }

    @Override
    public void removeSyncedEffect(ResourceLocation effect, LivingEntity entity) {
        this.syncedEffects.remove(effect);
        TensuraEffectsCapability.sync(entity);
    }

    @Override
    public void clearSyncedEffects(LivingEntity entity) {
        this.syncedEffects.clear();
        TensuraEffectsCapability.sync(entity);
    }

    @Override
    @Nullable
    public UUID getEffectSource(ResourceLocation effect) {
        if (this.effectSources.containsKey(effect)) {
            return this.effectSources.get(effect);
        }
        return null;
    }

    @Override
    public void setEffectSource(@Nullable UUID player, ResourceLocation effect) {
        if (player == null) {
            this.effectSources.remove(effect);
        } else {
            this.effectSources.put(effect, player);
        }
    }

    @Override
    public void removeEffectSource(ResourceLocation effect) {
        this.setEffectSource(null, effect);
    }

    @Override
    public void setWarpPos(double x, double y, double z) {
        this.warpPos = new BlockPos(x, y, z);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_("infectionAge", this.infectionAge);
        tag.m_128350_("lockedXRot", this.lockedXRot);
        tag.m_128350_("lockedYRot", this.lockedYRot);
        tag.m_128405_("insanityFOV", this.insanityFOV);
        tag.m_128405_("insanityNightmare", this.insanityNightmare);
        tag.m_128347_("severanceAmount", this.severanceAmount);
        tag.m_128405_("severanceRemoveSec", this.severanceRemoveSec);
        tag.m_128379_("noKnockBack", this.noKnockBack);
        tag.m_128379_("noDyingAnimation", this.noDyingAnimation);
        tag.m_128379_("colossusStarted", this.colossusStarted);
        tag.m_128379_("colossusPassed", this.colossusPassed);
        tag.m_128379_("colossusWon", this.colossusWon);
        tag.m_128347_("warpX", (double)this.warpPos.m_123341_());
        tag.m_128347_("warpY", (double)this.warpPos.m_123342_());
        tag.m_128347_("warpZ", (double)this.warpPos.m_123343_());
        tag.m_128405_("portalTick", this.warpPortalTime);
        tag.m_128405_("PresenceConceal", this.presenceConceal);
        tag.m_128405_("PresenceSense", this.presenceSense);
        tag.m_128350_("height", this.height);
        tag.m_128350_("heightUpdate", this.heightUpdate);
        ListTag syncedEffectList = new ListTag();
        for (int i = 0; i < this.syncedEffects.size(); ++i) {
            CompoundTag effect = new CompoundTag();
            effect.m_128359_("effect" + i, this.syncedEffects.get(i).toString());
            syncedEffectList.add((Object)effect);
        }
        tag.m_128365_("syncedEffects", (Tag)syncedEffectList);
        ListTag effectList = new ListTag();
        this.effectSources.keySet().forEach(instance -> {
            CompoundTag hashMap = new CompoundTag();
            hashMap.m_128362_(instance.toString(), this.effectSources.get(instance));
            effectList.add((Object)hashMap);
        });
        tag.m_128365_("effectSources", (Tag)effectList);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        Object object;
        this.infectionAge = tag.m_128459_("infectionAge");
        this.lockedXRot = tag.m_128457_("lockedXRot");
        this.lockedYRot = tag.m_128457_("lockedYRot");
        this.insanityFOV = tag.m_128451_("insanityFOV");
        this.insanityNightmare = tag.m_128451_("insanityNightmare");
        this.severanceAmount = tag.m_128459_("severanceAmount");
        this.severanceRemoveSec = tag.m_128451_("severanceRemoveSec");
        this.noKnockBack = tag.m_128471_("noKnockBack");
        this.noDyingAnimation = tag.m_128471_("noDyingAnimation");
        this.colossusStarted = tag.m_128471_("colossusStarted");
        this.colossusPassed = tag.m_128471_("colossusPassed");
        this.colossusWon = tag.m_128471_("colossusWon");
        this.warpPos = new BlockPos(tag.m_128459_("warpX"), tag.m_128459_("warpY"), tag.m_128459_("warpZ"));
        this.warpPortalTime = tag.m_128451_("portalTick");
        this.presenceConceal = tag.m_128451_("PresenceConceal");
        this.presenceSense = tag.m_128451_("PresenceSense");
        this.height = tag.m_128457_("height");
        this.heightUpdate = tag.m_128457_("heightUpdate");
        ListTag syncedEffectList = (ListTag)tag.m_128423_("syncedEffects");
        if (syncedEffectList != null) {
            this.syncedEffects.clear();
            for (int i = 0; i < syncedEffectList.size(); ++i) {
                CompoundTag spirit = (CompoundTag)syncedEffectList.get(i);
                this.syncedEffects.add(ResourceLocation.m_135820_((String)spirit.m_128461_("effect" + i)));
            }
        }
        if ((object = tag.m_128423_("effectSources")) instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)object;
            for (String name : compoundTag.m_128431_()) {
                this.effectSources.put(ResourceLocation.m_135820_((String)name), compoundTag.m_128342_(name));
            }
        }
    }

    public static boolean hasSyncedEffect(LivingEntity pLivingEntity, MobEffect effect) {
        ITensuraEffectsCapability capability = CapabilityHandler.getCapability((Entity)pLivingEntity, CAPABILITY);
        if (capability == null) {
            return false;
        }
        ResourceLocation resourceLocation = Registry.f_122823_.m_7981_((Object)effect);
        if (resourceLocation == null) {
            return false;
        }
        return capability.hasSyncedEffect(resourceLocation);
    }

    @Nullable
    public static Player getEffectSource(LivingEntity pLivingEntity, MobEffect effect) {
        ITensuraEffectsCapability capability = CapabilityHandler.getCapability((Entity)pLivingEntity, CAPABILITY);
        if (capability == null) {
            return null;
        }
        ResourceLocation resourceLocation = Registry.f_122823_.m_7981_((Object)effect);
        if (resourceLocation == null) {
            return null;
        }
        UUID uuid = capability.getEffectSource(resourceLocation);
        if (uuid == null) {
            return null;
        }
        return pLivingEntity.m_9236_().m_46003_(uuid);
    }

    public static void setEffectSource(LivingEntity entity, @Nullable LivingEntity source, MobEffect effect) {
        ResourceLocation resourceLocation = Registry.f_122823_.m_7981_((Object)effect);
        if (resourceLocation == null) {
            return;
        }
        TensuraEffectsCapability.getFrom(entity).ifPresent(cap -> {
            if (source == null) {
                cap.removeEffectSource(resourceLocation);
            } else {
                cap.setEffectSource(source.m_20148_(), resourceLocation);
            }
            TensuraEffectsCapability.sync(entity);
        });
    }

    public static boolean noDyingAnimation(LivingEntity pLivingEntity) {
        ITensuraEffectsCapability capability = CapabilityHandler.getCapability((Entity)pLivingEntity, CAPABILITY);
        if (capability == null) {
            return false;
        }
        return capability.isNoDyingAnimation();
    }

    @Nullable
    public static BlockPos getWarpPos(LivingEntity pLivingEntity) {
        ITensuraEffectsCapability capability = CapabilityHandler.getCapability((Entity)pLivingEntity, CAPABILITY);
        if (capability == null) {
            return null;
        }
        return capability.getWarpPos();
    }

    public static int getWarpPortalTime(LivingEntity pLivingEntity) {
        ITensuraEffectsCapability capability = CapabilityHandler.getCapability((Entity)pLivingEntity, CAPABILITY);
        if (capability == null) {
            return 0;
        }
        return capability.getWarpPortalTime();
    }

    public static int getPresenceConcealment(LivingEntity pLivingEntity) {
        ITensuraEffectsCapability capability = CapabilityHandler.getCapability((Entity)pLivingEntity, CAPABILITY);
        if (capability == null) {
            return 0;
        }
        return capability.getPresenceConceal();
    }

    public static int getPresenceSense(LivingEntity pLivingEntity) {
        ITensuraEffectsCapability capability = CapabilityHandler.getCapability((Entity)pLivingEntity, CAPABILITY);
        if (capability == null) {
            return 0;
        }
        int sense = capability.getPresenceSense();
        if (capability.hasSyncedEffect(TensuraMobEffects.ALL_SEEING.getId())) {
            ++sense;
        }
        return sense;
    }

    public static float getHeight(LivingEntity entity) {
        ITensuraEffectsCapability capability = CapabilityHandler.getCapability((Entity)entity, CAPABILITY);
        if (capability == null) {
            return 0.0f;
        }
        return capability.getHeight();
    }

    public static void setHeight(Player player, float value) {
        TensuraEffectsCapability.getFrom((LivingEntity)player).ifPresent(cap -> {
            if (value != cap.getHeight()) {
                cap.setHeight(value);
                TensuraEffectsCapability.sync((LivingEntity)player);
            }
        });
    }

    public static double getSeverance(LivingEntity pLivingEntity) {
        ITensuraEffectsCapability capability = CapabilityHandler.getCapability((Entity)pLivingEntity, CAPABILITY);
        if (capability == null) {
            return 0.0;
        }
        return capability.getSeveranceAmount();
    }

    public static boolean isColossusPassed(LivingEntity pLivingEntity) {
        ITensuraEffectsCapability capability = CapabilityHandler.getCapability((Entity)pLivingEntity, CAPABILITY);
        if (capability == null) {
            return false;
        }
        return capability.isColossusPassed();
    }

    public static boolean isColossusStarted(LivingEntity pLivingEntity) {
        ITensuraEffectsCapability capability = CapabilityHandler.getCapability((Entity)pLivingEntity, CAPABILITY);
        if (capability == null) {
            return false;
        }
        return capability.isColossusStarted();
    }

    public static boolean isColossusWon(LivingEntity pLivingEntity) {
        ITensuraEffectsCapability capability = CapabilityHandler.getCapability((Entity)pLivingEntity, CAPABILITY);
        if (capability == null) {
            return false;
        }
        return capability.isColossusWon();
    }

    public static void resetEverything(LivingEntity entity, boolean presenceSense, boolean colossus) {
        TensuraEffectsCapability.getFrom(entity).ifPresent(cap -> {
            if (presenceSense) {
                cap.setPresenceConceal(0);
                cap.setPresenceSense(0);
            }
            if (colossus) {
                cap.setColossusPassed(false);
                cap.setColossusStarted(false);
                cap.setColossusWon(false);
            }
            cap.setSeveranceRemoveSec(0);
            cap.setSeveranceAmount(0.0);
            cap.setWarpPortalTime(0);
            cap.setNoKnockBack(false);
            cap.setHeight(1.0f);
            cap.setInfectionAge(0.0);
            cap.setInsanityNightmare(0);
            cap.clearSyncedEffects(entity);
        });
        TensuraEffectsCapability.sync(entity);
    }

    @Override
    public double getInfectionAge() {
        return this.infectionAge;
    }

    @Override
    public double getSeveranceAmount() {
        return this.severanceAmount;
    }

    @Override
    public void setInfectionAge(double infectionAge) {
        this.infectionAge = infectionAge;
    }

    @Override
    public void setSeveranceAmount(double severanceAmount) {
        this.severanceAmount = severanceAmount;
    }

    @Override
    public float getLockedXRot() {
        return this.lockedXRot;
    }

    @Override
    public float getLockedYRot() {
        return this.lockedYRot;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public float getHeightUpdate() {
        return this.heightUpdate;
    }

    @Override
    public void setLockedXRot(float lockedXRot) {
        this.lockedXRot = lockedXRot;
    }

    @Override
    public void setLockedYRot(float lockedYRot) {
        this.lockedYRot = lockedYRot;
    }

    @Override
    public void setHeight(float height) {
        this.height = height;
    }

    @Override
    public void setHeightUpdate(float heightUpdate) {
        this.heightUpdate = heightUpdate;
    }

    @Override
    public boolean isNoKnockBack() {
        return this.noKnockBack;
    }

    @Override
    public boolean isNoDyingAnimation() {
        return this.noDyingAnimation;
    }

    @Override
    public void setNoKnockBack(boolean noKnockBack) {
        this.noKnockBack = noKnockBack;
    }

    @Override
    public void setNoDyingAnimation(boolean noDyingAnimation) {
        this.noDyingAnimation = noDyingAnimation;
    }

    @Override
    public boolean isColossusStarted() {
        return this.colossusStarted;
    }

    @Override
    public boolean isColossusPassed() {
        return this.colossusPassed;
    }

    @Override
    public boolean isColossusWon() {
        return this.colossusWon;
    }

    @Override
    public void setColossusStarted(boolean colossusStarted) {
        this.colossusStarted = colossusStarted;
    }

    @Override
    public void setColossusPassed(boolean colossusPassed) {
        this.colossusPassed = colossusPassed;
    }

    @Override
    public void setColossusWon(boolean colossusWon) {
        this.colossusWon = colossusWon;
    }

    @Override
    public int getInsanityFOV() {
        return this.insanityFOV;
    }

    @Override
    public int getInsanityNightmare() {
        return this.insanityNightmare;
    }

    @Override
    public int getSeveranceRemoveSec() {
        return this.severanceRemoveSec;
    }

    @Override
    public void setInsanityFOV(int insanityFOV) {
        this.insanityFOV = insanityFOV;
    }

    @Override
    public void setInsanityNightmare(int insanityNightmare) {
        this.insanityNightmare = insanityNightmare;
    }

    @Override
    public void setSeveranceRemoveSec(int severanceRemoveSec) {
        this.severanceRemoveSec = severanceRemoveSec;
    }

    @Override
    public int getWarpPortalTime() {
        return this.warpPortalTime;
    }

    @Override
    public int getPresenceConceal() {
        return this.presenceConceal;
    }

    @Override
    public int getPresenceSense() {
        return this.presenceSense;
    }

    @Override
    public void setWarpPortalTime(int warpPortalTime) {
        this.warpPortalTime = warpPortalTime;
    }

    @Override
    public void setPresenceConceal(int presenceConceal) {
        this.presenceConceal = presenceConceal;
    }

    @Override
    public void setPresenceSense(int presenceSense) {
        this.presenceSense = presenceSense;
    }

    @Override
    public BlockPos getWarpPos() {
        return this.warpPos;
    }
}

