/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.capability.magicule;

import com.github.manasmods.tensura.Tensura;
import com.github.manasmods.tensura.api.magicule.MagiculeEvent;
import com.github.manasmods.tensura.api.magicule.MagiculeModifier;
import com.github.manasmods.tensura.capability.magicule.MagiculeCapablilityProvider;
import com.github.manasmods.tensura.capability.magicule.MagiculeChunkCapability;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.SyncMagiculePacket;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.NonNull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="tensura", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MagiculeChunkCapabilityImpl
implements MagiculeChunkCapability {
    static final Capability<MagiculeChunkCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<MagiculeChunkCapability>(){});
    private static final ResourceLocation IDENTIFIER = new ResourceLocation("tensura", "magicule");
    private long magiculeSeed = -1L;
    private double maxMagicule;
    private double regenerationRate;
    private double magiculePercentage;
    @Nullable
    private LevelChunk chunk = null;
    private boolean dirty = false;
    private int syncCounter;
    private Map<BlockPos, MagiculeCacheEntry> magiculeCache = new HashMap<BlockPos, MagiculeCacheEntry>();

    @SubscribeEvent
    static void attach(AttachCapabilitiesEvent<LevelChunk> e) {
        e.addCapability(IDENTIFIER, (ICapabilityProvider)new MagiculeCapablilityProvider());
    }

    public static MagiculeChunkCapability get(LevelChunk chunk) {
        MagiculeChunkCapabilityImpl capability = (MagiculeChunkCapabilityImpl)chunk.getCapability(CAPABILITY).orElseThrow(() -> new IllegalStateException("Magicule capability not found!"));
        capability.initialize(chunk);
        return capability;
    }

    public MagiculeChunkCapabilityImpl() {
        this.maxMagicule = (Double)TensuraConfig.INSTANCE.magiculeConfig.baseMagicule.get();
        this.regenerationRate = (Double)TensuraConfig.INSTANCE.magiculeConfig.baseMagiculeRegeneration.get();
        this.syncCounter = (Integer)TensuraConfig.INSTANCE.magiculeConfig.magiculeSyncInterval.get();
    }

    private boolean isInitialized() {
        if (this.chunk == null) {
            return true;
        }
        if (this.chunk.m_62953_().m_5776_()) {
            return true;
        }
        return this.magiculeSeed == (Long)TensuraConfig.INSTANCE.magiculeConfig.magiculeSeed.get();
    }

    public void tick() {
        if (!this.isInitialized()) {
            return;
        }
        if (this.chunk == null) {
            return;
        }
        this.regenerationTick();
        this.cacheTick();
        this.syncTick();
    }

    @Override
    public double getMagicule() {
        return this.maxMagicule * this.magiculePercentage;
    }

    private void regenerationTick() {
        if (this.magiculePercentage == 1.0) {
            return;
        }
        MagiculeEvent.Regeneration event = new MagiculeEvent.Regeneration(this.chunk, this);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        this.magiculePercentage = 1.0 / this.maxMagicule * event.getNewMagicule();
        this.markDirty();
    }

    private void syncTick() {
        if (--this.syncCounter > 0) {
            return;
        }
        this.syncCounter = (Integer)TensuraConfig.INSTANCE.magiculeConfig.magiculeSyncInterval.get();
        if (!this.dirty) {
            return;
        }
        this.sync();
        this.dirty = false;
    }

    private void cacheTick() {
        this.magiculeCache.keySet().removeIf(pos -> {
            MagiculeCacheEntry entry = this.magiculeCache.get(pos);
            entry.tick();
            return entry.isOutdated();
        });
    }

    private void markDirty() {
        this.dirty = true;
        if (this.chunk == null) {
            return;
        }
        this.chunk.m_8092_(true);
    }

    private void initialize(@NonNull LevelChunk chunk) {
        if (chunk == null) {
            throw new NullPointerException("chunk is marked non-null but is null");
        }
        this.chunk = chunk;
        if (this.isInitialized()) {
            return;
        }
        this.resetBaseValues();
        MagiculeEvent.Initialization event = new MagiculeEvent.Initialization(chunk, this);
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.maxMagicule = event.getNewMaxMagicule();
        this.regenerationRate = event.getNewRegenerationRate();
        this.magiculePercentage = 1.0;
        this.magiculeSeed = (Long)TensuraConfig.INSTANCE.magiculeConfig.magiculeSeed.get();
        this.markDirty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128356_("magiculeSeed", this.magiculeSeed);
        tag.m_128347_("maxMagicule", this.maxMagicule);
        tag.m_128347_("regenerationRate", this.regenerationRate);
        tag.m_128347_("magiculePercentage", this.magiculePercentage);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.magiculeSeed = tag.m_128454_("magiculeSeed");
        this.maxMagicule = tag.m_128459_("maxMagicule");
        this.regenerationRate = tag.m_128459_("regenerationRate");
        this.magiculePercentage = tag.m_128459_("magiculePercentage");
    }

    @Nullable
    private MagiculeCacheEntry getOrCreateCacheEntry(BlockPos pos) {
        return this.magiculeCache.computeIfAbsent(pos, position -> {
            if (this.chunk == null) {
                return null;
            }
            MagiculeEvent.RegisterModifier event = new MagiculeEvent.RegisterModifier(this.chunk, this, (BlockPos)position);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return MagiculeCacheEntry.of(event.getModifiers());
        });
    }

    @Override
    public double getMaxMagicule(BlockPos pos) {
        MagiculeCacheEntry entry = this.getOrCreateCacheEntry(pos);
        if (entry == null) {
            return this.maxMagicule;
        }
        return entry.getMaxMagicule(this.maxMagicule);
    }

    @Override
    public double getMagicule(BlockPos pos) {
        MagiculeCacheEntry entry = this.getOrCreateCacheEntry(pos);
        if (entry == null) {
            return this.maxMagicule * this.magiculePercentage;
        }
        return entry.getMagicule(this.maxMagicule, this.magiculePercentage);
    }

    private void sync() {
        if (this.chunk == null) {
            return;
        }
        if (this.chunk.m_62953_().m_5776_()) {
            return;
        }
        TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.chunk), (Object)new SyncMagiculePacket(this.chunk.m_7697_(), this.serializeNBT()));
    }

    @Override
    public void sync(@NonNull ServerPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (this.chunk == null) {
            return;
        }
        if (this.chunk.m_62953_().m_5776_()) {
            return;
        }
        TensuraNetwork.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncMagiculePacket(this.chunk.m_7697_(), this.serializeNBT()));
    }

    @Override
    public boolean consumeMagicule(BlockPos pos, double amount) {
        MagiculeCacheEntry entry = this.getOrCreateCacheEntry(pos);
        if (entry == null) {
            return false;
        }
        MagiculeEvent.Consume event = new MagiculeEvent.Consume(this.chunk, this, pos, amount);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        double magicule = entry.getMagicule(this.maxMagicule, this.magiculePercentage);
        if (magicule < event.getAmount()) {
            return false;
        }
        this.magiculePercentage = 1.0 / entry.getMaxMagicule(this.maxMagicule) * (magicule -= event.getAmount());
        this.markDirty();
        return true;
    }

    public void reinitialize() {
        if (this.chunk == null) {
            return;
        }
        Tensura.getLogger().debug("Reinitializing magicule capability for chunk at {},{} in {}", (Object)this.chunk.m_7697_().f_45578_, (Object)this.chunk.m_7697_().f_45579_, (Object)this.chunk.m_62953_().m_46472_().m_135782_());
        this.magiculeSeed = -1L;
        this.resetBaseValues();
        this.initialize(this.chunk);
    }

    public void resetBaseValues() {
        this.maxMagicule = (Double)TensuraConfig.INSTANCE.magiculeConfig.baseMagicule.get();
        this.regenerationRate = (Double)TensuraConfig.INSTANCE.magiculeConfig.baseMagiculeRegeneration.get();
        this.syncCounter = (Integer)TensuraConfig.INSTANCE.magiculeConfig.magiculeSyncInterval.get();
        this.magiculeCache.clear();
        this.dirty = false;
    }

    @Override
    public double getMaxMagicule() {
        return this.maxMagicule;
    }

    public void setMaxMagicule(double maxMagicule) {
        this.maxMagicule = maxMagicule;
    }

    @Override
    public double getRegenerationRate() {
        return this.regenerationRate;
    }

    public void setRegenerationRate(double regenerationRate) {
        this.regenerationRate = regenerationRate;
    }

    private static class MagiculeCacheEntry {
        private int remains;
        private final List<MagiculeModifier> modifiers;
        private Pair<Double, Double> maxValueCache;

        public void tick() {
            --this.remains;
        }

        public boolean isOutdated() {
            return this.remains <= 0;
        }

        public double getMaxMagicule(double maxMagicule) {
            if (this.maxValueCache != null && (Double)this.maxValueCache.getFirst() == maxMagicule) {
                return (Double)this.maxValueCache.getSecond();
            }
            double newMaxMagicule = maxMagicule;
            for (MagiculeModifier modifier : this.modifiers) {
                newMaxMagicule = modifier.getMaxMagicule(newMaxMagicule);
            }
            this.maxValueCache = Pair.of((Object)maxMagicule, (Object)newMaxMagicule);
            return newMaxMagicule;
        }

        public double getMagicule(double maxMagicule, double magiculePercentage) {
            return this.getMaxMagicule(maxMagicule) * magiculePercentage;
        }

        private MagiculeCacheEntry(List<MagiculeModifier> modifiers) {
            this.remains = (Integer)TensuraConfig.INSTANCE.magiculeConfig.modifierUpdateInterval.get();
            this.maxValueCache = null;
            this.modifiers = modifiers;
        }

        public static MagiculeCacheEntry of(List<MagiculeModifier> modifiers) {
            return new MagiculeCacheEntry(modifiers);
        }
    }
}

