/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.capability.smithing;

import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.ForgeRegistries;

public interface ISmithingCapability
extends INBTSerializable<CompoundTag> {
    public boolean hasSchematic(ResourceLocation var1);

    default public boolean hasSchematic(Item schematic) {
        return this.hasSchematic(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)schematic)));
    }

    default public boolean hasSchematic(ItemStack schematic) {
        return this.hasSchematic(schematic.m_41720_());
    }

    public void unlockSchematic(ResourceLocation var1);

    default public void unlockSchematic(Item schematic) {
        this.unlockSchematic(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)schematic)));
    }

    default public void unlockSchematic(ItemStack schematic) {
        this.unlockSchematic(schematic.m_41720_());
    }

    default public boolean hasSchematics(List<ResourceLocation> requiredSchematics) {
        for (ResourceLocation schematic : requiredSchematics) {
            if (this.hasSchematic(schematic)) continue;
            return false;
        }
        return true;
    }

    public void clearSchematics();
}

