/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.capability.smithing;

import com.github.manasmods.tensura.capability.smithing.ISmithingCapability;
import com.github.manasmods.tensura.capability.smithing.SmithingCapabilityProvider;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.SyncSmithingCapabilityPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="tensura", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SmithingCapability
implements ISmithingCapability {
    static final Capability<ISmithingCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ISmithingCapability>(){});
    private static final ResourceLocation IDENTIFIER = new ResourceLocation("tensura", "schematics");
    private final List<ResourceLocation> knownSchematics = new ArrayList<ResourceLocation>();

    @SubscribeEvent
    public static void attach(AttachCapabilitiesEvent<Entity> e) {
        ItemTags.create((ResourceLocation)new ResourceLocation("tensura", "test"));
        if (e.getObject() instanceof Player) {
            e.addCapability(IDENTIFIER, (ICapabilityProvider)new SmithingCapabilityProvider());
        }
    }

    public static LazyOptional<ISmithingCapability> getFrom(Player player) {
        return player.getCapability(CAPABILITY);
    }

    public static void sync(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SmithingCapability.getFrom((Player)serverPlayer).ifPresent(data -> TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> serverPlayer), (Object)new SyncSmithingCapabilityPacket((CompoundTag)data.serializeNBT(), serverPlayer.m_19879_())));
        }
    }

    @Override
    public boolean hasSchematic(ResourceLocation schematic) {
        return this.knownSchematics.contains(schematic);
    }

    @Override
    public void unlockSchematic(ResourceLocation schematicId) {
        this.knownSchematics.add(schematicId);
    }

    @Override
    public void clearSchematics() {
        this.knownSchematics.clear();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        for (int i = 0; i < this.knownSchematics.size(); ++i) {
            tag.m_128359_(String.valueOf(i), this.knownSchematics.get(i).toString());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.knownSchematics.clear();
        nbt.m_128431_().forEach(s -> this.knownSchematics.add(ResourceLocation.m_135820_((String)nbt.m_128461_(s))));
    }
}

