/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.client.particle;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;

public class TensuraParticleHelper {
    public static void spawnParticlesLikeServer(Level level, ParticleOptions particle, double x, double y, double z, int count, double deltaX, double deltaY, double deltaZ, double speed, boolean force) {
        for (int i = 0; i < count; ++i) {
            double d1 = level.f_46441_.m_188583_() * deltaX;
            double d3 = level.f_46441_.m_188583_() * deltaY;
            double d5 = level.f_46441_.m_188583_() * deltaZ;
            double d6 = level.f_46441_.m_188583_() * speed;
            double d7 = level.f_46441_.m_188583_() * speed;
            double d8 = level.f_46441_.m_188583_() * speed;
            level.m_6493_(particle, force, x + d1, y + d3, z + d5, d6, d7, d8);
        }
    }

    public static void spawnServerParticles(Level level, ParticleOptions particle, double x, double y, double z, int count, double deltaX, double deltaY, double deltaZ, double speed, boolean force) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        serverLevel.m_7654_().m_6846_().m_11314_().forEach(player -> serverLevel.m_8624_(player, particle, force, x, y, z, count, deltaX, deltaY, deltaZ, speed));
    }

    public static void spawnParticlesToOnePLayer(Player player, ParticleOptions particle, double x, double y, double z, int count, double deltaX, double deltaY, double deltaZ, double speed, boolean force) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        Level level = player.f_19853_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        serverLevel.m_8624_(serverPlayer, particle, force, x, y, z, count, deltaX, deltaY, deltaZ, speed);
    }

    public static void addParticlesAroundSelf(Entity entity, ParticleOptions pParticleOption) {
        TensuraParticleHelper.addParticlesAroundSelf(entity, pParticleOption, 1.0);
    }

    public static void addParticlesAroundSelf(Entity entity, ParticleOptions pParticleOption, double randomScale) {
        RandomSource randomSource;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            randomSource = living.m_217043_();
        } else {
            randomSource = RandomSource.m_216327_();
        }
        RandomSource random = randomSource;
        for (int i = 0; i < 5; ++i) {
            double d0 = random.m_188583_() * 0.02;
            double d1 = random.m_188583_() * 0.02;
            double d2 = random.m_188583_() * 0.02;
            entity.f_19853_.m_7106_(pParticleOption, entity.m_20208_(randomScale), entity.m_20187_(), entity.m_20262_(randomScale), d0, d1, d2);
        }
    }

    public static void addParticlesAroundPos(RandomSource random, Level level, Vec3 pos, ParticleOptions pParticleOption, double randomScale, int particleAmount) {
        for (int i = 0; i < particleAmount; ++i) {
            double d0 = random.m_188583_() * 0.02;
            double d1 = random.m_188583_() * 0.02;
            double d2 = random.m_188583_() * 0.02;
            double x = pos.f_82479_ + (2.0 * random.m_188500_() - 1.0) * randomScale;
            double y = pos.f_82480_ + (2.0 * random.m_188500_() - 1.0) * randomScale;
            double z = pos.f_82481_ + (2.0 * random.m_188500_() - 1.0) * randomScale;
            level.m_7106_(pParticleOption, x, y, z, d0, d1, d2);
        }
    }

    public static void addServerParticlesAroundPos(RandomSource random, Level level, Vec3 pos, ParticleOptions pParticleOption, double randomScale) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        for (int i = 0; i < 5; ++i) {
            double d0 = random.m_188583_() * 0.02;
            double d1 = random.m_188583_() * 0.02;
            double d2 = random.m_188583_() * 0.02;
            double x = pos.f_82479_ + (2.0 * random.m_188500_() - 1.0) * randomScale;
            double y = pos.f_82480_ + (2.0 * random.m_188500_() - 1.0) * randomScale;
            double z = pos.f_82481_ + (2.0 * random.m_188500_() - 1.0) * randomScale;
            serverLevel.m_8767_(pParticleOption, x, y, z, 0, d0, d1, d2, 1.0);
        }
    }

    public static void addServerParticlesAroundSelf(Entity entity, ParticleOptions pParticleOption) {
        TensuraParticleHelper.addServerParticlesAroundSelf(entity, pParticleOption, 1.0);
    }

    public static void addServerParticlesAroundSelf(Entity entity, ParticleOptions pParticleOption, double randomScale) {
        TensuraParticleHelper.addServerParticlesAroundSelf(entity, pParticleOption, randomScale, 5);
    }

    public static void addServerParticlesAroundSelf(Entity entity, ParticleOptions pParticleOption, double randomScale, int amount) {
        RandomSource randomSource;
        Level level = entity.f_19853_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            randomSource = living.m_217043_();
        } else {
            randomSource = RandomSource.m_216327_();
        }
        RandomSource random = randomSource;
        for (int i = 0; i < amount; ++i) {
            double d0 = random.m_188583_() * 0.02;
            double d1 = random.m_188583_() * 0.02;
            double d2 = random.m_188583_() * 0.02;
            serverLevel.m_8767_(pParticleOption, entity.m_20208_(randomScale), entity.m_20187_(), entity.m_20262_(randomScale), 0, d0, d1, d2, 1.0);
        }
    }

    public static void addServerParticlesAroundSelfToOnePlayer(ServerPlayer player, Entity entity, ParticleOptions pParticleOption, double randomScale) {
        RandomSource randomSource;
        Level level = entity.f_19853_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            randomSource = living.m_217043_();
        } else {
            randomSource = RandomSource.m_216327_();
        }
        RandomSource random = randomSource;
        for (int i = 0; i < 5; ++i) {
            double d0 = random.m_188583_() * 0.02;
            double d1 = random.m_188583_() * 0.02;
            double d2 = random.m_188583_() * 0.02;
            serverLevel.m_8624_(player, pParticleOption, true, entity.m_20208_(randomScale), entity.m_20187_(), entity.m_20262_(randomScale), 0, d0, d1, d2, 1.0);
        }
    }

    public static void addServerParticlesAroundSelfToPredicatePlayer(Predicate<ServerPlayer> predicate, Entity entity, ParticleOptions pParticleOption, double randomScale) {
        RandomSource randomSource;
        Level level = entity.f_19853_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            randomSource = living.m_217043_();
        } else {
            randomSource = RandomSource.m_216327_();
        }
        RandomSource random = randomSource;
        for (int i = 0; i < 5; ++i) {
            double d0 = random.m_188583_() * 0.02;
            double d1 = random.m_188583_() * 0.02;
            double d2 = random.m_188583_() * 0.02;
            serverLevel.m_7654_().m_6846_().m_11314_().forEach(player -> {
                if (!predicate.test((ServerPlayer)player)) {
                    return;
                }
                serverLevel.m_8624_(player, pParticleOption, true, entity.m_20208_(randomScale), entity.m_20187_(), entity.m_20262_(randomScale), 0, d0, d1, d2, 1.0);
            });
        }
    }

    public static void spawnServerGroundSlamParticle(LivingEntity living, int amount, float radius) {
        for (int i = 0; i < amount; ++i) {
            for (int i1 = 0; i1 < 20 + living.m_217043_().m_188503_(12); ++i1) {
                double motionX = living.m_217043_().m_188583_() * 0.07;
                double motionY = living.m_217043_().m_188583_() * 0.07;
                double motionZ = living.m_217043_().m_188583_() * 0.07;
                float angle = (float)Math.PI / 180 * living.f_20883_ + (float)i1;
                double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.8f;
                double extraZ = radius * Mth.m_14089_((float)angle);
                BlockPos groundPos = new BlockPos(Mth.m_14107_((double)(living.m_20185_() + extraX)), Mth.m_14107_((double)(living.m_20186_() + extraY)) - 1, Mth.m_14107_((double)(living.m_20189_() + extraZ)));
                BlockState groundState = living.m_9236_().m_8055_(groundPos);
                if (groundState.m_60767_() == Material.f_76296_ || living.m_9236_().m_5776_()) continue;
                ((ServerLevel)living.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, groundState), living.m_20185_() + extraX, (double)groundPos.m_123342_() + extraY, living.m_20189_() + extraZ, 0, motionX, motionY, motionZ, 1.0);
            }
        }
    }

    public static void spawnGroundSlamParticle(LivingEntity living, int amount, float radius) {
        for (int i = 0; i < amount; ++i) {
            for (int i1 = 0; i1 < 20 + living.m_217043_().m_188503_(12); ++i1) {
                double motionX = living.m_217043_().m_188583_() * 0.07;
                double motionY = living.m_217043_().m_188583_() * 0.07;
                double motionZ = living.m_217043_().m_188583_() * 0.07;
                float angle = (float)Math.PI / 180 * living.f_20883_ + (float)i1;
                double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.8f;
                double extraZ = radius * Mth.m_14089_((float)angle);
                BlockPos groundPos = new BlockPos(Mth.m_14107_((double)(living.m_20185_() + extraX)), Mth.m_14107_((double)(living.m_20186_() + extraY)) - 1, Mth.m_14107_((double)(living.m_20189_() + extraZ)));
                BlockState groundState = living.m_9236_().m_8055_(groundPos);
                if (groundState.m_60767_() == Material.f_76296_ || living.m_9236_().m_5776_()) continue;
                living.m_9236_().m_6493_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, groundState), true, living.m_20185_() + extraX, (double)groundPos.m_123342_() + extraY, living.m_20189_() + extraZ, motionX, motionY, motionZ);
            }
        }
    }

    public static void spawnSlamParticle(Entity entity, ParticleOptions options, int amount, float radius) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        RandomSource random = RandomSource.m_216327_();
        for (int i = 0; i < amount; ++i) {
            for (int i1 = 0; i1 < 20 + random.m_188503_(12); ++i1) {
                double motionX = random.m_188583_() * 0.07;
                double motionY = random.m_188583_() * 0.07;
                double motionZ = random.m_188583_() * 0.07;
                float angle = (float)Math.PI + (float)i1;
                double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.8f;
                double extraZ = radius * Mth.m_14089_((float)angle);
                BlockPos groundPos = new BlockPos(Mth.m_14107_((double)(entity.m_20185_() + extraX)), Mth.m_14107_((double)(entity.m_20186_() + extraY)), Mth.m_14107_((double)(entity.m_20189_() + extraZ)));
                BlockState groundState = entity.m_9236_().m_8055_(groundPos);
                if (groundState.m_60767_() == Material.f_76296_) continue;
                entity.m_9236_().m_6493_(options, true, entity.m_20185_() + extraX, (double)groundPos.m_123342_() + extraY, entity.m_20189_() + extraZ, motionX, motionY, motionZ);
            }
        }
    }

    public static void particleCloud(Level level, RandomSource random, ParticleOptions particleoptions, double xPos, double yPos, double zPos, double ySpeed, double xzSpeed, double radius) {
        int i = Mth.m_14165_((double)(3.1415927410125732 * radius * radius));
        for (int j = 0; j < i; ++j) {
            float angle = random.m_188501_() * ((float)Math.PI * 2);
            double randomRad = (double)Mth.m_14116_((float)random.m_188501_()) * radius;
            double x = xPos + (double)Mth.m_14089_((float)angle) * randomRad;
            double z = zPos + (double)Mth.m_14031_((float)angle) * randomRad;
            double xSpeed = (0.5 - random.m_188500_()) * xzSpeed;
            double zSpeed = (0.5 - random.m_188500_()) * xzSpeed;
            level.m_7106_(particleoptions, x, yPos, z, xSpeed, ySpeed, zSpeed);
        }
    }

    public static void particleCloud(Level level, RandomSource random, ParticleOptions particleoptions, BlockPos pos, double ySpeed, double xzSpeed, double radius) {
        TensuraParticleHelper.particleCloud(level, random, particleoptions, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), ySpeed, xzSpeed, radius);
    }

    public static void serverParticleCloud(Level level, RandomSource random, ParticleOptions particleoptions, double xPos, double yPos, double zPos, double ySpeed, double xzSpeed, double radius) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int i = Mth.m_14165_((double)(3.1415927410125732 * radius * radius));
        for (int j = 0; j < i; ++j) {
            float angle = random.m_188501_() * ((float)Math.PI * 2);
            double randomRad = (double)Mth.m_14116_((float)random.m_188501_()) * radius;
            double x = xPos + (double)Mth.m_14089_((float)angle) * randomRad;
            double z = zPos + (double)Mth.m_14031_((float)angle) * randomRad;
            double xSpeed = (0.5 - random.m_188500_()) * xzSpeed;
            double zSpeed = (0.5 - random.m_188500_()) * xzSpeed;
            serverLevel.m_8767_(particleoptions, x, yPos, z, 0, xSpeed, ySpeed, zSpeed, 1.0);
        }
    }
}

