/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.client.screen;

import com.github.manasmods.manascore.api.client.gui.FontRenderHelper;
import com.github.manasmods.manascore.api.client.gui.widget.ImagePredicateButton;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.TensuraGUIHelper;
import com.github.manasmods.tensura.client.keybind.TensuraKeybinds;
import com.github.manasmods.tensura.menu.EvolutionMenu;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2server.SetTrackedEvolutionPacket;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.util.Cached;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public class EvolutionScreen
extends AbstractContainerScreen<EvolutionMenu> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("tensura", "textures/gui/evolution/evolution_gui.png");
    private static final ResourceLocation RACE_BUTTON = new ResourceLocation("tensura", "textures/gui/evolution/race_button.png");
    private static final ResourceLocation SCROLL_BAR = new ResourceLocation("tensura", "textures/gui/scroll_bar.png");
    private static final ResourceLocation TRACK_BUTTON = new ResourceLocation("tensura", "textures/gui/evolution/track_button.png");
    private static final ResourceLocation EVOLVE_BUTTON = new ResourceLocation("tensura", "textures/gui/evolution/evolve_button.png");
    private final Player player;
    private Cached<List<Race>, String> evolutions;
    private EditBox searchField;
    private boolean scrolling;
    private float scrollOffs;
    private int startIndex;
    private Race selectedRace;
    private Race trackedRace;
    private String evolutionProgress = "0%";
    private String selectedRaceEvolutionProgress;
    private final DecimalFormat roundDouble = new DecimalFormat("#");

    public EvolutionScreen(EvolutionMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 256;
        this.f_97727_ = 163;
        this.player = pPlayerInventory.f_35978_;
    }

    protected void m_7856_() {
        super.m_7856_();
        ImmutableList<ImagePredicateButton> tabs = TensuraGUIHelper.addMenuTabs(this, 0, true);
        for (ImagePredicateButton button2 : tabs) {
            this.m_142416_((GuiEventListener)button2);
        }
        this.updateRaceVariables(TensuraPlayerCapability.getTrackedEvolution((LivingEntity)this.player), true);
        if (this.selectedRace == null) {
            this.updateRaceVariables(this.trackedRace, false);
        }
        this.scrollOffs = 0.0f;
        this.startIndex = 0;
        this.searchField = new EditBox(this.f_96547_, this.getGuiLeft() + 116, this.getGuiTop() + 36, 103, 9, (Component)Component.m_237119_());
        this.searchField.m_94182_(false);
        this.searchField.m_94151_(s -> {
            if (s.isEmpty()) {
                return;
            }
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        });
        this.m_142416_((GuiEventListener)this.searchField);
        this.evolutions = new Cached(() -> {
            Race race = TensuraPlayerCapability.getRace((LivingEntity)this.player);
            if (race == null || race.getNextEvolutions(this.player).isEmpty()) {
                return new ArrayList();
            }
            ArrayList<Race> filteredRaceList = new ArrayList<Race>(race.getNextEvolutions(this.player));
            if (!this.searchField.m_94155_().isEmpty() && !this.searchField.m_94155_().isBlank()) {
                String filterValue = this.searchField.m_94155_().toLowerCase();
                filteredRaceList.removeIf(race1 -> {
                    if (race1.getName() == null) {
                        return true;
                    }
                    return !race1.getName().getString().toLowerCase().contains(filterValue);
                });
            } else {
                filteredRaceList.removeIf(race1 -> !(race1 instanceof Race));
            }
            return filteredRaceList;
        }, info -> {
            if (info.lastCallbackReference == null || !((String)info.lastCallbackReference).equals(this.searchField.m_94155_())) {
                info.lastCallbackReference = this.searchField.m_94155_();
                info.needsUpdate = true;
            }
            return info;
        });
        ImagePredicateButton trackButton = new ImagePredicateButton(0, 0, 43, 13, TRACK_BUTTON, button -> {
            if (this.selectedRace != null && this.selectedRace != this.trackedRace) {
                TensuraNetwork.INSTANCE.sendToServer((Object)new SetTrackedEvolutionPacket(this.selectedRace));
                this.updateRaceVariables(this.selectedRace, true);
            }
        }, (button, poseStack, i, i1) -> {}, ((EvolutionMenu)this.f_97732_)::check);
        trackButton.f_93620_ = this.getGuiLeft() + 98;
        trackButton.f_93621_ = this.getGuiTop() + 142;
        trackButton.hideToolTip();
        this.m_142416_((GuiEventListener)trackButton);
    }

    protected void m_7286_(PoseStack pPoseStack, float pPartialTick, int pMouseX, int pMouseY) {
        this.m_7333_(pPoseStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(pPoseStack, x, y, 0, 0, this.f_97726_, this.f_97727_);
        TensuraGUIHelper.renderTabIcon(pPoseStack, this, 0, pMouseX, pMouseY);
        this.renderInfo(pPoseStack, pMouseX, pMouseY);
        InventoryScreen.m_98850_((int)(this.getGuiLeft() + 33), (int)(this.getGuiTop() + 122), (int)30, (float)(this.getGuiLeft() + 33 - pMouseX), (float)(this.getGuiTop() + 122 - 50 - pMouseY), (LivingEntity)this.player);
        int k = (int)(25.0f * this.scrollOffs);
        RenderSystem.m_157456_((int)0, (ResourceLocation)SCROLL_BAR);
        EvolutionScreen.m_93133_((PoseStack)pPoseStack, (int)(this.f_97735_ + 211), (int)(this.f_97736_ + 49 + k), (float)0.0f, (float)(this.isScrollBarActive() ? 13.0f : 0.0f), (int)10, (int)13, (int)10, (int)26);
        List<Race> filteredRaces = this.evolutions.getValue();
        int lastVisibleElementIndex = Math.min(this.startIndex + 3, filteredRaces.size());
        this.renderButtons(pPoseStack, pMouseX, pMouseY, lastVisibleElementIndex, filteredRaces);
    }

    private void renderButtons(PoseStack pPoseStack, int pMouseX, int pMouseY, int pLastVisibleElementIndex, List<Race> list) {
        for (int i = this.startIndex; i < pLastVisibleElementIndex && i < list.size(); ++i) {
            int x = this.getGuiLeft() + 94;
            int y = this.getGuiTop() + 48 + (i - this.startIndex) * 13;
            int offset = 0;
            boolean hovering = TensuraGUIHelper.mouseOver(pMouseX, pMouseY, x - 1, x + 113, y - 1, y + 13);
            if (hovering) {
                offset = 13;
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)RACE_BUTTON);
            EvolutionScreen.m_93133_((PoseStack)pPoseStack, (int)x, (int)y, (float)0.0f, (float)offset, (int)113, (int)13, (int)113, (int)26);
            Race race = list.get(i);
            MutableComponent name = Component.m_237115_((String)"gui.none");
            if (race.getName() != null) {
                String raceName = race.getName().getString();
                name = race == this.trackedRace ? Component.m_237113_((String)(raceName + " (TRACKED)")) : Component.m_237113_((String)raceName);
            }
            int color = race == this.trackedRace ? Optional.ofNullable(ChatFormatting.GOLD.m_126665_()).orElse(Color.YELLOW.getRGB()).intValue() : Color.WHITE.getRGB();
            TensuraGUIHelper.renderScaledShadowText(pPoseStack, this.f_96547_, (FormattedText)TensuraGUIHelper.shortenTextComponent((Component)name, 22), this.getGuiLeft() + 98, this.getGuiTop() + 52 + (i - this.startIndex) * 13, 104.0f, 9.0f, color, 2.0f, 0.01f);
            if (!hovering) continue;
            this.m_96602_(pPoseStack, (Component)name, pMouseX, pMouseY);
        }
        int x = this.getGuiLeft() + 160;
        int y = this.getGuiTop() + 142;
        boolean check1 = this.selectedRaceEvolutionProgress.equals("100%");
        boolean check2 = TensuraGUIHelper.mouseOver(pMouseX, pMouseY, x - 1, x + 43, y - 1, y + 13);
        boolean check3 = this.selectedRace == null;
        boolean check4 = Objects.requireNonNull(TensuraPlayerCapability.getRace((LivingEntity)this.player)).getNextEvolutions(this.player).isEmpty();
        int offset = check1 && check2 ? 26 : (check1 ? 13 : 0);
        MutableComponent component = Component.m_237115_((String)"tensura.evolution_menu.evolve").m_130940_(ChatFormatting.GREEN);
        MutableComponent tooltip = check3 ? Component.m_237115_((String)"tensura.main_menu.evolution_progress.select").m_130940_(ChatFormatting.AQUA) : (check4 ? Component.m_237115_((String)"tensura.main_menu.evolution_progress.none").m_130940_(ChatFormatting.GRAY) : (!check1 ? Component.m_237115_((String)"tensura.evolution_menu.requirements_fail").m_130940_(ChatFormatting.RED) : component));
        RenderSystem.m_157456_((int)0, (ResourceLocation)EVOLVE_BUTTON);
        EvolutionScreen.m_93133_((PoseStack)pPoseStack, (int)x, (int)y, (float)0.0f, (float)offset, (int)43, (int)13, (int)43, (int)39);
        if (check2) {
            this.m_96602_(pPoseStack, (Component)tooltip, pMouseX, pMouseY);
        }
        MutableComponent text = Component.m_237115_((String)"tensura.evolution_menu.track");
        int color = Color.WHITE.getRGB();
        this.f_96547_.m_92763_(pPoseStack, (Component)text, (float)(this.getGuiLeft() + 105), (float)(this.getGuiTop() + 145), color);
        text = Component.m_237115_((String)"tensura.evolution_menu.evolve");
        color = check1 ? Color.GREEN.getRGB() : Color.GRAY.getRGB();
        this.f_96547_.m_92889_(pPoseStack, (Component)text, (float)(this.getGuiLeft() + 166), (float)(this.getGuiTop() + 145), color);
    }

    private void renderInfo(PoseStack stack, int pX, int pY) {
        this.renderProgressBars(stack);
        this.renderRaceInfo(stack);
        TensuraEPCapability.getFrom((LivingEntity)this.player).ifPresent(cap -> {
            String name = TensuraEPCapability.getName((LivingEntity)this.player);
            int nameColor = TensuraPlayerCapability.isTrueDemonLord(this.player) ? ChatFormatting.DARK_PURPLE.m_126665_() : (TensuraPlayerCapability.isTrueHero((LivingEntity)this.player) ? ChatFormatting.GOLD.m_126665_().intValue() : Color.WHITE.getRGB());
            TensuraGUIHelper.renderScaledCenteredXText(this.f_96547_, stack, (Component)(name != null ? Component.m_237113_((String)name) : this.player.m_7755_()), this.getGuiLeft() + 6, this.getGuiTop() + 35, 72, 19, nameColor, false);
            FontRenderHelper.renderScaledTextInArea((PoseStack)stack, (Font)this.f_96547_, (FormattedText)Component.m_237110_((String)"tensura.main_menu.existence_points", (Object[])new Object[]{TensuraGUIHelper.shortenNumberComponent(cap.getEP())}), (float)(this.getGuiLeft() + 13), (float)(this.getGuiTop() + 144), (float)70.0f, (float)11.0f, (Color)Color.ORANGE);
            if (pX > this.getGuiLeft() + 8 && pX < this.getGuiLeft() + 82 && pY > this.getGuiTop() + 140 && pY < this.getGuiTop() + 155) {
                this.m_96602_(stack, (Component)Component.m_237113_((String)this.roundDouble.format(cap.getEP())).m_130940_(ChatFormatting.GOLD), pX, pY);
            }
        });
    }

    protected void m_7027_(PoseStack pPoseStack, int pMouseX, int pMouseY) {
    }

    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.m_7025_(pPoseStack, pMouseX, pMouseY);
    }

    protected void m_7025_(PoseStack pPoseStack, int pX, int pY) {
        if (TensuraGUIHelper.mouseOver(pX, pY, this.getGuiLeft() + 61, this.getGuiLeft() + 78, this.getGuiTop() + 51, this.getGuiTop() + 130) && this.trackedRace != null) {
            MutableComponent tooltip = this.evolutionProgress.equals("-1") ? Component.m_237115_((String)"tensura.main_menu.evolution_progress.none").m_130940_(ChatFormatting.RED) : Component.m_237110_((String)"tensura.main_menu.evolution_progress", (Object[])new Object[]{this.evolutionProgress});
            this.m_96602_(pPoseStack, (Component)tooltip, pX, pY);
        }
        if (TensuraGUIHelper.mouseOver(pX, pY, this.getGuiLeft() + 210, this.getGuiLeft() + 222, this.getGuiTop() + 90, this.getGuiTop() + 154) && this.selectedRace != null) {
            this.m_96602_(pPoseStack, (Component)Component.m_237110_((String)"tensura.main_menu.evolution_progress", (Object[])new Object[]{this.selectedRaceEvolutionProgress}), pX, pY);
        }
        if (TensuraGUIHelper.mouseOver(pX, pY, this.getGuiLeft() + 93, this.getGuiLeft() + 111, this.getGuiTop() + 34, this.getGuiTop() + 44)) {
            this.m_96602_(pPoseStack, (Component)Component.m_237115_((String)"tooltip.tensura.return"), pX, pY);
        }
        if (TensuraGUIHelper.mouseOver(pX, pY, this.getGuiLeft() + 233, this.getGuiLeft() + 256, this.getGuiTop() + 30, this.getGuiTop() + 54)) {
            this.m_96602_(pPoseStack, (Component)Component.m_237115_((String)"tensura.main_menu"), pX, pY);
        }
        super.m_7025_(pPoseStack, pX, pY);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.searchField.m_7933_(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        if (this.searchField.m_93696_() && this.searchField.m_94213_() && pKeyCode != 256) {
            return true;
        }
        if (this.f_96541_ != null) {
            if (TensuraKeybinds.MAIN_GUI.m_90832_(pKeyCode, pScanCode)) {
                this.f_96541_.m_91152_(null);
                this.f_96541_.f_91067_.m_91601_();
                return true;
            }
            if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)pKeyCode, (int)pScanCode))) {
                return true;
            }
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        this.scrolling = false;
        List<Race> evolutionList = this.evolutions.getValue();
        int lastDisplayedIndex = Math.min(this.startIndex + 3, evolutionList.size());
        for (int i = this.startIndex; i < lastDisplayedIndex; ++i) {
            int x = this.getGuiLeft() + 94;
            int y = this.getGuiTop() + 48 + (i - this.startIndex) * 13;
            if (evolutionList.size() <= i) break;
            if (!TensuraGUIHelper.mouseOver(pMouseX, pMouseY, x - 1, this.getGuiLeft() + 207, y - 1, y + 13)) continue;
            TensuraGUIHelper.playSound(SoundEvents.f_12490_, 1.0f);
            this.updateRaceVariables(evolutionList.get(i), false);
            return true;
        }
        if (TensuraGUIHelper.mouseOver(pMouseX, pMouseY, this.getGuiLeft() + 160, this.getGuiLeft() + 203, this.getGuiTop() + 142, this.getGuiTop() + 155) && this.selectedRace != null && this.selectedRaceEvolutionProgress.equals("100%")) {
            this.handleEvolution();
            return true;
        }
        if (TensuraGUIHelper.mouseOver(pMouseX, pMouseY, this.getGuiLeft() + 93, this.getGuiLeft() + 111, this.getGuiTop() + 34, this.getGuiTop() + 44)) {
            return TensuraGUIHelper.buttonClick(this.player, this, SoundEvents.f_12490_, -1);
        }
        if (TensuraGUIHelper.mouseOver(pMouseX, pMouseY, this.getGuiLeft() + 210, this.getGuiLeft() + 220, this.getGuiTop() + 47, this.getGuiTop() + 88)) {
            this.scrolling = true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            float f = (float)pDelta / (float)i;
            this.scrollOffs = Mth.m_14036_((float)(this.scrollOffs - f), (float)0.0f, (float)1.0f);
            this.startIndex = Math.max(0, Math.min(this.startIndex - (int)pDelta, this.evolutions.getValue().size() - 3));
        }
        return true;
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.getGuiTop() + 49;
            int j = i + 38;
            this.scrollOffs = (float)((pMouseY - (double)i - 6.5) / (double)((float)(j - i) - 13.0f));
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5);
            return true;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    private boolean isScrollBarActive() {
        return this.evolutions.getValue().size() > 3;
    }

    private int getOffscreenRows() {
        return this.evolutions.getValue().size() - 3;
    }

    private void handleEvolution() {
        Race race = this.selectedRace;
        if (race == null) {
            race = this.trackedRace;
        }
        if (race == null) {
            return;
        }
        if (race == this.selectedRace && !this.selectedRaceEvolutionProgress.equals("100%") || race == this.trackedRace && !this.evolutionProgress.equals("100%")) {
            return;
        }
        int index = this.evolutions.getValue().indexOf(race);
        if (TensuraGUIHelper.buttonClick(this.player, this, SoundEvents.f_12275_, index)) {
            this.updateRaceVariables(null, true);
            this.updateRaceVariables(null, false);
            this.searchField.m_94144_("");
        }
    }

    private void updateRaceVariables(@Nullable Race race, boolean tracked) {
        int evolution;
        int n = race == null ? -2 : (evolution = race.getNextEvolutions(this.player).isEmpty() ? -1 : (int)race.getEvolutionPercentage(this.player));
        if (tracked) {
            this.trackedRace = race;
        } else {
            this.selectedRace = race;
        }
        this.updateEvolutionProgress(evolution, tracked);
    }

    private void updateEvolutionProgress(int percentage, boolean tracked) {
        if (tracked) {
            this.evolutionProgress = percentage >= 100 ? "100%" : percentage + "%";
        } else {
            this.selectedRaceEvolutionProgress = percentage >= 100 ? "100%" : percentage + "%";
        }
    }

    private void renderProgressBars(PoseStack stack) {
        int pY;
        int pX;
        int barYOffset;
        int length;
        int fill;
        int evolutionPercentage;
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        if (this.trackedRace == null) {
            this.updateEvolutionProgress(-2, true);
        } else {
            evolutionPercentage = Mth.m_14045_((int)((int)this.trackedRace.getEvolutionPercentage(this.player)), (int)0, (int)100);
            fill = (int)((float)(73 * evolutionPercentage) / 100.0f);
            length = 73 - fill;
            barYOffset = 164 + length;
            pX = this.getGuiLeft() + 65;
            pY = this.getGuiTop() + 54 + length;
            this.m_93228_(stack, pX, pY, 1, barYOffset, 11, fill);
            this.updateEvolutionProgress(evolutionPercentage, true);
        }
        if (this.selectedRace == null) {
            this.updateEvolutionProgress(-2, false);
        } else {
            evolutionPercentage = Mth.m_14045_((int)((int)this.selectedRace.getEvolutionPercentage(this.player)), (int)0, (int)100);
            fill = (int)((float)(58 * evolutionPercentage) / 100.0f);
            length = 58 - fill;
            barYOffset = 164 + length;
            pX = this.getGuiLeft() + 213;
            pY = this.getGuiTop() + 93 + length;
            this.m_93228_(stack, pX, pY, 13, barYOffset, 6, fill);
            this.updateEvolutionProgress(evolutionPercentage, false);
        }
    }

    private void renderRaceInfo(PoseStack stack) {
        if (this.selectedRace == null) {
            return;
        }
        List<Component> requirements = this.selectedRace.getRequirementsForRendering(this.player);
        TensuraGUIHelper.renderScaledCenteredXText(this.f_96547_, stack, (Component)Component.m_237115_((String)"tensura.evolution_menu.requirements"), this.getGuiLeft() + 95, this.getGuiTop() + 94, 111, 10, Color.WHITE, false);
        int i = 0;
        int j = 31 / requirements.size();
        for (Component text : requirements) {
            TensuraGUIHelper.renderScaledShadowText(stack, this.f_96547_, (FormattedText)text, this.getGuiLeft() + 99, this.getGuiTop() + 107 + i, 105.0f, 9.0f, Color.WHITE.getRGB(), 2.0f, 0.01f);
            i += j;
        }
    }
}

