/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.client.screen;

import com.github.manasmods.manascore.api.client.gui.FontRenderHelper;
import com.github.manasmods.manascore.api.client.gui.widget.ImagePredicateButton;
import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.magic.Magic;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.client.TensuraGUIHelper;
import com.github.manasmods.tensura.client.keybind.TensuraKeybinds;
import com.github.manasmods.tensura.menu.MagicMenu;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2server.GUISwitchPacket;
import com.github.manasmods.tensura.network.play2server.skill.RequestAbilityPresetPacket;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class MagicScreen
extends AbstractContainerScreen<MagicMenu> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("tensura", "textures/gui/magic/magic_gui_main.png");
    public static final ResourceLocation PRESET_BUTTON = new ResourceLocation("tensura", "textures/gui/skill/preset_button.png");
    private static final ResourceLocation COMING_SOON = new ResourceLocation("tensura", "textures/gui/magic/coming_soon_button.png");
    private static final ResourceLocation SPIRITUAL = new ResourceLocation("tensura", "textures/gui/magic/spiritual_magic_button.png");
    private static final ResourceLocation SUMMONING = new ResourceLocation("tensura", "textures/gui/magic/summoning_magic_button.png");
    private List<String> presetNames = new ArrayList<String>();
    private ManasSkill slot1;
    private ManasSkill slot2;
    private ManasSkill slot3;
    private int selectedPreset = 0;
    private final EditBox presetName;
    private final Player player;

    public MagicScreen(MagicMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, (Component)pTitle.m_6881_().m_130940_(ChatFormatting.WHITE));
        this.presetName = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, 94, 13, (Component)Component.m_237119_());
        this.f_97726_ = 254;
        this.f_97727_ = 163;
        this.player = pPlayerInventory.f_35978_;
    }

    protected void m_7856_() {
        super.m_7856_();
        TensuraSkillCapability.getFrom(this.player).ifPresent(cap -> {
            this.selectedPreset = cap.getActivePreset();
            this.presetNames = cap.getPresetNames();
        });
        this.m_142416_((GuiEventListener)this.presetName);
        this.presetName.m_94182_(false);
        this.presetName.m_94202_(0xFFFFFF);
        this.presetName.m_94199_(20);
        this.presetName.f_93620_ = this.getGuiLeft() + 130;
        this.presetName.f_93621_ = this.getGuiTop() + 63;
        for (int i = 0; i < 9; ++i) {
            Magic.MagicType type;
            int j = i;
            ImagePredicateButton imagePredicateButton = new ImagePredicateButton(0, 0, 10, 11, PRESET_BUTTON, pButton -> {
                if (this.selectedPreset == j) {
                    TensuraNetwork.INSTANCE.sendToServer((Object)new RequestAbilityPresetPacket(j, true));
                    return;
                }
                this.selectedPreset = j;
                this.loadPreset();
            }, (pButton, pPoseStack1, pMouseX1, pMouseY1) -> this.m_96602_(pPoseStack1, (Component)Component.m_237113_((String)this.presetNames.get(j)), pMouseX1, pMouseY1), ((MagicMenu)this.f_97732_)::check);
            imagePredicateButton.f_93620_ = this.getGuiLeft() + 128 + i * 10;
            imagePredicateButton.f_93621_ = this.getGuiTop() + 40;
            this.m_142416_((GuiEventListener)imagePredicateButton);
            if (i >= 5) continue;
            ResourceLocation texture = switch (i) {
                case 1 -> {
                    type = Magic.MagicType.SPIRITUAL;
                    yield SPIRITUAL;
                }
                case 3 -> {
                    type = Magic.MagicType.SUMMONING;
                    yield SUMMONING;
                }
                default -> {
                    type = null;
                    yield COMING_SOON;
                }
            };
            Component name = type == null ? SkillHelper.comingSoon() : type.getName();
            GUISwitchPacket packet = type == null ? new GUISwitchPacket(-2) : new GUISwitchPacket(type);
            ImagePredicateButton magicTab = new ImagePredicateButton(0, 0, 32, 32, texture, pButton -> TensuraNetwork.INSTANCE.sendToServer((Object)packet), (pButton, pPoseStack1, pMouseX, pMouseY) -> this.m_96602_(pPoseStack1, name, pMouseX, pMouseY), ((MagicMenu)this.f_97732_)::check);
            if (i == 4) {
                magicTab.f_93620_ = this.getGuiLeft() + 41;
            } else {
                int n = magicTab.f_93620_ = i % 2 == 0 ? this.getGuiLeft() + 19 : this.getGuiLeft() + 63;
            }
            magicTab.f_93621_ = i < 2 ? this.getGuiTop() + 45 : (i < 4 ? this.getGuiTop() + 83 : this.getGuiTop() + 121);
            this.m_142416_((GuiEventListener)magicTab);
        }
        ImmutableList<ImagePredicateButton> buttons = TensuraGUIHelper.addMenuTabs(this, 5, true);
        for (ImagePredicateButton button : buttons) {
            this.m_142416_((GuiEventListener)button);
        }
        this.loadPreset();
    }

    protected void m_7286_(PoseStack pPoseStack, float pPartialTick, int pMouseX, int pMouseY) {
        this.m_7333_(pPoseStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(pPoseStack, x, y, 0, 0, this.f_97726_, this.f_97727_);
        TensuraGUIHelper.renderTabIcon(pPoseStack, this, 5, pMouseX, pMouseY);
        for (int i = 0; i < 9; ++i) {
            if (i < 3) {
                ManasSkill manasSkill;
                ManasSkill manasSkill2 = i == 0 ? this.slot1 : (manasSkill = i == 1 ? this.slot2 : this.slot3);
                if (manasSkill != null) {
                    boolean hovering;
                    MutableComponent name = this.skillName(manasSkill);
                    ManasSkillInstance instance = this.getSkillInstance(manasSkill);
                    if (instance != null && instance.getMastery() < 0) {
                        name = name.m_130940_(ChatFormatting.GRAY);
                    } else if (manasSkill instanceof Skill) {
                        Skill skill = (Skill)manasSkill;
                        name = name.m_130940_(skill.getType().getChatFormatting());
                    }
                    int xName = this.getGuiLeft() + 149;
                    int yName = this.getGuiTop() + 88 + i * 22;
                    FontRenderHelper.renderScaledTextInArea((PoseStack)pPoseStack, (Font)this.f_96547_, (FormattedText)TensuraGUIHelper.shortenTextComponent((Component)name, 11), (float)xName, (float)yName, (float)69.0f, (float)10.0f, (Color)Color.CYAN);
                    ResourceLocation icon = manasSkill.getSkillIcon();
                    if (icon != null) {
                        RenderSystem.m_157456_((int)0, (ResourceLocation)icon);
                        MagicScreen.m_93133_((PoseStack)pPoseStack, (int)(this.getGuiLeft() + 128), (int)(this.getGuiTop() + 83 + i * 22), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
                    }
                    boolean bl = hovering = pMouseX >= xName - 22 && pMouseY >= yName - 6 && pMouseX < xName + 71 && pMouseY < yName + 16;
                    if (hovering) {
                        this.m_96602_(pPoseStack, (Component)name, pMouseX, pMouseY);
                    }
                }
            }
            TensuraGUIHelper.renderScaledCenteredXText(this.f_96547_, pPoseStack, (Component)Component.m_237113_((String)String.valueOf(i + 1)), this.getGuiLeft() + 128 + i * 10, this.getGuiTop() + 42, 10, 11, Color.LIGHT_GRAY, true);
        }
        this.m_7025_(pPoseStack, pMouseX, pMouseY);
    }

    protected void m_7027_(PoseStack pPoseStack, int pMouseX, int pMouseY) {
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.presetName.m_7933_(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        if (this.presetName.m_93696_() && this.presetName.m_94213_() && pKeyCode != 256) {
            return true;
        }
        if (this.f_96541_ != null) {
            if (TensuraKeybinds.MAIN_GUI.m_90832_(pKeyCode, pScanCode)) {
                this.f_96541_.m_91152_(null);
                this.f_96541_.f_91067_.m_91601_();
                return true;
            }
            if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)pKeyCode, (int)pScanCode))) {
                return true;
            }
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (!(pMouseX > (double)this.presetName.f_93620_ && pMouseX < (double)(this.presetName.f_93620_ + this.presetName.m_5711_()) && pMouseY > (double)this.presetName.f_93621_ && pMouseY < (double)(this.presetName.f_93621_ + this.presetName.m_93694_()))) {
            this.savePresetName();
        }
        if (TensuraGUIHelper.mouseOver(pMouseX, pMouseY, this.getGuiLeft() + 5, this.getGuiLeft() + 23, this.getGuiTop() + 28, this.getGuiTop() + 38)) {
            TensuraGUIHelper.playSound(SoundEvents.f_12490_, 1.0f);
            TensuraNetwork.INSTANCE.sendToServer((Object)new GUISwitchPacket(0));
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    protected void m_7025_(PoseStack pPoseStack, int pX, int pY) {
        if (TensuraGUIHelper.mouseOver(pX, pY, this.getGuiLeft() + 5, this.getGuiLeft() + 23, this.getGuiTop() + 28, this.getGuiTop() + 38)) {
            this.m_96602_(pPoseStack, (Component)Component.m_237115_((String)"tooltip.tensura.return"), pX, pY);
        }
        super.m_7025_(pPoseStack, pX, pY);
    }

    public void m_7379_() {
        this.savePresetName();
        super.m_7379_();
    }

    private MutableComponent skillName(@Nullable ManasSkill skill) {
        if (skill == null || skill.getName() == null) {
            return Component.m_237115_((String)"tensura.race.selection.skills.empty");
        }
        return skill.getName();
    }

    private void loadPreset() {
        this.presetName.m_94144_(this.presetNames.get(this.selectedPreset));
        TensuraSkillCapability.getFrom(this.player).ifPresent(cap -> {
            this.slot1 = cap.getSkillInPresetSlot(this.selectedPreset, 0);
            this.slot2 = cap.getSkillInPresetSlot(this.selectedPreset, 1);
            this.slot3 = cap.getSkillInPresetSlot(this.selectedPreset, 2);
        });
    }

    private void savePresetName() {
        TensuraSkillCapability.getFrom(this.player).ifPresent(cap -> {
            if (!this.presetName.m_94155_().equals(cap.getPresetName(this.selectedPreset))) {
                TensuraNetwork.INSTANCE.sendToServer((Object)new RequestAbilityPresetPacket(this.presetName.m_94155_(), this.selectedPreset));
                this.presetNames.set(this.selectedPreset, this.presetName.m_94155_());
            }
        });
    }

    @Nullable
    private ManasSkillInstance getSkillInstance(ManasSkill skill) {
        Optional instance = SkillAPI.getSkillsFrom((Entity)this.player).getSkill(skill);
        return instance.orElse(null);
    }
}

