/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.client.screen;

import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.client.TensuraGUIHelper;
import com.github.manasmods.tensura.menu.SpatialStorageMenu;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class SpatialStorageScreen
extends AbstractContainerScreen<SpatialStorageMenu> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("tensura", "textures/gui/spatial_storage/spatial_storage.png");
    private static final ResourceLocation SCROLL_BAR = new ResourceLocation("tensura", "textures/gui/scroll_bar.png");
    private static final ResourceLocation WATER_BAR = new ResourceLocation("tensura", "textures/gui/spatial_storage/water_bar.png");
    private static final ResourceLocation LAVA_BAR = new ResourceLocation("tensura", "textures/gui/spatial_storage/lava_bar.png");
    private final Player player;
    private boolean scrolling;
    private float scrollOffs;
    private int startIndex;

    public SpatialStorageScreen(SpatialStorageMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.player = pPlayerInventory.f_35978_;
        this.f_97726_ = 256;
        this.f_97727_ = 174;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.scrollOffs = 0.0f;
        this.startIndex = 0;
    }

    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_7333_(pPoseStack);
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.m_7025_(pPoseStack, pMouseX, pMouseY);
    }

    protected void m_7027_(PoseStack pPoseStack, int pMouseX, int pMouseY) {
        TensuraGUIHelper.renderCenteredXText(this.f_96547_, pPoseStack, this.f_96539_, 0, this.f_97729_ - 2, 176, Color.WHITE, false);
    }

    protected void m_7286_(PoseStack pPoseStack, float pPartialTick, int pX, int pY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(pPoseStack, x - 29, y - 6, 0, 0, 256, 174);
        int k = (int)(39.0f * this.scrollOffs);
        RenderSystem.m_157456_((int)0, (ResourceLocation)SCROLL_BAR);
        SpatialStorageScreen.m_93133_((PoseStack)pPoseStack, (int)(this.f_97735_ + 165), (int)(this.f_97736_ + 19 + k), (float)0.0f, (float)(this.isScrollBarActive() ? 13.0f : 0.0f), (int)10, (int)13, (int)10, (int)26);
        this.renderWaterBar(pPoseStack);
        this.renderLavaBar(pPoseStack);
    }

    protected void m_7025_(PoseStack pPoseStack, int pX, int pY) {
        if (TensuraGUIHelper.mouseOver(pX, pY, this.getGuiLeft() - 19, this.getGuiLeft() - 9, this.getGuiTop() + 24, this.getGuiTop() + 138)) {
            MutableComponent tooltip = Component.m_237113_((String)(TensuraSkillCapability.getWaterPoint((LivingEntity)this.player) + "/10000")).m_130940_(ChatFormatting.AQUA);
            this.m_96602_(pPoseStack, (Component)tooltip, pX, pY);
        } else if (TensuraGUIHelper.mouseOver(pX, pY, this.getGuiLeft() + 185, this.getGuiLeft() + 195, this.getGuiTop() + 24, this.getGuiTop() + 138)) {
            MutableComponent tooltip = Component.m_237113_((String)(TensuraSkillCapability.getLavaPoint((LivingEntity)this.player) + "/10000")).m_130940_(ChatFormatting.RED);
            this.m_96602_(pPoseStack, (Component)tooltip, pX, pY);
        }
        super.m_7025_(pPoseStack, pX, pY);
    }

    private void renderWaterBar(PoseStack stack) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)WATER_BAR);
        double waterPoint = TensuraSkillCapability.getWaterPoint((LivingEntity)this.player);
        int waterBar = Mth.m_14045_((int)((int)waterPoint), (int)0, (int)10000);
        int fill = (int)((float)(112 * waterBar) / 10000.0f);
        int length = 112 - fill;
        int barYOffset = 118 + length;
        int pX = this.getGuiLeft() - 19;
        int pY = this.getGuiTop() + 25 + length;
        SpatialStorageScreen.m_93133_((PoseStack)stack, (int)pX, (int)pY, (float)0.0f, (float)barYOffset, (int)10, (int)fill, (int)10, (int)112);
    }

    private void renderLavaBar(PoseStack stack) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)LAVA_BAR);
        double lavaPoint = TensuraSkillCapability.getLavaPoint((LivingEntity)this.player);
        int waterBar = Mth.m_14045_((int)((int)lavaPoint), (int)0, (int)10000);
        int fill = (int)((float)(112 * waterBar) / 10000.0f);
        int length = 112 - fill;
        int barYOffset = 118 + length;
        int pX = this.getGuiLeft() + 185;
        int pY = this.getGuiTop() + 25 + length;
        SpatialStorageScreen.m_93133_((PoseStack)stack, (int)pX, (int)pY, (float)0.0f, (float)barYOffset, (int)10, (int)fill, (int)10, (int)112);
    }

    public boolean m_6375_(double pX, double pY, int pButton) {
        this.scrolling = pX >= (double)(this.getGuiLeft() + 165) && pX < (double)(this.getGuiLeft() + 171) && pY >= (double)(this.getGuiTop() + 19) && pY < (double)(this.getGuiTop() + 83);
        return super.m_6375_(pX, pY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.f_97736_ + 19;
            int j = i + 52;
            this.scrollOffs = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * 9;
            this.updateStartIndex(this.player, this.startIndex);
            return true;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            float f = (float)pDelta / (float)i;
            this.scrollOffs = Mth.m_14036_((float)(this.scrollOffs - f), (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5) * 9;
            this.updateStartIndex(this.player, this.startIndex);
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return ((SpatialStorageMenu)this.f_97732_).getStorageSize() > 27;
    }

    protected int getOffscreenRows() {
        return (((SpatialStorageMenu)this.f_97732_).getStorageSize() + 9 - 1) / 9 - 3;
    }

    public void updateStartIndex(Player player, int ID) {
        MultiPlayerGameMode gameMode = Minecraft.m_91087_().f_91072_;
        ((SpatialStorageMenu)this.m_6262_()).m_6366_(player, ID);
        if (gameMode == null) {
            return;
        }
        gameMode.m_105208_(((SpatialStorageMenu)this.m_6262_()).f_38840_, ID);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.f_96541_ != null) {
            if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)pKeyCode, (int)pScanCode))) {
                return true;
            }
            if (this.f_96541_.f_91066_.f_92093_.isActiveAndMatches(InputConstants.m_84827_((int)pKeyCode, (int)pScanCode))) {
                return true;
            }
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }
}

