/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.command;

import com.github.manasmods.tensura.enchantment.EngravingEnchantment;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ItemEnchantmentArgument;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tensura", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EngraveCommand {
    private static final DynamicCommandExceptionType ERROR_NOT_LIVING_ENTITY = new DynamicCommandExceptionType(o -> Component.m_237115_((String)"commands.enchant.failed.entity"));
    private static final DynamicCommandExceptionType ERROR_NO_ITEM = new DynamicCommandExceptionType(translatable -> Component.m_237115_((String)"commands.enchant.failed.itemless"));
    private static final SimpleCommandExceptionType ERROR_NOTHING_HAPPENED = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.enchant.failed"));
    public static final SuggestionProvider<CommandSourceStack> ENGRAVING_ENCHANTMENTS = (context, builder) -> SharedSuggestionProvider.m_82957_(Registry.f_122825_.m_6579_().stream().filter(enchantment -> enchantment.getValue() instanceof EngravingEnchantment).map(skill -> ((ResourceKey)skill.getKey()).m_135782_()), (SuggestionsBuilder)builder);

    @SubscribeEvent
    public static void register(RegisterCommandsEvent e) {
        e.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"engrave").requires(stack -> stack.m_6761_(2))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"enchantment", (ArgumentType)ItemEnchantmentArgument.m_95260_()).suggests(ENGRAVING_ENCHANTMENTS).executes(context -> EngraveCommand.engrave((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), ItemEnchantmentArgument.m_95263_((CommandContext)context, (String)"enchantment"), 1))).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> EngraveCommand.engrave((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), ItemEnchantmentArgument.m_95263_((CommandContext)context, (String)"enchantment"), IntegerArgumentType.getInteger((CommandContext)context, (String)"level")))))));
    }

    private static int engrave(CommandSourceStack pSource, Collection<? extends Entity> pTargets, Enchantment enchantment, int pLevel) throws CommandSyntaxException {
        int i = 0;
        for (Entity entity : pTargets) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                ItemStack itemstack = livingentity.m_21205_();
                if (!itemstack.m_41619_()) {
                    EngravingEnchantment.engrave(itemstack, enchantment, pLevel);
                    ++i;
                    continue;
                }
                if (pTargets.size() != 1) continue;
                throw ERROR_NO_ITEM.create((Object)livingentity.m_7755_().getString());
            }
            if (pTargets.size() != 1) continue;
            throw ERROR_NOT_LIVING_ENTITY.create((Object)entity.m_7755_().getString());
        }
        if (i == 0) {
            throw ERROR_NOTHING_HAPPENED.create();
        }
        if (pTargets.size() == 1) {
            pSource.m_81354_((Component)Component.m_237110_((String)"commands.enchant.success.single", (Object[])new Object[]{enchantment.m_44700_(pLevel), pTargets.iterator().next().m_5446_()}), true);
        } else {
            pSource.m_81354_((Component)Component.m_237110_((String)"commands.enchant.success.multiple", (Object[])new Object[]{enchantment.m_44700_(pLevel), pTargets.size()}), true);
        }
        return i;
    }
}

